/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.handler;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import java.lang.reflect.Method;
import java.util.Deque;
import java.util.concurrent.LinkedBlockingDeque;
import org.xml.sax.Attributes;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public abstract class SimpleHandler
extends DefaultHandler {
    private static final ILogger LOG = LoggerBuilder.getLogger(SimpleHandler.class);
    protected XMLReader xr = null;
    private StringBuilder textBuffer = null;
    private Deque<SimpleHandler> handlerStack = new LinkedBlockingDeque<SimpleHandler>();

    public SimpleHandler(XMLReader xr) {
        this.xr = xr;
        this.textBuffer = new StringBuilder();
        this.handlerStack.push(this);
    }

    public void transferControl(SimpleHandler toHandler) {
        toHandler.setHandlerStack(this.handlerStack);
        this.handlerStack.push(toHandler);
        this.setReaderHandler(this.handlerStack.peek());
    }

    public void returnControlToParentHandler() {
        if (this.hasParentHandler()) {
            this.handlerStack.removeFirst();
            this.handlerStack.peek().controlReturned(this);
            this.setReaderHandler(this.handlerStack.peek());
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("this class has no parent: " + this.getClass().getName());
        }
    }

    public boolean hasParentHandler() {
        return this.handlerStack.size() >= 2;
    }

    public void controlReturned(SimpleHandler childHandler) {
    }

    public void setHandlerStack(Deque<SimpleHandler> handlerStack) {
        this.handlerStack = handlerStack;
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes attrs) {
        this.invokeMethodWithoutException("start" + name, null);
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        String elementContent = this.textBuffer.toString().trim();
        this.invokeMethodWithoutException("end" + name, elementContent);
        this.textBuffer = new StringBuilder();
    }

    private void setReaderHandler(SimpleHandler handler) {
        this.xr.setContentHandler(handler);
        this.xr.setErrorHandler(handler);
    }

    private void invokeMethodWithoutException(String methodName, String parameter) {
        block7: {
            SimpleHandler handler = this.handlerStack.peek();
            if (null == handler) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("non-existent SimpleHandler in " + this.getClass().getName());
                }
                return;
            }
            Class[] clazz = new Class[]{};
            Object[] parameters = new Object[]{};
            if (null != parameter) {
                clazz = new Class[]{String.class};
                parameters = new Object[]{parameter};
            }
            try {
                Method method = handler.getClass().getMethod(methodName, clazz);
                method.invoke((Object)handler, parameters);
            }
            catch (NoSuchMethodException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("non-existent SimpleHandler subclass's method for '" + methodName + "' in " + this.getClass().getName());
                }
            }
            catch (Throwable t) {
                if (!LOG.isErrorEnabled()) break block7;
                LOG.error("Unable to invoke SimpleHandler subclass's method for '" + methodName + "' in " + this.getClass().getName(), t);
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.textBuffer.append(ch, start, length);
    }
}

