/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services;

import com.obs.log.ILogger;
import com.obs.log.InterfaceLogBean;
import com.obs.log.LoggerBuilder;
import com.obs.services.IFSClient;
import com.obs.services.IObsClient;
import com.obs.services.IObsCredentialsProvider;
import com.obs.services.ObsConfiguration;
import com.obs.services.exception.ObsException;
import com.obs.services.internal.ObsProperties;
import com.obs.services.internal.ObsService;
import com.obs.services.internal.ResumableClient;
import com.obs.services.internal.ServiceException;
import com.obs.services.internal.consensus.CacheManager;
import com.obs.services.internal.consensus.SegmentLock;
import com.obs.services.internal.security.ProviderCredentials;
import com.obs.services.internal.task.DefaultTaskProgressStatus;
import com.obs.services.internal.task.DropFolderTask;
import com.obs.services.internal.task.LazyTaksCallback;
import com.obs.services.internal.task.PutObjectTask;
import com.obs.services.internal.task.RestoreObjectTask;
import com.obs.services.internal.task.ResumableUploadTask;
import com.obs.services.internal.task.UploadTaskProgressStatus;
import com.obs.services.internal.utils.AccessLoggerUtils;
import com.obs.services.internal.utils.ReflectUtils;
import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.model.AbortMultipartUploadRequest;
import com.obs.services.model.AccessControlList;
import com.obs.services.model.AppendObjectRequest;
import com.obs.services.model.AppendObjectResult;
import com.obs.services.model.AuthTypeEnum;
import com.obs.services.model.BaseBucketRequest;
import com.obs.services.model.BucketCors;
import com.obs.services.model.BucketDirectColdAccess;
import com.obs.services.model.BucketEncryption;
import com.obs.services.model.BucketLocationResponse;
import com.obs.services.model.BucketLoggingConfiguration;
import com.obs.services.model.BucketMetadataInfoRequest;
import com.obs.services.model.BucketMetadataInfoResult;
import com.obs.services.model.BucketNotificationConfiguration;
import com.obs.services.model.BucketPolicyResponse;
import com.obs.services.model.BucketQuota;
import com.obs.services.model.BucketStorageInfo;
import com.obs.services.model.BucketStoragePolicyConfiguration;
import com.obs.services.model.BucketTagInfo;
import com.obs.services.model.BucketVersioningConfiguration;
import com.obs.services.model.CompleteMultipartUploadRequest;
import com.obs.services.model.CompleteMultipartUploadResult;
import com.obs.services.model.CopyObjectRequest;
import com.obs.services.model.CopyObjectResult;
import com.obs.services.model.CopyPartRequest;
import com.obs.services.model.CopyPartResult;
import com.obs.services.model.CreateBucketRequest;
import com.obs.services.model.DeleteObjectRequest;
import com.obs.services.model.DeleteObjectResult;
import com.obs.services.model.DeleteObjectsRequest;
import com.obs.services.model.DeleteObjectsResult;
import com.obs.services.model.DownloadFileRequest;
import com.obs.services.model.DownloadFileResult;
import com.obs.services.model.ExtensionObjectPermissionEnum;
import com.obs.services.model.GetObjectAclRequest;
import com.obs.services.model.GetObjectMetadataRequest;
import com.obs.services.model.GetObjectRequest;
import com.obs.services.model.HeaderResponse;
import com.obs.services.model.HttpMethodEnum;
import com.obs.services.model.InitiateMultipartUploadRequest;
import com.obs.services.model.InitiateMultipartUploadResult;
import com.obs.services.model.KeyAndVersion;
import com.obs.services.model.LifecycleConfiguration;
import com.obs.services.model.ListBucketsRequest;
import com.obs.services.model.ListBucketsResult;
import com.obs.services.model.ListMultipartUploadsRequest;
import com.obs.services.model.ListObjectsRequest;
import com.obs.services.model.ListPartsRequest;
import com.obs.services.model.ListPartsResult;
import com.obs.services.model.ListVersionsRequest;
import com.obs.services.model.ListVersionsResult;
import com.obs.services.model.ModifyObjectRequest;
import com.obs.services.model.ModifyObjectResult;
import com.obs.services.model.MonitorableProgressListener;
import com.obs.services.model.MultipartUploadListing;
import com.obs.services.model.ObjectListing;
import com.obs.services.model.ObjectMetadata;
import com.obs.services.model.ObsBucket;
import com.obs.services.model.ObsObject;
import com.obs.services.model.OptionsInfoRequest;
import com.obs.services.model.OptionsInfoResult;
import com.obs.services.model.PolicyConditionItem;
import com.obs.services.model.PolicyTempSignatureRequest;
import com.obs.services.model.PostSignatureRequest;
import com.obs.services.model.PostSignatureResponse;
import com.obs.services.model.ProgressListener;
import com.obs.services.model.ProgressStatus;
import com.obs.services.model.PutObjectBasicRequest;
import com.obs.services.model.PutObjectRequest;
import com.obs.services.model.PutObjectResult;
import com.obs.services.model.PutObjectsRequest;
import com.obs.services.model.ReadAheadQueryResult;
import com.obs.services.model.ReadAheadRequest;
import com.obs.services.model.ReadAheadResult;
import com.obs.services.model.RenameObjectRequest;
import com.obs.services.model.RenameObjectResult;
import com.obs.services.model.ReplicationConfiguration;
import com.obs.services.model.RequestPaymentConfiguration;
import com.obs.services.model.RequestPaymentEnum;
import com.obs.services.model.RestoreObjectRequest;
import com.obs.services.model.RestoreObjectResult;
import com.obs.services.model.RestoreObjectsRequest;
import com.obs.services.model.RestoreTierEnum;
import com.obs.services.model.S3Bucket;
import com.obs.services.model.S3BucketCors;
import com.obs.services.model.SetBucketAclRequest;
import com.obs.services.model.SetBucketCorsRequest;
import com.obs.services.model.SetBucketDirectColdAccessRequest;
import com.obs.services.model.SetBucketEncryptionRequest;
import com.obs.services.model.SetBucketLifecycleRequest;
import com.obs.services.model.SetBucketLoggingRequest;
import com.obs.services.model.SetBucketNotificationRequest;
import com.obs.services.model.SetBucketPolicyRequest;
import com.obs.services.model.SetBucketQuotaRequest;
import com.obs.services.model.SetBucketReplicationRequest;
import com.obs.services.model.SetBucketRequestPaymentRequest;
import com.obs.services.model.SetBucketStoragePolicyRequest;
import com.obs.services.model.SetBucketTaggingRequest;
import com.obs.services.model.SetBucketVersioningRequest;
import com.obs.services.model.SetBucketWebsiteRequest;
import com.obs.services.model.SetObjectAclRequest;
import com.obs.services.model.SetObjectMetadataRequest;
import com.obs.services.model.SpecialParamEnum;
import com.obs.services.model.SseCHeader;
import com.obs.services.model.SseKmsHeader;
import com.obs.services.model.StorageClassEnum;
import com.obs.services.model.TaskCallback;
import com.obs.services.model.TaskProgressListener;
import com.obs.services.model.TaskProgressStatus;
import com.obs.services.model.TemporarySignatureRequest;
import com.obs.services.model.TemporarySignatureResponse;
import com.obs.services.model.TruncateObjectRequest;
import com.obs.services.model.TruncateObjectResult;
import com.obs.services.model.UploadFileRequest;
import com.obs.services.model.UploadObjectsProgressListener;
import com.obs.services.model.UploadPartRequest;
import com.obs.services.model.UploadPartResult;
import com.obs.services.model.UploadProgressStatus;
import com.obs.services.model.V4PostSignatureRequest;
import com.obs.services.model.V4PostSignatureResponse;
import com.obs.services.model.V4TemporarySignatureRequest;
import com.obs.services.model.V4TemporarySignatureResponse;
import com.obs.services.model.VersionOrDeleteMarker;
import com.obs.services.model.WebsiteConfiguration;
import com.obs.services.model.fs.DropFileRequest;
import com.obs.services.model.fs.DropFileResult;
import com.obs.services.model.fs.DropFolderRequest;
import com.obs.services.model.fs.GetAttributeRequest;
import com.obs.services.model.fs.GetBucketFSStatusRequest;
import com.obs.services.model.fs.GetBucketFSStatusResult;
import com.obs.services.model.fs.ListContentSummaryRequest;
import com.obs.services.model.fs.ListContentSummaryResult;
import com.obs.services.model.fs.NewBucketRequest;
import com.obs.services.model.fs.NewFileRequest;
import com.obs.services.model.fs.NewFolderRequest;
import com.obs.services.model.fs.ObsFSAttribute;
import com.obs.services.model.fs.ObsFSBucket;
import com.obs.services.model.fs.ObsFSFile;
import com.obs.services.model.fs.ObsFSFolder;
import com.obs.services.model.fs.ReadFileRequest;
import com.obs.services.model.fs.ReadFileResult;
import com.obs.services.model.fs.RenameRequest;
import com.obs.services.model.fs.RenameResult;
import com.obs.services.model.fs.SetBucketFSStatusRequest;
import com.obs.services.model.fs.TruncateFileRequest;
import com.obs.services.model.fs.TruncateFileResult;
import com.obs.services.model.fs.WriteFileRequest;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ObsClient
extends ObsService
implements Closeable,
IObsClient,
IFSClient {
    private static final ILogger ILOG = LoggerBuilder.getLogger(ObsClient.class);

    private void init(String accessKey, String secretKey, String securityToken, ObsConfiguration config) {
        InterfaceLogBean reqBean = new InterfaceLogBean("ObsClient", config.getEndPoint(), "");
        ProviderCredentials credentials = new ProviderCredentials(accessKey, secretKey, securityToken);
        ObsProperties obsProperties = ServiceUtils.changeFromObsConfiguration(config);
        credentials.setAuthType(config.getAuthType());
        this.obsProperties = obsProperties;
        this.credentials = credentials;
        this.obsProperties = obsProperties;
        this.keyManagerFactory = config.getKeyManagerFactory();
        this.trustManagerFactory = config.getTrustManagerFactory();
        if (this.isAuthTypeNegotiation()) {
            this.apiVersionCache = new CacheManager();
            this.getProviderCredentials().initThreadLocalAuthType();
            this.segmentLock = new SegmentLock();
        }
        this.initHttpClient(config.getHttpDispatcher());
        reqBean.setRespTime(new Date());
        reqBean.setResultCode("0");
        if (ILOG.isInfoEnabled()) {
            ILOG.info(reqBean);
        }
        if (ILOG.isWarnEnabled()) {
            StringBuilder sb = new StringBuilder("[OBS SDK Version=");
            sb.append("3.20.6.2");
            sb.append("];");
            sb.append("[Endpoint=");
            String ep = "";
            ep = this.getHttpsOnly() ? "https://" + this.getEndpoint() + ":" + this.getHttpsPort() + "/" : "http://" + this.getEndpoint() + ":" + this.getHttpPort() + "/";
            sb.append(ep);
            sb.append("];");
            sb.append("[Access Mode=");
            sb.append(this.isPathStyle() ? "Path" : "Virtul Hosting");
            sb.append("]");
            ILOG.warn(sb);
        }
    }

    public ObsClient(String endPoint) {
        ObsConfiguration config = new ObsConfiguration();
        config.setEndPoint(endPoint);
        this.init("", "", null, config);
    }

    public ObsClient(ObsConfiguration config) {
        if (config == null) {
            config = new ObsConfiguration();
        }
        this.init("", "", null, config);
    }

    public ObsClient(String accessKey, String secretKey, String endPoint) {
        ObsConfiguration config = new ObsConfiguration();
        config.setEndPoint(endPoint);
        this.init(accessKey, secretKey, null, config);
    }

    public ObsClient(String accessKey, String secretKey, ObsConfiguration config) {
        if (config == null) {
            config = new ObsConfiguration();
        }
        this.init(accessKey, secretKey, null, config);
    }

    public ObsClient(String accessKey, String secretKey, String securityToken, String endPoint) {
        ObsConfiguration config = new ObsConfiguration();
        config.setEndPoint(endPoint);
        this.init(accessKey, secretKey, securityToken, config);
    }

    public ObsClient(String accessKey, String secretKey, String securityToken, ObsConfiguration config) {
        if (config == null) {
            config = new ObsConfiguration();
        }
        this.init(accessKey, secretKey, securityToken, config);
    }

    public ObsClient(IObsCredentialsProvider provider, String endPoint) {
        ServiceUtils.asserParameterNotNull(provider, "ObsCredentialsProvider is null");
        ObsConfiguration config = new ObsConfiguration();
        config.setEndPoint(endPoint);
        this.init(provider.getSecurityKey().getAccessKey(), provider.getSecurityKey().getSecretKey(), provider.getSecurityKey().getSecurityToken(), config);
        this.credentials.setObsCredentialsProvider(provider);
    }

    public ObsClient(IObsCredentialsProvider provider, ObsConfiguration config) {
        ServiceUtils.asserParameterNotNull(provider, "ObsCredentialsProvider is null");
        if (config == null) {
            config = new ObsConfiguration();
        }
        this.init(provider.getSecurityKey().getAccessKey(), provider.getSecurityKey().getSecretKey(), provider.getSecurityKey().getSecurityToken(), config);
        this.credentials.setObsCredentialsProvider(provider);
    }

    @Override
    public void refresh(String accessKey, String secretKey, String securityToken) {
        ProviderCredentials credentials = new ProviderCredentials(accessKey, secretKey, securityToken);
        credentials.setAuthType(this.credentials.getAuthType());
        this.setProviderCredentials(credentials);
    }

    @Deprecated
    public String createSignedUrl(HttpMethodEnum method, String bucketName, String objectKey, SpecialParamEnum specialParam, Date expiryTime, Map<String, String> headers, Map<String, Object> queryParams) throws ObsException {
        return this.createSignedUrl(method, bucketName, objectKey, specialParam, expiryTime == null ? 300L : (expiryTime.getTime() - System.currentTimeMillis()) / 1000L, headers, queryParams);
    }

    @Deprecated
    public String createSignedUrl(HttpMethodEnum method, String bucketName, String objectKey, SpecialParamEnum specialParam, long expires, Map<String, String> headers, Map<String, Object> queryParams) {
        TemporarySignatureRequest request = new TemporarySignatureRequest();
        request.setMethod(method);
        request.setBucketName(bucketName);
        request.setObjectKey(objectKey);
        request.setSpecialParam(specialParam);
        request.setHeaders(headers);
        request.setQueryParams(queryParams);
        if (expires > 0L) {
            request.setExpires(expires);
        }
        return this.createTemporarySignature(request).getSignedUrl();
    }

    @Deprecated
    public V4TemporarySignatureResponse createV4TemporarySignature(V4TemporarySignatureRequest request) {
        ServiceUtils.asserParameterNotNull(request, "V4TemporarySignatureRequest is null");
        InterfaceLogBean reqBean = new InterfaceLogBean("createV4TemporarySignature", this.getEndpoint(), "");
        try {
            TemporarySignatureResponse response = this.createV4TemporarySignature((TemporarySignatureRequest)request);
            V4TemporarySignatureResponse res = new V4TemporarySignatureResponse(response.getSignedUrl());
            res.getActualSignedRequestHeaders().putAll(response.getActualSignedRequestHeaders());
            return res;
        }
        catch (Exception e) {
            reqBean.setRespTime(new Date());
            if (ILOG.isErrorEnabled()) {
                ILOG.error(reqBean);
            }
            throw new ObsException(e.getMessage(), e);
        }
    }

    @Deprecated
    public V4PostSignatureResponse createV4PostSignature(String acl, String contentType, long expires, String bucketName, String objectKey) throws ObsException {
        V4PostSignatureRequest request = new V4PostSignatureRequest(expires, new Date(), bucketName, objectKey);
        request.getFormParams().put("acl", acl);
        request.getFormParams().put("content-type", contentType);
        return this.createV4PostSignature(request);
    }

    @Deprecated
    public V4PostSignatureResponse createV4PostSignature(long expires, String bucketName, String objectKey) throws ObsException {
        V4PostSignatureRequest request = new V4PostSignatureRequest(expires, new Date(), bucketName, objectKey);
        return this.createV4PostSignature(request);
    }

    @Deprecated
    public V4PostSignatureResponse createV4PostSignature(V4PostSignatureRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "V4PostSignatureRequest is null");
        InterfaceLogBean reqBean = new InterfaceLogBean("createV4PostSignature", this.getEndpoint(), "");
        try {
            V4PostSignatureResponse response = (V4PostSignatureResponse)this.createPostSignatureResponse(request, true);
            reqBean.setRespTime(new Date());
            reqBean.setResultCode("0");
            if (ILOG.isInfoEnabled()) {
                ILOG.info(reqBean);
            }
            return response;
        }
        catch (Exception e) {
            reqBean.setRespTime(new Date());
            if (ILOG.isErrorEnabled()) {
                ILOG.error(reqBean);
            }
            throw new ObsException(e.getMessage(), e);
        }
    }

    @Override
    public TemporarySignatureResponse createTemporarySignature(TemporarySignatureRequest request) {
        ServiceUtils.asserParameterNotNull(request, "TemporarySignatureRequest is null");
        InterfaceLogBean reqBean = new InterfaceLogBean("createTemporarySignature", this.getEndpoint(), "");
        try {
            TemporarySignatureResponse response = this.getProviderCredentials().getAuthType() == AuthTypeEnum.V4 ? this.createV4TemporarySignature(request) : this.createTemporarySignatureResponse(request);
            return response;
        }
        catch (Exception e) {
            reqBean.setRespTime(new Date());
            if (ILOG.isErrorEnabled()) {
                ILOG.error(reqBean);
            }
            throw new ObsException(e.getMessage(), e);
        }
    }

    public TemporarySignatureResponse createGetTemporarySignature(String bucketName, String objectKey, String prefix, Date expiryDate, Map<String, String> headers, Map<String, Object> queryParams) {
        try {
            PolicyTempSignatureRequest request = this.createPolicyGetRequest(bucketName, objectKey, prefix, headers, queryParams);
            request.setExpiryDate(expiryDate);
            TemporarySignatureResponse response = this.createTemporarySignatureResponse(request);
            return response;
        }
        catch (Exception e) {
            throw new ObsException(e.getMessage(), e);
        }
    }

    public TemporarySignatureResponse createGetTemporarySignature(String bucketName, String objectKey, String prefix, long expires, Map<String, String> headers, Map<String, Object> queryParams) {
        try {
            PolicyTempSignatureRequest request = this.createPolicyGetRequest(bucketName, objectKey, prefix, headers, queryParams);
            request.setExpires(expires);
            TemporarySignatureResponse response = this.createTemporarySignatureResponse(request);
            return response;
        }
        catch (Exception e) {
            throw new ObsException(e.getMessage(), e);
        }
    }

    private PolicyTempSignatureRequest createPolicyGetRequest(String bucketName, String objectKey, String prefix, Map<String, String> headers, Map<String, Object> queryParams) {
        PolicyTempSignatureRequest request = new PolicyTempSignatureRequest(HttpMethodEnum.GET, bucketName, objectKey);
        ArrayList<PolicyConditionItem> conditions = new ArrayList<PolicyConditionItem>();
        PolicyConditionItem keyCondition = new PolicyConditionItem(PolicyConditionItem.ConditionOperator.STARTS_WITH, "key", prefix);
        String bucket = this.isCname() ? this.getEndpoint() : bucketName;
        PolicyConditionItem bucketCondition = new PolicyConditionItem(PolicyConditionItem.ConditionOperator.EQUAL, "bucket", bucket);
        conditions.add(keyCondition);
        conditions.add(bucketCondition);
        request.setConditions(conditions);
        request.setHeaders(headers);
        request.setQueryParams(queryParams);
        return request;
    }

    public PostSignatureResponse createPostSignature(String acl, String contentType, long expires, String bucketName, String objectKey) throws ObsException {
        PostSignatureRequest request = new PostSignatureRequest(expires, new Date(), bucketName, objectKey);
        request.getFormParams().put(this.getProviderCredentials().getAuthType() == AuthTypeEnum.V4 ? "acl" : this.getIHeaders().aclHeader(), acl);
        request.getFormParams().put("Content-Type", contentType);
        return this.createPostSignature(request);
    }

    public PostSignatureResponse createPostSignature(long expires, String bucketName, String objectKey) throws ObsException {
        PostSignatureRequest request = new PostSignatureRequest(expires, new Date(), bucketName, objectKey);
        return this.createPostSignature(request);
    }

    @Override
    public PostSignatureResponse createPostSignature(PostSignatureRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "PostSignatureRequest is null");
        InterfaceLogBean reqBean = new InterfaceLogBean("createPostSignature", this.getEndpoint(), "");
        try {
            PostSignatureResponse response = this.createPostSignatureResponse(request, this.getProviderCredentials().getAuthType() == AuthTypeEnum.V4);
            reqBean.setRespTime(new Date());
            reqBean.setResultCode("0");
            if (ILOG.isInfoEnabled()) {
                ILOG.info(reqBean);
            }
            return response;
        }
        catch (Exception e) {
            reqBean.setRespTime(new Date());
            if (ILOG.isErrorEnabled()) {
                ILOG.error(reqBean);
            }
            throw new ObsException(e.getMessage(), e);
        }
    }

    @Override
    public ObsBucket createBucket(String bucketName) throws ObsException {
        ObsBucket obsBucket = new ObsBucket();
        obsBucket.setBucketName(bucketName);
        return this.createBucket(obsBucket);
    }

    @Override
    public ObsBucket createBucket(String bucketName, String location) throws ObsException {
        ObsBucket obsBucket = new ObsBucket();
        obsBucket.setBucketName(bucketName);
        obsBucket.setLocation(location);
        return this.createBucket(obsBucket);
    }

    @Override
    public ObsBucket createBucket(ObsBucket bucket) throws ObsException {
        CreateBucketRequest request = new CreateBucketRequest();
        request.setBucketName(bucket.getBucketName());
        request.setAcl(bucket.getAcl());
        request.setBucketStorageClass(bucket.getBucketStorageClass());
        request.setLocation(bucket.getLocation());
        return this.createBucket(request);
    }

    @Override
    public ObsBucket createBucket(final CreateBucketRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "CreateBucketRequest is null");
        return this.doActionWithResult("createBucket", request.getBucketName(), new ActionCallbackWithResult<ObsBucket>(){

            @Override
            public ObsBucket action() throws ServiceException {
                if (ObsClient.this.isCname()) {
                    throw new ServiceException("createBucket is not allowed in customdomain mode");
                }
                try {
                    return ObsClient.this.createBucketImpl(request);
                }
                catch (ServiceException e) {
                    if (ObsClient.this.isAuthTypeNegotiation() && e.getResponseCode() == 400 && "Unsupported Authorization Type".equals(e.getErrorMessage()) && ObsClient.this.getProviderCredentials().getAuthType() == AuthTypeEnum.OBS) {
                        ObsClient.this.getProviderCredentials().setThreadLocalAuthType(AuthTypeEnum.V2);
                        return ObsClient.this.createBucketImpl(request);
                    }
                    throw e;
                }
            }

            @Override
            void authTypeNegotiate(String bucketName) throws ServiceException {
                AuthTypeEnum authTypeEnum = ObsClient.this.getApiVersionCache().getApiVersionInCache(bucketName);
                if (authTypeEnum == null) {
                    authTypeEnum = ObsClient.this.getApiVersion("");
                }
                ObsClient.this.getProviderCredentials().setThreadLocalAuthType(authTypeEnum);
            }
        });
    }

    @Deprecated
    public ObsBucket createBucket(S3Bucket bucket) throws ObsException {
        ServiceUtils.asserParameterNotNull(bucket, "bucket is null");
        ObsBucket obsBucket = new ObsBucket();
        obsBucket.setBucketName(bucket.getBucketName());
        obsBucket.setLocation(bucket.getLocation());
        obsBucket.setAcl(bucket.getAcl());
        obsBucket.setMetadata(bucket.getMetadata());
        obsBucket.setBucketStorageClass(bucket.getBucketStorageClass());
        return this.createBucket(obsBucket);
    }

    @Deprecated
    public List<S3Bucket> listBuckets() throws ObsException {
        List<ObsBucket> ret = this.listBuckets(null);
        ArrayList<S3Bucket> buckets = new ArrayList<S3Bucket>(ret.size());
        buckets.addAll(ret);
        return buckets;
    }

    @Override
    public List<ObsBucket> listBuckets(ListBucketsRequest request) throws ObsException {
        return this.listBucketsV2(request).getBuckets();
    }

    @Override
    public ListBucketsResult listBucketsV2(final ListBucketsRequest request) throws ObsException {
        return this.doActionWithResult("listBuckets", "All Buckets", new ActionCallbackWithResult<ListBucketsResult>(){

            @Override
            public ListBucketsResult action() throws ServiceException {
                if (ObsClient.this.isCname()) {
                    throw new ServiceException("listBuckets is not allowed in customdomain mode");
                }
                return ObsClient.this.listAllBucketsImpl(request);
            }

            @Override
            void authTypeNegotiate(String bucketName) throws ServiceException {
                AuthTypeEnum authTypeEnum = ObsClient.this.getApiVersion("");
                ObsClient.this.getProviderCredentials().setThreadLocalAuthType(authTypeEnum);
            }
        });
    }

    @Override
    public HeaderResponse deleteBucket(String bucketName) throws ObsException {
        return this.deleteBucket(new BaseBucketRequest(bucketName));
    }

    @Override
    public HeaderResponse deleteBucket(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BaseBucketRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("deleteBucket", request.getBucketName(), new ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return ObsClient.this.deleteBucketImpl(request);
            }
        });
    }

    @Override
    public ObjectListing listObjects(final ListObjectsRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "ListObjectsRequest is null");
        return this.doActionWithResult("listObjects", request.getBucketName(), new ActionCallbackWithResult<ObjectListing>(){

            @Override
            public ObjectListing action() throws ServiceException {
                return ObsClient.this.listObjectsImpl(request);
            }
        });
    }

    @Override
    public ObjectListing listObjects(String bucketName) throws ObsException {
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest(bucketName);
        return this.listObjects(listObjectsRequest);
    }

    @Override
    public boolean headBucket(String bucketName) throws ObsException {
        return this.headBucket(new BaseBucketRequest(bucketName));
    }

    @Override
    public boolean headBucket(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BaseBucketRequest is null");
        ServiceUtils.asserParameterNotNull(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("headBucket", request.getBucketName(), new ActionCallbackWithResult<Boolean>(){

            @Override
            public Boolean action() throws ServiceException {
                return ObsClient.this.headBucketImpl(request);
            }

            @Override
            void authTypeNegotiate(String bucketName) throws ServiceException {
                block2: {
                    try {
                        AuthTypeEnum authTypeEnum = ObsClient.this.getApiVersion(bucketName);
                        ObsClient.this.getProviderCredentials().setThreadLocalAuthType(authTypeEnum);
                    }
                    catch (ServiceException e) {
                        if (e.getResponseCode() == 404) break block2;
                        throw e;
                    }
                }
            }
        });
    }

    @Deprecated
    public ListVersionsResult listVersions(String bucketName, String prefix, String delimiter, String keyMarker, String versionIdMarker, long maxKeys, String nextVersionIdMarker) throws ObsException {
        ListVersionsRequest request = new ListVersionsRequest();
        request.setBucketName(bucketName);
        request.setPrefix(prefix);
        request.setKeyMarker(keyMarker);
        request.setMaxKeys((int)maxKeys);
        request.setVersionIdMarker(versionIdMarker);
        request.setDelimiter(delimiter);
        return this.listVersions(request);
    }

    @Override
    public ListVersionsResult listVersions(final ListVersionsRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "ListVersionsRequest is null");
        return this.doActionWithResult("listVersions", request.getBucketName(), new ActionCallbackWithResult<ListVersionsResult>(){

            @Override
            public ListVersionsResult action() throws ServiceException {
                return ObsClient.this.listVersionsImpl(request);
            }
        });
    }

    @Override
    public ListVersionsResult listVersions(String bucketName) throws ObsException {
        ListVersionsRequest request = new ListVersionsRequest();
        request.setBucketName(bucketName);
        return this.listVersions(request);
    }

    @Override
    public ListVersionsResult listVersions(String bucketName, long maxKeys) throws ObsException {
        ListVersionsRequest request = new ListVersionsRequest();
        request.setBucketName(bucketName);
        request.setMaxKeys((int)maxKeys);
        return this.listVersions(request);
    }

    @Override
    public ListVersionsResult listVersions(String bucketName, String prefix, String delimiter, String keyMarker, String versionIdMarker, long maxKeys) throws ObsException {
        return this.listVersions(bucketName, prefix, delimiter, keyMarker, versionIdMarker, maxKeys, null);
    }

    @Override
    public BucketMetadataInfoResult getBucketMetadata(final BucketMetadataInfoRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BucketMetadataInfoRequest is null");
        return this.doActionWithResult("getBucketMetadata", request.getBucketName(), new ActionCallbackWithResult<BucketMetadataInfoResult>(){

            @Override
            public BucketMetadataInfoResult action() throws ServiceException {
                return ObsClient.this.getBucketMetadataImpl(request);
            }
        });
    }

    @Override
    public AccessControlList getBucketAcl(String bucketName) throws ObsException {
        return this.getBucketAcl(new BaseBucketRequest(bucketName));
    }

    @Override
    public AccessControlList getBucketAcl(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BaseBucketRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("getBucketAcl", request.getBucketName(), new ActionCallbackWithResult<AccessControlList>(){

            @Override
            public AccessControlList action() throws ServiceException {
                return ObsClient.this.getBucketAclImpl(request);
            }
        });
    }

    @Deprecated
    public HeaderResponse setBucketAcl(String bucketName, String cannedACL, AccessControlList acl) throws ObsException {
        SetBucketAclRequest request = new SetBucketAclRequest(bucketName, acl);
        request.setCannedACL(cannedACL);
        return this.setBucketAcl(request);
    }

    @Override
    public HeaderResponse setBucketAcl(String bucketName, AccessControlList acl) throws ObsException {
        return this.setBucketAcl(new SetBucketAclRequest(bucketName, acl));
    }

    @Override
    public HeaderResponse setBucketAcl(final SetBucketAclRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "SetBucketAclRequest is null");
        return this.doActionWithResult("setBucketAcl", request.getBucketName(), new ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                if (request.getAcl() == null && null == request.getCannedACL()) {
                    throw new IllegalArgumentException("Both CannedACL and AccessControlList is null");
                }
                return ObsClient.this.setBucketAclImpl(request);
            }
        });
    }

    @Override
    public String getBucketLocation(String bucketName) throws ObsException {
        return this.getBucketLocation(new BaseBucketRequest(bucketName)).getLocation();
    }

    @Override
    public BucketLocationResponse getBucketLocation(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BaseBucketRequest is null");
        return this.doActionWithResult("getBucketLocation", request.getBucketName(), new ActionCallbackWithResult<BucketLocationResponse>(){

            @Override
            public BucketLocationResponse action() throws ServiceException {
                return ObsClient.this.getBucketLocationImpl(request);
            }
        });
    }

    @Override
    public BucketLocationResponse getBucketLocationV2(String bucketName) throws ObsException {
        return this.getBucketLocation(new BaseBucketRequest(bucketName));
    }

    @Override
    public BucketStorageInfo getBucketStorageInfo(String bucketName) throws ObsException {
        return this.getBucketStorageInfo(new BaseBucketRequest(bucketName));
    }

    @Override
    public BucketStorageInfo getBucketStorageInfo(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BaseBucketRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("getBucketStorageInfo", request.getBucketName(), new ActionCallbackWithResult<BucketStorageInfo>(){

            @Override
            public BucketStorageInfo action() throws ServiceException {
                return ObsClient.this.getBucketStorageInfoImpl(request);
            }
        });
    }

    @Override
    public BucketQuota getBucketQuota(String bucketName) throws ObsException {
        return this.getBucketQuota(new BaseBucketRequest(bucketName));
    }

    @Override
    public BucketQuota getBucketQuota(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BaseBucketRequest is null");
        return this.doActionWithResult("getBucketQuota", request.getBucketName(), new ActionCallbackWithResult<BucketQuota>(){

            @Override
            public BucketQuota action() throws ServiceException {
                return ObsClient.this.getBucketQuotaImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse setBucketQuota(String bucketName, BucketQuota bucketQuota) throws ObsException {
        return this.setBucketQuota(new SetBucketQuotaRequest(bucketName, bucketQuota));
    }

    @Override
    public HeaderResponse setBucketQuota(final SetBucketQuotaRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "SetBucketQuotaRequest is null");
        ServiceUtils.asserParameterNotNull(request.getBucketQuota(), "The bucket '" + request.getBucketName() + "' does not include Quota information");
        return this.doActionWithResult("setBucketQuota", request.getBucketName(), new ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return ObsClient.this.setBucketQuotaImpl(request);
            }
        });
    }

    @Override
    public BucketStoragePolicyConfiguration getBucketStoragePolicy(String bucketName) throws ObsException {
        return this.getBucketStoragePolicy(new BaseBucketRequest(bucketName));
    }

    @Override
    public BucketStoragePolicyConfiguration getBucketStoragePolicy(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BaseBucketRequest is null");
        return this.doActionWithResult("getBucketStoragePolicy", request.getBucketName(), new ActionCallbackWithResult<BucketStoragePolicyConfiguration>(){

            @Override
            public BucketStoragePolicyConfiguration action() throws ServiceException {
                return ObsClient.this.getBucketStoragePolicyImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse setBucketStoragePolicy(String bucketName, BucketStoragePolicyConfiguration bucketStorage) throws ObsException {
        return this.setBucketStoragePolicy(new SetBucketStoragePolicyRequest(bucketName, bucketStorage));
    }

    @Override
    public HeaderResponse setBucketStoragePolicy(final SetBucketStoragePolicyRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "SetBucketStoragePolicyRequest is null");
        ServiceUtils.asserParameterNotNull(request.getBucketStorage(), "The bucket '" + request.getBucketName() + "' does not include storagePolicy information");
        return this.doActionWithResult("setBucketStoragePolicy", request.getBucketName(), new ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return ObsClient.this.setBucketStorageImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse setBucketCors(String bucketName, BucketCors bucketCors) throws ObsException {
        return this.setBucketCors(new SetBucketCorsRequest(bucketName, bucketCors));
    }

    @Deprecated
    public HeaderResponse setBucketCors(String bucketName, S3BucketCors s3BucketCors) throws ObsException {
        ServiceUtils.asserParameterNotNull(s3BucketCors, "The bucket '" + bucketName + "' does not include Cors information");
        BucketCors bucketCors = new BucketCors();
        bucketCors.setRules(s3BucketCors.getRules());
        return this.setBucketCors(new SetBucketCorsRequest(bucketName, bucketCors));
    }

    @Override
    public HeaderResponse setBucketCors(final SetBucketCorsRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "SetBucketCorsRequest is null");
        return this.doActionWithResult("setBucketCors", request.getBucketName(), new ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return ObsClient.this.setBucketCorsImpl(request);
            }
        });
    }

    @Override
    public BucketCors getBucketCors(String bucketName) throws ObsException {
        return this.getBucketCors(new BaseBucketRequest(bucketName));
    }

    @Override
    public BucketCors getBucketCors(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BaseBucketRequest is null");
        return this.doActionWithResult("getBucketCors", request.getBucketName(), new ActionCallbackWithResult<BucketCors>(){

            @Override
            public BucketCors action() throws ServiceException {
                return ObsClient.this.getBucketCorsImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse deleteBucketCors(String bucketName) throws ObsException {
        return this.deleteBucketCors(new BaseBucketRequest(bucketName));
    }

    @Override
    public HeaderResponse deleteBucketCors(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BaseBucketRequest is null");
        return this.doActionWithResult("deleteBucketCors", request.getBucketName(), new ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return ObsClient.this.deleteBucketCorsImpl(request);
            }
        });
    }

    @Deprecated
    public OptionsInfoResult optionsBucket(final String bucketName, final OptionsInfoRequest optionInfo) throws ObsException {
        return this.doActionWithResult("optionsBucket", bucketName, new ActionCallbackWithResult<OptionsInfoResult>(){

            @Override
            public OptionsInfoResult action() throws ServiceException {
                ServiceUtils.asserParameterNotNull(optionInfo, "OptionsInfoRequest is null");
                return ObsClient.this.optionsImpl(bucketName, null, optionInfo);
            }
        });
    }

    @Deprecated
    public OptionsInfoResult optionsObject(final String bucketName, final String objectKey, final OptionsInfoRequest optionInfo) throws ObsException {
        return this.doActionWithResult("optionsObject", bucketName, new ActionCallbackWithResult<OptionsInfoResult>(){

            @Override
            public OptionsInfoResult action() throws ServiceException {
                ServiceUtils.asserParameterNotNull(optionInfo, "OptionsInfoRequest is null");
                return ObsClient.this.optionsImpl(bucketName, objectKey, optionInfo);
            }
        });
    }

    @Deprecated
    public BucketLoggingConfiguration getBucketLoggingConfiguration(String bucketName) throws ObsException {
        return this.getBucketLogging(new BaseBucketRequest(bucketName));
    }

    @Override
    public BucketLoggingConfiguration getBucketLogging(String bucketName) throws ObsException {
        return this.getBucketLogging(new BaseBucketRequest(bucketName));
    }

    @Override
    public BucketLoggingConfiguration getBucketLogging(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BaseBucketRequest is null");
        return this.doActionWithResult("getBucketLoggingConfiguration", request.getBucketName(), new ActionCallbackWithResult<BucketLoggingConfiguration>(){

            @Override
            public BucketLoggingConfiguration action() throws ServiceException {
                return ObsClient.this.getBucketLoggingConfigurationImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse setBucketLoggingConfiguration(String bucketName, BucketLoggingConfiguration loggingConfiguration, boolean updateTargetACLifRequired) throws ObsException {
        return this.setBucketLogging(new SetBucketLoggingRequest(bucketName, loggingConfiguration, updateTargetACLifRequired));
    }

    @Deprecated
    public HeaderResponse setBucketLoggingConfiguration(String bucketName, BucketLoggingConfiguration loggingConfiguration) throws ObsException {
        return this.setBucketLogging(new SetBucketLoggingRequest(bucketName, loggingConfiguration));
    }

    @Override
    public HeaderResponse setBucketLogging(String bucketName, BucketLoggingConfiguration loggingConfiguration) throws ObsException {
        return this.setBucketLogging(new SetBucketLoggingRequest(bucketName, loggingConfiguration));
    }

    @Override
    public HeaderResponse setBucketLogging(final SetBucketLoggingRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "SetBucketLoggingRequest is null");
        return this.doActionWithResult("setBucketLoggingConfiguration", request.getBucketName(), new ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return ObsClient.this.setBucketLoggingConfigurationImpl(request);
            }
        });
    }

    @Deprecated
    public HeaderResponse setBucketVersioning(String bucketName, String status) throws ObsException {
        return this.setBucketVersioning(bucketName, new BucketVersioningConfiguration(status));
    }

    @Override
    public HeaderResponse setBucketVersioning(String bucketName, BucketVersioningConfiguration versioningConfiguration) throws ObsException {
        return this.setBucketVersioning(new SetBucketVersioningRequest(bucketName, versioningConfiguration.getVersioningStatus()));
    }

    @Override
    public HeaderResponse setBucketVersioning(final SetBucketVersioningRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "SetBucketVersioningRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("setBucketVersioning", request.getBucketName(), new ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return ObsClient.this.setBucketVersioningImpl(request);
            }
        });
    }

    @Override
    public BucketVersioningConfiguration getBucketVersioning(String bucketName) throws ObsException {
        return this.getBucketVersioning(new BaseBucketRequest(bucketName));
    }

    @Override
    public BucketVersioningConfiguration getBucketVersioning(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BaseBucketRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("getBucketVersioning", request.getBucketName(), new ActionCallbackWithResult<BucketVersioningConfiguration>(){

            @Override
            public BucketVersioningConfiguration action() throws ServiceException {
                return ObsClient.this.getBucketVersioningImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse setBucketRequestPayment(String bucketName, RequestPaymentEnum payer) throws ObsException {
        return this.setBucketRequestPayment(new SetBucketRequestPaymentRequest(bucketName, payer));
    }

    @Override
    public HeaderResponse setBucketRequestPayment(final SetBucketRequestPaymentRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "SetBucketRequestPaymentRequest is null");
        return this.doActionWithResult("setBucketRequestPayment", request.getBucketName(), new ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                ServiceUtils.asserParameterNotNull2(request.getBucketName(), "bucketName is null");
                ServiceUtils.asserParameterNotNull((Object)request.getPayer(), "payer is null");
                return ObsClient.this.setBucketRequestPaymentImpl(request);
            }
        });
    }

    @Override
    public RequestPaymentConfiguration getBucketRequestPayment(String bucketName) throws ObsException {
        return this.getBucketRequestPayment(new BaseBucketRequest(bucketName));
    }

    @Override
    public RequestPaymentConfiguration getBucketRequestPayment(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BaseBucketRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("getBucketRequestPayment", request.getBucketName(), new ActionCallbackWithResult<RequestPaymentConfiguration>(){

            @Override
            public RequestPaymentConfiguration action() throws ServiceException {
                return ObsClient.this.getBucketRequestPaymentImpl(request);
            }
        });
    }

    @Deprecated
    public LifecycleConfiguration getBucketLifecycleConfiguration(String bucketName) throws ObsException {
        return this.getBucketLifecycle(new BaseBucketRequest(bucketName));
    }

    @Override
    public LifecycleConfiguration getBucketLifecycle(String bucketName) throws ObsException {
        return this.getBucketLifecycle(new BaseBucketRequest(bucketName));
    }

    @Override
    public LifecycleConfiguration getBucketLifecycle(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BaseBucketRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("getBucketLifecycleConfiguration", request.getBucketName(), new ActionCallbackWithResult<LifecycleConfiguration>(){

            @Override
            public LifecycleConfiguration action() throws ServiceException {
                return ObsClient.this.getBucketLifecycleConfigurationImpl(request);
            }
        });
    }

    @Deprecated
    public HeaderResponse setBucketLifecycleConfiguration(String bucketName, LifecycleConfiguration lifecycleConfig) throws ObsException {
        return this.setBucketLifecycle(new SetBucketLifecycleRequest(bucketName, lifecycleConfig));
    }

    @Override
    public HeaderResponse setBucketLifecycle(String bucketName, LifecycleConfiguration lifecycleConfig) throws ObsException {
        return this.setBucketLifecycle(new SetBucketLifecycleRequest(bucketName, lifecycleConfig));
    }

    @Override
    public HeaderResponse setBucketLifecycle(final SetBucketLifecycleRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "SetBucketLifecycleRequest is null");
        ServiceUtils.asserParameterNotNull(request.getLifecycleConfig(), "LifecycleConfiguration is null");
        ServiceUtils.asserParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("setBucketLifecycleConfiguration", request.getBucketName(), new ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return ObsClient.this.setBucketLifecycleConfigurationImpl(request);
            }
        });
    }

    @Deprecated
    public HeaderResponse deleteBucketLifecycleConfiguration(String bucketName) throws ObsException {
        return this.deleteBucketLifecycle(new BaseBucketRequest(bucketName));
    }

    @Override
    public HeaderResponse deleteBucketLifecycle(String bucketName) throws ObsException {
        return this.deleteBucketLifecycle(new BaseBucketRequest(bucketName));
    }

    @Override
    public HeaderResponse deleteBucketLifecycle(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BaseBucketRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("deleteBucketLifecycleConfiguration", request.getBucketName(), new ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return ObsClient.this.deleteBucketLifecycleConfigurationImpl(request);
            }
        });
    }

    @Override
    public String getBucketPolicy(String bucketName) throws ObsException {
        return this.getBucketPolicyV2(new BaseBucketRequest(bucketName)).getPolicy();
    }

    @Override
    public String getBucketPolicy(BaseBucketRequest request) throws ObsException {
        return this.getBucketPolicyV2(request).getPolicy();
    }

    @Override
    public BucketPolicyResponse getBucketPolicyV2(String bucketName) throws ObsException {
        return this.getBucketPolicyV2(new BaseBucketRequest(bucketName));
    }

    @Override
    public BucketPolicyResponse getBucketPolicyV2(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BaseBucketRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("getBucketPolicy", request.getBucketName(), new ActionCallbackWithResult<BucketPolicyResponse>(){

            @Override
            public BucketPolicyResponse action() throws ServiceException {
                return ObsClient.this.getBucketPolicyImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse setBucketPolicy(String bucketName, String policy) throws ObsException {
        return this.setBucketPolicy(new SetBucketPolicyRequest(bucketName, policy));
    }

    @Override
    public HeaderResponse setBucketPolicy(final SetBucketPolicyRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "SetBucketPolicyRequest is null");
        ServiceUtils.asserParameterNotNull(request.getPolicy(), "policy is null");
        return this.doActionWithResult("setBucketPolicy", request.getBucketName(), new ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return ObsClient.this.setBucketPolicyImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse deleteBucketPolicy(String bucketName) throws ObsException {
        return this.deleteBucketPolicy(new BaseBucketRequest(bucketName));
    }

    @Override
    public HeaderResponse deleteBucketPolicy(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BaseBucketRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("deleteBucketPolicy", request.getBucketName(), new ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return ObsClient.this.deleteBucketPolicyImpl(request);
            }
        });
    }

    @Deprecated
    public WebsiteConfiguration getBucketWebsiteConfiguration(String bucketName) throws ObsException {
        return this.getBucketWebsite(new BaseBucketRequest(bucketName));
    }

    @Override
    public WebsiteConfiguration getBucketWebsite(String bucketName) throws ObsException {
        return this.getBucketWebsite(new BaseBucketRequest(bucketName));
    }

    @Override
    public WebsiteConfiguration getBucketWebsite(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BaseBucketRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("getBucketWebsiteConfiguration", request.getBucketName(), new ActionCallbackWithResult<WebsiteConfiguration>(){

            @Override
            public WebsiteConfiguration action() throws ServiceException {
                return ObsClient.this.getBucketWebsiteConfigurationImpl(request);
            }
        });
    }

    @Deprecated
    public HeaderResponse setBucketWebsiteConfiguration(String bucketName, WebsiteConfiguration websiteConfig) throws ObsException {
        return this.setBucketWebsite(new SetBucketWebsiteRequest(bucketName, websiteConfig));
    }

    @Override
    public HeaderResponse setBucketWebsite(String bucketName, WebsiteConfiguration websiteConfig) throws ObsException {
        return this.setBucketWebsite(new SetBucketWebsiteRequest(bucketName, websiteConfig));
    }

    @Override
    public HeaderResponse setBucketWebsite(final SetBucketWebsiteRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "SetBucketWebsiteRequest is null");
        ServiceUtils.asserParameterNotNull(request.getWebsiteConfig(), "WebsiteConfiguration is null");
        ServiceUtils.asserParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("setBucketWebsiteConfiguration", request.getBucketName(), new ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return ObsClient.this.setBucketWebsiteConfigurationImpl(request);
            }
        });
    }

    @Deprecated
    public HeaderResponse deleteBucketWebsiteConfiguration(String bucketName) throws ObsException {
        return this.deleteBucketWebsite(new BaseBucketRequest(bucketName));
    }

    @Override
    public HeaderResponse deleteBucketWebsite(String bucketName) throws ObsException {
        return this.deleteBucketWebsite(new BaseBucketRequest(bucketName));
    }

    @Override
    public HeaderResponse deleteBucketWebsite(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BaseBucketRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("deleteBucketWebsiteConfiguration", request.getBucketName(), new ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return ObsClient.this.deleteBucketWebsiteConfigurationImpl(request);
            }
        });
    }

    @Override
    public BucketTagInfo getBucketTagging(String bucketName) throws ObsException {
        return this.getBucketTagging(new BaseBucketRequest(bucketName));
    }

    @Override
    public BucketTagInfo getBucketTagging(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BaseBucketRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("getBucketTagging", request.getBucketName(), new ActionCallbackWithResult<BucketTagInfo>(){

            @Override
            public BucketTagInfo action() throws ServiceException {
                return ObsClient.this.getBucketTaggingImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse setBucketTagging(String bucketName, BucketTagInfo bucketTagInfo) throws ObsException {
        return this.setBucketTagging(new SetBucketTaggingRequest(bucketName, bucketTagInfo));
    }

    @Override
    public HeaderResponse setBucketTagging(final SetBucketTaggingRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "SetBucketTaggingRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("setBucketTagging", request.getBucketName(), new ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return ObsClient.this.setBucketTaggingImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse deleteBucketTagging(String bucketName) throws ObsException {
        return this.deleteBucketTagging(new BaseBucketRequest(bucketName));
    }

    @Override
    public HeaderResponse deleteBucketTagging(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BaseBucketRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("deleteBucketTagging", request.getBucketName(), new ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return ObsClient.this.deleteBucketTaggingImpl(request);
            }
        });
    }

    @Override
    public BucketEncryption getBucketEncryption(String bucketName) throws ObsException {
        return this.getBucketEncryption(new BaseBucketRequest(bucketName));
    }

    @Override
    public BucketEncryption getBucketEncryption(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BaseBucketRequest is null");
        return this.doActionWithResult("getBucketEncryption", request.getBucketName(), new ActionCallbackWithResult<BucketEncryption>(){

            @Override
            BucketEncryption action() throws ServiceException {
                return ObsClient.this.getBucketEncryptionImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse setBucketEncryption(String bucketName, BucketEncryption bucketEncryption) throws ObsException {
        return this.setBucketEncryption(new SetBucketEncryptionRequest(bucketName, bucketEncryption));
    }

    @Override
    public HeaderResponse setBucketEncryption(final SetBucketEncryptionRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "SetBucketEncryptionRequest is null");
        ServiceUtils.asserParameterNotNull(request.getBucketEncryption(), "SetBucketEncryptionRequest.bucketEncryption is null");
        return this.doActionWithResult("setBucketEncryption", request.getBucketName(), new ActionCallbackWithResult<HeaderResponse>(){

            @Override
            HeaderResponse action() throws ServiceException {
                return ObsClient.this.setBucketEncryptionImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse deleteBucketEncryption(String bucketName) throws ObsException {
        return this.deleteBucketEncryption(new BaseBucketRequest(bucketName));
    }

    @Override
    public HeaderResponse deleteBucketEncryption(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BaseBucketRequest is null");
        return this.doActionWithResult("deleteBucketEncryption", request.getBucketName(), new ActionCallbackWithResult<HeaderResponse>(){

            @Override
            HeaderResponse action() throws ServiceException {
                return ObsClient.this.deleteBucketEncryptionImpl(request);
            }
        });
    }

    @Deprecated
    public HeaderResponse setBucketReplicationConfiguration(String bucketName, ReplicationConfiguration replicationConfiguration) throws ObsException {
        return this.setBucketReplication(new SetBucketReplicationRequest(bucketName, replicationConfiguration));
    }

    @Override
    public HeaderResponse setBucketReplication(String bucketName, ReplicationConfiguration replicationConfiguration) throws ObsException {
        return this.setBucketReplication(new SetBucketReplicationRequest(bucketName, replicationConfiguration));
    }

    @Override
    public HeaderResponse setBucketReplication(final SetBucketReplicationRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "SetBucketReplicationRequest is null");
        ServiceUtils.asserParameterNotNull(request.getReplicationConfiguration(), "ReplicationConfiguration is null");
        ServiceUtils.asserParameterNotNull(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("setBucketReplication", request.getBucketName(), new ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return ObsClient.this.setBucketReplicationConfigurationImpl(request);
            }
        });
    }

    @Deprecated
    public ReplicationConfiguration getBucketReplicationConfiguration(String bucketName) throws ObsException {
        return this.getBucketReplication(new BaseBucketRequest(bucketName));
    }

    @Override
    public ReplicationConfiguration getBucketReplication(String bucketName) throws ObsException {
        return this.getBucketReplication(new BaseBucketRequest(bucketName));
    }

    @Override
    public ReplicationConfiguration getBucketReplication(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BaseBucketRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("getBucketReplicationConfiguration", request.getBucketName(), new ActionCallbackWithResult<ReplicationConfiguration>(){

            @Override
            public ReplicationConfiguration action() throws ServiceException {
                return ObsClient.this.getBucketReplicationConfigurationImpl(request);
            }
        });
    }

    @Deprecated
    public HeaderResponse deleteBucketReplicationConfiguration(String bucketName) throws ObsException {
        return this.deleteBucketReplication(new BaseBucketRequest(bucketName));
    }

    @Override
    public HeaderResponse deleteBucketReplication(String bucketName) throws ObsException {
        return this.deleteBucketReplication(new BaseBucketRequest(bucketName));
    }

    @Override
    public HeaderResponse deleteBucketReplication(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BaseBucketRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("deleteBucketReplicationConfiguration", request.getBucketName(), new ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return ObsClient.this.deleteBucketReplicationConfigurationImpl(request);
            }
        });
    }

    @Override
    public BucketNotificationConfiguration getBucketNotification(String bucketName) throws ObsException {
        return this.getBucketNotification(new BaseBucketRequest(bucketName));
    }

    @Override
    public BucketNotificationConfiguration getBucketNotification(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BaseBucketRequest is null");
        return this.doActionWithResult("getBucketNotification", request.getBucketName(), new ActionCallbackWithResult<BucketNotificationConfiguration>(){

            @Override
            public BucketNotificationConfiguration action() throws ServiceException {
                return ObsClient.this.getBucketNotificationConfigurationImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse setBucketNotification(String bucketName, BucketNotificationConfiguration bucketNotificationConfiguration) throws ObsException {
        return this.setBucketNotification(new SetBucketNotificationRequest(bucketName, bucketNotificationConfiguration));
    }

    @Override
    public HeaderResponse setBucketNotification(final SetBucketNotificationRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "SetBucketNotificationRequest is null");
        return this.doActionWithResult("setBucketNotification", request.getBucketName(), new ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                if (null == request.getBucketNotificationConfiguration()) {
                    request.setBucketNotificationConfiguration(new BucketNotificationConfiguration());
                }
                return ObsClient.this.setBucketNotificationImpl(request);
            }
        });
    }

    @Override
    public PutObjectResult putObject(String bucketName, String objectKey, InputStream input, ObjectMetadata metadata) throws ObsException {
        PutObjectRequest request = new PutObjectRequest();
        request.setBucketName(bucketName);
        request.setInput(input);
        request.setMetadata(metadata);
        request.setObjectKey(objectKey);
        return this.putObject(request);
    }

    @Override
    public PutObjectResult putObject(String bucketName, String objectKey, InputStream input) throws ObsException {
        return this.putObject(bucketName, objectKey, input, null);
    }

    @Override
    public PutObjectResult putObject(final PutObjectRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "PutObjectRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getObjectKey(), "objectKey is null");
        return this.doActionWithResult("putObject", request.getBucketName(), new ActionCallbackWithResult<PutObjectResult>(){

            @Override
            public PutObjectResult action() throws ServiceException {
                if (null != request.getInput() && null != request.getFile()) {
                    throw new ServiceException("Both input and file are set, only one is allowed");
                }
                return ObsClient.this.putObjectImpl(request);
            }
        });
    }

    @Override
    public PutObjectResult putObject(String bucketName, String objectKey, File file) throws ObsException {
        return this.putObject(bucketName, objectKey, file, null);
    }

    @Override
    public PutObjectResult putObject(String bucketName, String objectKey, File file, ObjectMetadata metadata) throws ObsException {
        PutObjectRequest request = new PutObjectRequest();
        request.setBucketName(bucketName);
        request.setFile(file);
        request.setObjectKey(objectKey);
        request.setMetadata(metadata);
        return this.putObject(request);
    }

    @Override
    public AppendObjectResult appendObject(final AppendObjectRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "AppendObjectRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getObjectKey(), "objectKey is null");
        return this.doActionWithResult("appendObject", request.getBucketName(), new ActionCallbackWithResult<AppendObjectResult>(){

            @Override
            public AppendObjectResult action() throws ServiceException {
                if (null != request.getInput() && null != request.getFile()) {
                    throw new ServiceException("Both input and file are set, only one is allowed");
                }
                return ObsClient.this.appendObjectImpl(request);
            }
        });
    }

    @Override
    public CompleteMultipartUploadResult uploadFile(UploadFileRequest uploadFileRequest) throws ObsException {
        return new ResumableClient(this).uploadFileResume(uploadFileRequest);
    }

    @Override
    public DownloadFileResult downloadFile(DownloadFileRequest downloadFileRequest) throws ObsException {
        try {
            DownloadFileResult downloadFileResult = new ResumableClient(this).downloadFileResume(downloadFileRequest);
            return downloadFileResult;
        }
        finally {
            if (null != downloadFileRequest.getProgressListener() && downloadFileRequest.getProgressListener() instanceof MonitorableProgressListener) {
                ((MonitorableProgressListener)downloadFileRequest.getProgressListener()).finishOneTask();
            }
        }
    }

    @Override
    public ObsObject getObject(final GetObjectRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "GetObjectRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getObjectKey(), "objectKey is null");
        return this.doActionWithResult("getObject", request.getBucketName(), new ActionCallbackWithResult<ObsObject>(){

            @Override
            public ObsObject action() throws ServiceException {
                return ObsClient.this.getObjectImpl(request);
            }
        });
    }

    @Override
    public ObsObject getObject(String bucketName, String objectKey, String versionId) throws ObsException {
        return this.getObject(new GetObjectRequest(bucketName, objectKey, versionId));
    }

    @Override
    public ObsObject getObject(String bucketName, String objectKey) throws ObsException {
        return this.getObject(bucketName, objectKey, null);
    }

    @Override
    public ObjectMetadata getObjectMetadata(final GetObjectMetadataRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "GetObjectMetadataRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getObjectKey(), "objectKey is null");
        return this.doActionWithResult("getObjectMetadata", request.getBucketName(), new ActionCallbackWithResult<ObjectMetadata>(){

            @Override
            public ObjectMetadata action() throws ServiceException {
                return ObsClient.this.getObjectMetadataImpl(request);
            }
        });
    }

    @Override
    public ObjectMetadata setObjectMetadata(final SetObjectMetadataRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "SetObjectMetadataRequest is null");
        return this.doActionWithResult("setObjectMetadata", request.getBucketName(), new ActionCallbackWithResult<ObjectMetadata>(){

            @Override
            public ObjectMetadata action() throws ServiceException {
                return ObsClient.this.setObjectMetadataImpl(request);
            }
        });
    }

    @Override
    public ObjectMetadata getObjectMetadata(String bucketName, String objectKey, String versionId) throws ObsException {
        GetObjectMetadataRequest request = new GetObjectMetadataRequest();
        request.setBucketName(bucketName);
        request.setObjectKey(objectKey);
        request.setVersionId(versionId);
        return this.getObjectMetadata(request);
    }

    @Override
    public ObjectMetadata getObjectMetadata(String bucketName, String objectKey) throws ObsException {
        return this.getObjectMetadata(bucketName, objectKey, null);
    }

    @Override
    @Deprecated
    public RestoreObjectRequest.RestoreObjectStatus restoreObject(final RestoreObjectRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "RestoreObjectRequest is null");
        return this.doActionWithResult("restoreObject", request.getBucketName(), new ActionCallbackWithResult<RestoreObjectRequest.RestoreObjectStatus>(){

            @Override
            public RestoreObjectRequest.RestoreObjectStatus action() throws ServiceException {
                ServiceUtils.asserParameterNotNull2(request.getObjectKey(), "objectKey is null");
                return ObsClient.this.restoreObjectImpl(request);
            }
        });
    }

    @Override
    public RestoreObjectResult restoreObjectV2(final RestoreObjectRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "RestoreObjectRequest is null");
        return this.doActionWithResult("restoreObjectV2", request.getBucketName(), new ActionCallbackWithResult<RestoreObjectResult>(){

            @Override
            public RestoreObjectResult action() throws ServiceException {
                ServiceUtils.asserParameterNotNull2(request.getObjectKey(), "objectKey is null");
                return ObsClient.this.restoreObjectV2Impl(request);
            }
        });
    }

    @Override
    public TaskProgressStatus restoreObjects(RestoreObjectsRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "RestoreObjectsRequest is null");
        if (!this.isCname()) {
            ServiceUtils.asserParameterNotNull(request.getBucketName(), "bucketName is null");
        }
        if (request.getKeyAndVersions() != null && request.getPrefix() != null) {
            throw new IllegalArgumentException("Prefix and keyandVersions cannot coexist in the same request");
        }
        int days = request.getDays();
        if (days < 1 || days > 30) {
            throw new IllegalArgumentException("Restoration days should be at least 1 and at most 30");
        }
        DefaultTaskProgressStatus progreStatus = new DefaultTaskProgressStatus();
        ThreadPoolExecutor executor = this.initThreadPool(request);
        try {
            String bucketName = request.getBucketName();
            String prefix = request.getPrefix();
            RestoreTierEnum tier = request.getRestoreTier();
            boolean versionRestored = request.isVersionRestored();
            LazyTaksCallback<RestoreObjectResult, RestoreObjectRequest> callback = request.getCallback() == null ? new LazyTaksCallback() : request.getCallback();
            TaskProgressListener listener = request.getProgressListener();
            int progressInterval = request.getProgressInterval();
            int totalTasks = 0;
            if (request.getKeyAndVersions() != null) {
                totalTasks = request.getKeyAndVersions().size();
                for (KeyAndVersion kv : request.getKeyAndVersions()) {
                    RestoreObjectRequest taskRequest = new RestoreObjectRequest(bucketName, kv.getKey(), kv.getVersion(), days, tier);
                    taskRequest.setRequesterPays(request.isRequesterPays());
                    RestoreObjectTask task = new RestoreObjectTask(this, bucketName, taskRequest, callback, listener, progreStatus, progressInterval);
                    executor.execute(task);
                }
            } else if (versionRestored) {
                ListVersionsResult versionResult;
                ListVersionsRequest listRequest = new ListVersionsRequest(bucketName);
                listRequest.setRequesterPays(request.isRequesterPays());
                listRequest.setPrefix(prefix);
                do {
                    versionResult = this.listVersions(listRequest);
                    for (VersionOrDeleteMarker v : versionResult.getVersions()) {
                        if (v.getObjectStorageClass() != StorageClassEnum.COLD) continue;
                        RestoreObjectRequest taskRequest = new RestoreObjectRequest(bucketName, v.getKey(), v.getVersionId(), days, tier);
                        taskRequest.setRequesterPays(request.isRequesterPays());
                        RestoreObjectTask task = new RestoreObjectTask(this, bucketName, taskRequest, callback, listener, progreStatus, progressInterval);
                        executor.execute(task);
                        if (!ILOG.isInfoEnabled() || ++totalTasks % 1000 != 0) continue;
                        ILOG.info("RestoreObjects: " + totalTasks + " tasks have submitted to restore objects");
                    }
                    listRequest.setKeyMarker(versionResult.getNextKeyMarker());
                    listRequest.setVersionIdMarker(versionResult.getNextVersionIdMarker());
                } while (versionResult.isTruncated());
            } else {
                ObjectListing objectsResult;
                ListObjectsRequest listObjectsRequest = new ListObjectsRequest(bucketName);
                listObjectsRequest.setRequesterPays(request.isRequesterPays());
                listObjectsRequest.setPrefix(prefix);
                do {
                    objectsResult = this.listObjects(listObjectsRequest);
                    for (ObsObject o : objectsResult.getObjects()) {
                        if (o.getMetadata().getObjectStorageClass() != StorageClassEnum.COLD) continue;
                        RestoreObjectRequest taskRequest = new RestoreObjectRequest(bucketName, o.getObjectKey(), null, days, tier);
                        taskRequest.setRequesterPays(request.isRequesterPays());
                        RestoreObjectTask task = new RestoreObjectTask(this, bucketName, taskRequest, callback, listener, progreStatus, progressInterval);
                        executor.execute(task);
                        if (!ILOG.isInfoEnabled() || ++totalTasks % 1000 != 0) continue;
                        ILOG.info("RestoreObjects: " + totalTasks + " tasks have submitted to restore objects");
                    }
                    listObjectsRequest.setMarker(objectsResult.getNextMarker());
                } while (objectsResult.isTruncated());
            }
            progreStatus.setTotalTaskNum(totalTasks);
            executor.shutdown();
            executor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (ObsException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ObsException(e.getMessage(), e);
        }
        return progreStatus;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public UploadProgressStatus putObjects(PutObjectsRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "PutObjectsRequest is null");
        ThreadPoolExecutor executor = this.initThreadPool(request);
        Date now = new Date();
        UploadTaskProgressStatus progressStatus = new UploadTaskProgressStatus(request.getTaskProgressInterval(), now);
        try {
            int totalTasks;
            block14: {
                Iterator<String> iterator;
                String prefix;
                LazyTaksCallback<PutObjectResult, PutObjectBasicRequest> callback;
                UploadObjectsProgressListener listener;
                block15: {
                    File[] files;
                    LinkedList<File> list;
                    String folderRoot;
                    String folderPath;
                    block13: {
                        block12: {
                            listener = request.getUploadObjectsProgressListener();
                            callback = request.getCallback() == null ? new LazyTaksCallback() : request.getCallback();
                            prefix = request.getPrefix() == null ? "" : request.getPrefix();
                            totalTasks = 0;
                            if (request.getFolderPath() == null) break block12;
                            folderPath = request.getFolderPath();
                            File fileRoot = new File(folderPath);
                            if (!fileRoot.exists()) {
                                String erroInfo = "putObjects: the folder \"" + folderPath + "\" dose not exist";
                                ILOG.warn(erroInfo);
                                throw new ObsException(erroInfo);
                            }
                            if (!fileRoot.isDirectory()) {
                                String erroInfo = "putObjects: the folder \"" + folderPath + "\" dose not a folder";
                                ILOG.warn(erroInfo);
                                throw new ObsException(erroInfo);
                            }
                            folderRoot = fileRoot.getName();
                            list = new LinkedList<File>();
                            list.add(fileRoot);
                            files = fileRoot.listFiles();
                            break block13;
                        }
                        if (request.getFilePaths() == null) break block14;
                        iterator = request.getFilePaths().iterator();
                        break block15;
                    }
                    while (!list.isEmpty()) {
                        File tempFile = (File)list.removeFirst();
                        if (null == tempFile || null == (files = tempFile.listFiles())) continue;
                        for (File file : files) {
                            String filePath;
                            if (file.isDirectory()) {
                                if (!file.exists()) {
                                    filePath = file.getCanonicalPath();
                                    String erroInfo = "putObjects: the folder \"" + filePath + "\" dose not a folder";
                                    ILOG.warn(erroInfo);
                                    continue;
                                }
                                list.add(file);
                                continue;
                            }
                            filePath = file.getCanonicalPath();
                            if (!file.exists()) {
                                ILOG.warn("putObjects: the file \"" + filePath + "\" dose not exist");
                                continue;
                            }
                            ++totalTasks;
                            String objectKey = prefix + folderRoot + filePath.substring(folderPath.length(), filePath.length()).replace("\\", "/");
                            this.uploadObjectTask(request, filePath, objectKey, executor, progressStatus, callback, listener);
                        }
                    }
                    break block14;
                }
                while (iterator.hasNext()) {
                    String filePath = iterator.next();
                    File file = new File(filePath);
                    if (file.exists()) {
                        ++totalTasks;
                        String objectKey = prefix + file.getName();
                        this.uploadObjectTask(request, filePath, objectKey, executor, progressStatus, callback, listener);
                        continue;
                    }
                    ILOG.warn("putObjects: the file \"" + filePath + "\" is not exist");
                }
            }
            progressStatus.setTotalTaskNum(totalTasks);
            executor.shutdown();
            executor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
            return progressStatus;
        }
        catch (ObsException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ObsException(e.getMessage(), e);
        }
    }

    private void uploadObjectTask(PutObjectsRequest request, String filePath, final String objectKey, ThreadPoolExecutor executor, final UploadTaskProgressStatus progressStatus, TaskCallback<PutObjectResult, PutObjectBasicRequest> callback, final UploadObjectsProgressListener listener) {
        File fileObject = new File(filePath);
        String bucketName = request.getBucketName();
        int progressInterval = request.getProgressInterval();
        int taskNum = request.getTaskNum();
        long detailProgressInterval = request.getDetailProgressInterval();
        long bigfileThreshold = request.getBigfileThreshold();
        long partSize = request.getPartSize();
        AccessControlList acl = request.getAcl();
        Map<ExtensionObjectPermissionEnum, Set<String>> extensionPermissionMap = request.getExtensionPermissionMap();
        SseCHeader sseCHeader = request.getSseCHeader();
        SseKmsHeader sseKmsHeader = request.getSseKmsHeader();
        String successRedirectLocation = request.getSuccessRedirectLocation();
        if (fileObject.length() > bigfileThreshold) {
            UploadFileRequest taskRequest = new UploadFileRequest(bucketName, objectKey);
            taskRequest.setUploadFile(filePath);
            taskRequest.setPartSize(partSize);
            taskRequest.setTaskNum(taskNum);
            taskRequest.setExtensionPermissionMap(extensionPermissionMap);
            taskRequest.setAcl(acl);
            taskRequest.setSuccessRedirectLocation(successRedirectLocation);
            taskRequest.setSseCHeader(sseCHeader);
            taskRequest.setSseKmsHeader(sseKmsHeader);
            taskRequest.setEnableCheckpoint(true);
            progressStatus.addTotalSize(fileObject.length());
            taskRequest.setRequesterPays(request.isRequesterPays());
            taskRequest.setProgressListener(new ProgressListener(){

                @Override
                public void progressChanged(ProgressStatus status) {
                    progressStatus.putTaskTable(objectKey, status);
                    if (progressStatus.isRefreshprogress()) {
                        Date dateNow = new Date();
                        long totalMilliseconds = dateNow.getTime() - progressStatus.getStartDate().getTime();
                        progressStatus.setTotalMilliseconds(totalMilliseconds);
                        listener.progressChanged(progressStatus);
                    }
                }
            });
            taskRequest.setProgressInterval(detailProgressInterval);
            ResumableUploadTask task = new ResumableUploadTask(this, bucketName, taskRequest, callback, listener, progressStatus, progressInterval);
            executor.execute(task);
        } else {
            PutObjectRequest taskRequest = new PutObjectRequest(bucketName, objectKey, fileObject);
            taskRequest.setExtensionPermissionMap(extensionPermissionMap);
            taskRequest.setAcl(acl);
            taskRequest.setSuccessRedirectLocation(successRedirectLocation);
            taskRequest.setSseCHeader(sseCHeader);
            taskRequest.setSseKmsHeader(sseKmsHeader);
            progressStatus.addTotalSize(fileObject.length());
            taskRequest.setRequesterPays(request.isRequesterPays());
            taskRequest.setProgressListener(new ProgressListener(){

                @Override
                public void progressChanged(ProgressStatus status) {
                    progressStatus.putTaskTable(objectKey, status);
                    if (progressStatus.isRefreshprogress()) {
                        Date dateNow = new Date();
                        long totalMilliseconds = dateNow.getTime() - progressStatus.getStartDate().getTime();
                        progressStatus.setTotalMilliseconds(totalMilliseconds);
                        listener.progressChanged(progressStatus);
                    }
                }
            });
            taskRequest.setProgressInterval(detailProgressInterval);
            PutObjectTask task = new PutObjectTask(this, bucketName, taskRequest, callback, listener, progressStatus, progressInterval);
            executor.execute(task);
        }
    }

    @Override
    public TaskProgressStatus dropFolder(DropFolderRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "DropFolderRequest is null");
        if (!this.isCname()) {
            ServiceUtils.asserParameterNotNull(request.getBucketName(), "bucketName is null");
        }
        ThreadPoolExecutor executor = this.initThreadPool(request);
        DefaultTaskProgressStatus progressStatus = new DefaultTaskProgressStatus();
        try {
            String folderName = request.getFolderName();
            String delimiter = this.getFileSystemDelimiter();
            if (!folderName.endsWith(delimiter)) {
                folderName = folderName + delimiter;
            }
            LazyTaksCallback<DeleteObjectResult, String> callback = request.getCallback() == null ? new LazyTaksCallback() : request.getCallback();
            TaskProgressListener listener = request.getProgressListener();
            int interval = request.getProgressInterval();
            int[] totalTasks = new int[]{0};
            boolean isSubDeleted = this.recurseFolders(request, folderName, callback, progressStatus, executor, totalTasks);
            HashMap futures = new HashMap();
            totalTasks[0] = totalTasks[0] + 1;
            progressStatus.setTotalTaskNum(totalTasks[0]);
            if (isSubDeleted) {
                this.submitDropTask(request, folderName, callback, progressStatus, executor, futures);
                this.checkDropFutures(futures, progressStatus, callback, listener, interval);
            } else {
                progressStatus.failTaskIncrement();
                callback.onException(new ObsException("Failed to delete due to child file deletion failed"), folderName);
                this.recordBulkTaskStatus(progressStatus, callback, listener, interval);
            }
            executor.shutdown();
            executor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (ObsException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ObsException(e.getMessage(), e);
        }
        return progressStatus;
    }

    @Override
    public ListContentSummaryResult listContentSummary(final ListContentSummaryRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "ListContentSummaryRequest is null");
        return this.doActionWithResult("listcontentsummary", request.getBucketName(), new ActionCallbackWithResult<ListContentSummaryResult>(){

            @Override
            public ListContentSummaryResult action() throws ServiceException {
                return ObsClient.this.listContentSummaryImpl(request);
            }
        });
    }

    private boolean recurseFolders(DropFolderRequest dropRequest, String folders, TaskCallback<DeleteObjectResult, String> callback, DefaultTaskProgressStatus progressStatus, ThreadPoolExecutor executor, int[] count) {
        ObjectListing result;
        ListObjectsRequest request = new ListObjectsRequest(dropRequest.getBucketName());
        request.setDelimiter("/");
        request.setPrefix(folders);
        request.setRequesterPays(dropRequest.isRequesterPays());
        boolean isDeleted = true;
        do {
            result = this.listObjects(request);
            HashMap futures = new HashMap();
            for (ObsObject o : result.getObjects()) {
                if (o.getObjectKey().endsWith("/")) continue;
                count[0] = count[0] + 1;
                boolean bl = isDeleted = this.submitDropTask(dropRequest, o.getObjectKey(), callback, progressStatus, executor, futures) && isDeleted;
                if (!ILOG.isInfoEnabled() || count[0] % 1000 != 0) continue;
                ILOG.info("DropFolder: " + Arrays.toString(count) + " tasks have submitted to delete objects");
            }
            for (String prefix : result.getCommonPrefixes()) {
                boolean isSubDeleted = this.recurseFolders(dropRequest, prefix, callback, progressStatus, executor, count);
                count[0] = count[0] + 1;
                if (isSubDeleted) {
                    isDeleted = this.submitDropTask(dropRequest, prefix, callback, progressStatus, executor, futures) && isDeleted;
                } else {
                    progressStatus.failTaskIncrement();
                    callback.onException(new ObsException("Failed to delete due to child file deletion failed"), prefix);
                    this.recordBulkTaskStatus(progressStatus, callback, dropRequest.getProgressListener(), dropRequest.getProgressInterval());
                }
                if (!ILOG.isInfoEnabled() || count[0] % 1000 != 0) continue;
                ILOG.info("DropFolder: " + Arrays.toString(count) + " tasks have submitted to delete objects");
            }
            request.setMarker(result.getNextMarker());
            boolean bl = isDeleted = this.checkDropFutures(futures, progressStatus, callback, dropRequest.getProgressListener(), dropRequest.getProgressInterval()) && isDeleted;
        } while (result.isTruncated());
        return isDeleted;
    }

    private boolean submitDropTask(DropFolderRequest request, String key, TaskCallback<DeleteObjectResult, String> callback, DefaultTaskProgressStatus progreStatus, ThreadPoolExecutor executor, Map<String, Future<?>> futures) {
        DropFolderTask task = new DropFolderTask(this, request.getBucketName(), key, progreStatus, request.getProgressListener(), request.getProgressInterval(), callback, request.isRequesterPays());
        try {
            futures.put(key, executor.submit(task));
        }
        catch (RejectedExecutionException e) {
            progreStatus.failTaskIncrement();
            callback.onException(new ObsException(e.getMessage(), e), key);
            return false;
        }
        return true;
    }

    private boolean checkDropFutures(Map<String, Future<?>> futures, DefaultTaskProgressStatus progressStatus, TaskCallback<DeleteObjectResult, String> callback, TaskProgressListener listener, int interval) {
        boolean isDeleted = true;
        for (Map.Entry<String, Future<?>> entry : futures.entrySet()) {
            try {
                entry.getValue().get();
            }
            catch (ExecutionException e) {
                progressStatus.failTaskIncrement();
                if (e.getCause() instanceof ObsException) {
                    callback.onException((ObsException)e.getCause(), entry.getKey());
                } else {
                    callback.onException(new ObsException(e.getMessage(), e), entry.getKey());
                }
                isDeleted = false;
            }
            catch (InterruptedException e) {
                progressStatus.failTaskIncrement();
                callback.onException(new ObsException(e.getMessage(), e), entry.getKey());
                isDeleted = false;
            }
            this.recordBulkTaskStatus(progressStatus, callback, listener, interval);
        }
        return isDeleted;
    }

    @Override
    public DeleteObjectResult deleteObject(String bucketName, String objectKey, String versionId) throws ObsException {
        DeleteObjectRequest request = new DeleteObjectRequest(bucketName, objectKey, versionId);
        return this.deleteObject(request);
    }

    @Override
    public DeleteObjectResult deleteObject(String bucketName, String objectKey) throws ObsException {
        DeleteObjectRequest request = new DeleteObjectRequest(bucketName, objectKey);
        return this.deleteObject(request);
    }

    @Override
    public DeleteObjectResult deleteObject(final DeleteObjectRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "DeleteObjectRequest is null");
        return this.doActionWithResult("deleteObject", request.getBucketName(), new ActionCallbackWithResult<DeleteObjectResult>(){

            @Override
            public DeleteObjectResult action() throws ServiceException {
                ServiceUtils.asserParameterNotNull2(request.getObjectKey(), "objectKey is null");
                return ObsClient.this.deleteObjectImpl(request);
            }
        });
    }

    @Override
    public DeleteObjectsResult deleteObjects(final DeleteObjectsRequest deleteObjectsRequest) throws ObsException {
        ServiceUtils.asserParameterNotNull(deleteObjectsRequest, "DeleteObjectsRequest is null");
        return this.doActionWithResult("deleteObjects", deleteObjectsRequest.getBucketName(), new ActionCallbackWithResult<DeleteObjectsResult>(){

            @Override
            public DeleteObjectsResult action() throws ServiceException {
                return ObsClient.this.deleteObjectsImpl(deleteObjectsRequest);
            }
        });
    }

    @Override
    public AccessControlList getObjectAcl(String bucketName, String objectKey, String versionId) throws ObsException {
        return this.getObjectAcl(new GetObjectAclRequest(bucketName, objectKey, versionId));
    }

    @Override
    public AccessControlList getObjectAcl(String bucketName, String objectKey) throws ObsException {
        return this.getObjectAcl(new GetObjectAclRequest(bucketName, objectKey, null));
    }

    @Override
    public AccessControlList getObjectAcl(final GetObjectAclRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "GetObjectAclRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getObjectKey(), "objectKey is null");
        return this.doActionWithResult("getObjectAcl", request.getBucketName(), new ActionCallbackWithResult<AccessControlList>(){

            @Override
            public AccessControlList action() throws ServiceException {
                return ObsClient.this.getObjectAclImpl(request);
            }
        });
    }

    @Deprecated
    public HeaderResponse setObjectAcl(String bucketName, String objectKey, String cannedACL, AccessControlList acl, String versionId) throws ObsException {
        SetObjectAclRequest request = new SetObjectAclRequest(bucketName, objectKey, acl, versionId);
        request.setCannedACL(cannedACL);
        return this.setObjectAcl(request);
    }

    @Override
    public HeaderResponse setObjectAcl(final SetObjectAclRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "SetObjectAclRequest is null");
        return this.doActionWithResult("setObjectAcl", request.getBucketName(), new ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                if (request.getAcl() == null && null == request.getCannedACL()) {
                    throw new IllegalArgumentException("Both cannedACL and AccessControlList is null");
                }
                return ObsClient.this.setObjectAclImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse setObjectAcl(String bucketName, String objectKey, AccessControlList acl, String versionId) throws ObsException {
        return this.setObjectAcl(new SetObjectAclRequest(bucketName, objectKey, acl, versionId));
    }

    @Override
    public HeaderResponse setObjectAcl(String bucketName, String objectKey, AccessControlList acl) throws ObsException {
        return this.setObjectAcl(new SetObjectAclRequest(bucketName, objectKey, acl));
    }

    @Override
    public CopyObjectResult copyObject(final CopyObjectRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "CopyObjectRequest is null");
        ServiceUtils.asserParameterNotNull(request.getDestinationBucketName(), "destinationBucketName is null");
        ServiceUtils.asserParameterNotNull2(request.getSourceObjectKey(), "sourceObjectKey is null");
        ServiceUtils.asserParameterNotNull2(request.getDestinationObjectKey(), "destinationObjectKey is null");
        return this.doActionWithResult("copyObject", request.getSourceBucketName(), new ActionCallbackWithResult<CopyObjectResult>(){

            @Override
            public CopyObjectResult action() throws ServiceException {
                return ObsClient.this.copyObjectImpl(request);
            }
        });
    }

    @Override
    public CopyObjectResult copyObject(String sourceBucketName, String sourceObjectKey, String destBucketName, String destObjectKey) throws ObsException {
        return this.copyObject(new CopyObjectRequest(sourceBucketName, sourceObjectKey, destBucketName, destObjectKey));
    }

    @Override
    public InitiateMultipartUploadResult initiateMultipartUpload(final InitiateMultipartUploadRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "InitiateMultipartUploadRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getObjectKey(), "objectKey is null");
        return this.doActionWithResult("initiateMultipartUpload", request.getBucketName(), new ActionCallbackWithResult<InitiateMultipartUploadResult>(){

            @Override
            public InitiateMultipartUploadResult action() throws ServiceException {
                return ObsClient.this.initiateMultipartUploadImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse abortMultipartUpload(final AbortMultipartUploadRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "AbortMultipartUploadRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getObjectKey(), "objectKey is null");
        ServiceUtils.asserParameterNotNull(request.getUploadId(), "uploadId is null");
        return this.doActionWithResult("abortMultipartUpload", request.getBucketName(), new ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return ObsClient.this.abortMultipartUploadImpl(request);
            }
        });
    }

    @Override
    public UploadPartResult uploadPart(String bucketName, String objectKey, String uploadId, int partNumber, InputStream input) throws ObsException {
        UploadPartRequest request = new UploadPartRequest();
        request.setBucketName(bucketName);
        request.setObjectKey(objectKey);
        request.setUploadId(uploadId);
        request.setPartNumber(partNumber);
        request.setInput(input);
        return this.uploadPart(request);
    }

    @Override
    public UploadPartResult uploadPart(String bucketName, String objectKey, String uploadId, int partNumber, File file) throws ObsException {
        UploadPartRequest request = new UploadPartRequest();
        request.setBucketName(bucketName);
        request.setObjectKey(objectKey);
        request.setUploadId(uploadId);
        request.setPartNumber(partNumber);
        request.setFile(file);
        return this.uploadPart(request);
    }

    @Override
    public UploadPartResult uploadPart(final UploadPartRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "UploadPartRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getObjectKey(), "objectKey is null");
        ServiceUtils.asserParameterNotNull(request.getUploadId(), "uploadId is null");
        return this.doActionWithResult("uploadPart", request.getBucketName(), new ActionCallbackWithResult<UploadPartResult>(){

            @Override
            public UploadPartResult action() throws ServiceException {
                if (null != request.getInput() && null != request.getFile()) {
                    throw new ServiceException("Both input and file are set, only one is allowed");
                }
                return ObsClient.this.uploadPartImpl(request);
            }
        });
    }

    @Override
    public CopyPartResult copyPart(final CopyPartRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "CopyPartRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getSourceObjectKey(), "sourceObjectKey is null");
        ServiceUtils.asserParameterNotNull(request.getDestinationBucketName(), "destinationBucketName is null");
        ServiceUtils.asserParameterNotNull2(request.getDestinationObjectKey(), "destinationObjectKey is null");
        ServiceUtils.asserParameterNotNull(request.getUploadId(), "uploadId is null");
        return this.doActionWithResult("copyPart", request.getSourceBucketName(), new ActionCallbackWithResult<CopyPartResult>(){

            @Override
            public CopyPartResult action() throws ServiceException {
                return ObsClient.this.copyPartImpl(request);
            }
        });
    }

    @Override
    public CompleteMultipartUploadResult completeMultipartUpload(final CompleteMultipartUploadRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "CompleteMultipartUploadRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getObjectKey(), "objectKey is null");
        ServiceUtils.asserParameterNotNull(request.getUploadId(), "uploadId is null");
        return this.doActionWithResult("completeMultipartUpload", request.getBucketName(), new ActionCallbackWithResult<CompleteMultipartUploadResult>(){

            @Override
            public CompleteMultipartUploadResult action() throws ServiceException {
                return ObsClient.this.completeMultipartUploadImpl(request);
            }
        });
    }

    @Override
    public ListPartsResult listParts(final ListPartsRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "ListPartsRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getKey(), "objectKey is null");
        ServiceUtils.asserParameterNotNull(request.getUploadId(), "uploadId is null");
        return this.doActionWithResult("listParts", request.getBucketName(), new ActionCallbackWithResult<ListPartsResult>(){

            @Override
            public ListPartsResult action() throws ServiceException {
                return ObsClient.this.listPartsImpl(request);
            }
        });
    }

    @Override
    public MultipartUploadListing listMultipartUploads(final ListMultipartUploadsRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "ListMultipartUploadsRequest is null");
        return this.doActionWithResult("listMultipartUploads", request.getBucketName(), new ActionCallbackWithResult<MultipartUploadListing>(){

            @Override
            public MultipartUploadListing action() throws ServiceException {
                return ObsClient.this.listMultipartUploadsImpl(request);
            }
        });
    }

    @Override
    public RenameObjectResult renameObject(String bucketName, String objectKey, String newObjectKey) throws ObsException {
        RenameObjectRequest request = new RenameObjectRequest();
        request.setBucketName(bucketName);
        request.setObjectKey(objectKey);
        request.setNewObjectKey(newObjectKey);
        return this.renameObject(request);
    }

    @Override
    public RenameObjectResult renameObject(final RenameObjectRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "RenameObjectRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getObjectKey(), "ObjectKey is null");
        ServiceUtils.asserParameterNotNull2(request.getNewObjectKey(), "NewObjectKey is null");
        return this.doActionWithResult("renameObject", request.getBucketName(), new ActionCallbackWithResult<RenameObjectResult>(){

            @Override
            public RenameObjectResult action() throws ServiceException {
                return ObsClient.this.renameObjectImpl(request);
            }
        });
    }

    @Override
    public TruncateObjectResult truncateObject(String bucketName, String objectKey, long newLength) throws ObsException {
        TruncateObjectRequest request = new TruncateObjectRequest();
        request.setBucketName(bucketName);
        request.setObjectKey(objectKey);
        request.setNewLength(newLength);
        return this.truncateObject(request);
    }

    @Override
    public TruncateObjectResult truncateObject(final TruncateObjectRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "TruncateObjectRequest is null");
        ServiceUtils.asserParameterNotNull(request.getNewLength(), "NewLength is null");
        ServiceUtils.asserParameterNotNull2(request.getObjectKey(), "ObjectKey is null");
        return this.doActionWithResult("truncateObject", request.getBucketName(), new ActionCallbackWithResult<TruncateObjectResult>(){

            @Override
            public TruncateObjectResult action() throws ServiceException {
                return ObsClient.this.truncateObjectImpl(request);
            }
        });
    }

    @Override
    public ModifyObjectResult modifyObject(String bucketName, String objectKey, long position, File file) throws ObsException {
        ModifyObjectRequest request = new ModifyObjectRequest();
        request.setBucketName(bucketName);
        request.setObjectKey(objectKey);
        request.setPosition(position);
        request.setFile(file);
        return this.modifyObject(request);
    }

    @Override
    public ModifyObjectResult modifyObject(String bucketName, String objectKey, long position, InputStream input) throws ObsException {
        ModifyObjectRequest request = new ModifyObjectRequest();
        request.setBucketName(bucketName);
        request.setObjectKey(objectKey);
        request.setPosition(position);
        request.setInput(input);
        return this.modifyObject(request);
    }

    @Override
    public ModifyObjectResult modifyObject(final ModifyObjectRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "ModifyObjectRequest is null");
        ServiceUtils.asserParameterNotNull(request.getPosition(), "position is null");
        ServiceUtils.asserParameterNotNull2(request.getObjectKey(), "objectKey is null");
        return this.doActionWithResult("modifyObject", request.getBucketName(), new ActionCallbackWithResult<ModifyObjectResult>(){

            @Override
            public ModifyObjectResult action() throws ServiceException {
                return ObsClient.this.modifyObjectImpl(request);
            }
        });
    }

    @Override
    public ObsFSBucket newBucket(NewBucketRequest request) throws ObsException {
        ObsBucket bucket = this.createBucket(request);
        ObsFSBucket fsBucket = new ObsFSBucket(bucket.getBucketName(), bucket.getLocation());
        ReflectUtils.setInnerClient(fsBucket, this);
        return fsBucket;
    }

    @Override
    public ObsFSFile newFile(NewFileRequest request) throws ObsException {
        ObsFSFile obsFile = (ObsFSFile)this.putObject(request);
        ReflectUtils.setInnerClient(obsFile, this);
        return obsFile;
    }

    @Override
    public ObsFSFolder newFolder(NewFolderRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "CreateFolderRequest is null");
        if (request.getObjectKey() != null) {
            String delimiter = this.getFileSystemDelimiter();
            if (!request.getObjectKey().endsWith(delimiter)) {
                request.setObjectKey(request.getObjectKey() + delimiter);
            }
        }
        ObsFSFolder obsFolder = (ObsFSFolder)this.putObject(new PutObjectRequest(request));
        ReflectUtils.setInnerClient(obsFolder, this);
        return obsFolder;
    }

    @Override
    public ObsFSAttribute getAttribute(GetAttributeRequest request) throws ObsException {
        return (ObsFSAttribute)this.getObjectMetadata(request);
    }

    @Override
    public ReadFileResult readFile(ReadFileRequest request) throws ObsException {
        return (ReadFileResult)this.getObject(request);
    }

    @Override
    public ObsFSFile writeFile(final WriteFileRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "WriteFileRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getObjectKey(), "objectKey is null");
        ObsFSFile obsFile = this.doActionWithResult("writeFile", request.getBucketName(), new ActionCallbackWithResult<ObsFSFile>(){

            @Override
            public ObsFSFile action() throws ServiceException {
                if (null != request.getInput() && null != request.getFile()) {
                    throw new ServiceException("Both input and file are set, only one is allowed");
                }
                return ObsClient.this.writeFileImpl(request);
            }
        });
        ReflectUtils.setInnerClient(obsFile, this);
        return obsFile;
    }

    @Override
    public ObsFSFile appendFile(WriteFileRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "WriteFileRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getObjectKey(), "objectKey is null");
        ObjectMetadata metadata = this.getObjectMetadata(new GetObjectMetadataRequest(request.getBucketName(), request.getObjectKey()));
        if (request.getPosition() >= 0L && request.getPosition() != metadata.getNextPosition()) {
            throw new IllegalArgumentException("Where you proposed append to is not equal to length");
        }
        request.setPosition(metadata.getNextPosition());
        return this.writeFile(request);
    }

    @Override
    public RenameResult renameFile(final RenameRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "RenameRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getObjectKey(), "ObjectKey is null");
        ServiceUtils.asserParameterNotNull2(request.getNewObjectKey(), "NewObjectKey is null");
        return this.doActionWithResult("rename", request.getBucketName(), new ActionCallbackWithResult<RenameResult>(){

            @Override
            public RenameResult action() throws ServiceException {
                return ObsClient.this.renameFileImpl(request);
            }
        });
    }

    @Override
    public RenameResult renameFolder(RenameRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "RenameRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getObjectKey(), "ObjectKey is null");
        ServiceUtils.asserParameterNotNull2(request.getNewObjectKey(), "NewObjectKey is null");
        String delimiter = this.getFileSystemDelimiter();
        if (!request.getObjectKey().endsWith(delimiter)) {
            request.setObjectKey(request.getObjectKey() + delimiter);
        }
        if (!request.getNewObjectKey().endsWith(delimiter)) {
            request.setNewObjectKey(request.getNewObjectKey() + delimiter);
        }
        return this.renameFile(request);
    }

    @Override
    public TruncateFileResult truncateFile(final TruncateFileRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "TruncateFileRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getObjectKey(), "ObjectKey is null");
        return this.doActionWithResult("truncateFile", request.getBucketName(), new ActionCallbackWithResult<TruncateFileResult>(){

            @Override
            public TruncateFileResult action() throws ServiceException {
                return ObsClient.this.truncateFileImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse setBucketFSStatus(final SetBucketFSStatusRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "SetBucketFileInterfaceRequest is null");
        return this.doActionWithResult("setBucketFSStatus", request.getBucketName(), new ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return ObsClient.this.setBucketFSStatusImpl(request);
            }
        });
    }

    @Override
    public GetBucketFSStatusResult getBucketFSStatus(final GetBucketFSStatusRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "GetBucketFSStatusRequest is null");
        return this.doActionWithResult("getBucketFSStatus", request.getBucketName(), new ActionCallbackWithResult<GetBucketFSStatusResult>(){

            @Override
            public GetBucketFSStatusResult action() throws ServiceException {
                return ObsClient.this.getBucketMetadataImpl(request);
            }
        });
    }

    @Override
    public DropFileResult dropFile(final DropFileRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "DropFileRequest is null");
        return this.doActionWithResult("dropFile", request.getBucketName(), new ActionCallbackWithResult<DropFileResult>(){

            @Override
            public DropFileResult action() throws ServiceException {
                ServiceUtils.asserParameterNotNull2(request.getObjectKey(), "objectKey is null");
                return (DropFileResult)ObsClient.this.deleteObjectImpl(new DeleteObjectRequest(request.getBucketName(), request.getObjectKey(), request.getVersionId()));
            }
        });
    }

    @Override
    public ReadAheadResult readAheadObjects(final ReadAheadRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "request is null");
        return this.doActionWithResult("readAheadObjects", request.getBucketName(), new ActionCallbackWithResult<ReadAheadResult>(){

            @Override
            public ReadAheadResult action() throws ServiceException {
                return ObsClient.this.readAheadObjectsImpl(request);
            }
        });
    }

    @Override
    public ReadAheadResult deleteReadAheadObjects(final String bucketName, final String prefix) throws ObsException {
        ServiceUtils.asserParameterNotNull(bucketName, "bucketName is null");
        ServiceUtils.asserParameterNotNull(prefix, "prefix is null");
        return this.doActionWithResult("deleteReadAheadObjects", bucketName, new ActionCallbackWithResult<ReadAheadResult>(){

            @Override
            public ReadAheadResult action() throws ServiceException {
                return ObsClient.this.deleteReadAheadObjectsImpl(bucketName, prefix);
            }
        });
    }

    @Override
    public ReadAheadQueryResult queryReadAheadObjectsTask(final String bucketName, final String taskId) throws ObsException {
        ServiceUtils.asserParameterNotNull(bucketName, "bucketName is null");
        ServiceUtils.asserParameterNotNull(taskId, "taskId is null");
        return this.doActionWithResult("queryReadAheadObjectsTask", bucketName, new ActionCallbackWithResult<ReadAheadQueryResult>(){

            @Override
            public ReadAheadQueryResult action() throws ServiceException {
                return ObsClient.this.queryReadAheadObjectsTaskImpl(bucketName, taskId);
            }
        });
    }

    @Override
    public HeaderResponse setBucketDirectColdAccess(String bucketName, BucketDirectColdAccess access) throws ObsException {
        return this.setBucketDirectColdAccess(new SetBucketDirectColdAccessRequest(bucketName, access));
    }

    @Override
    public HeaderResponse setBucketDirectColdAccess(final SetBucketDirectColdAccessRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "SetBucketDirectColdAccessRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getBucketName(), "bucketName is null");
        ServiceUtils.asserParameterNotNull(request.getAccess(), "bucketDirectColdAccess is null");
        return this.doActionWithResult("setBucketDirectColdAccess", request.getBucketName(), new ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return ObsClient.this.setBucketDirectColdAccessImpl(request);
            }
        });
    }

    @Override
    public BucketDirectColdAccess getBucketDirectColdAccess(String bucketName) throws ObsException {
        return this.getBucketDirectColdAccess(new BaseBucketRequest(bucketName));
    }

    @Override
    public BucketDirectColdAccess getBucketDirectColdAccess(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BaseBucketRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("getBucketDirectColdAccess", request.getBucketName(), new ActionCallbackWithResult<BucketDirectColdAccess>(){

            @Override
            public BucketDirectColdAccess action() throws ServiceException {
                return ObsClient.this.getBucketDirectColdAccessImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse deleteBucketDirectColdAccess(String bucketName) throws ObsException {
        return this.deleteBucketDirectColdAccess(new BaseBucketRequest(bucketName));
    }

    @Override
    public HeaderResponse deleteBucketDirectColdAccess(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BaseBucketRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("deleteBucketDirectColdAccess", request.getBucketName(), new ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return ObsClient.this.deleteBucketDirectColdAccessImpl(request);
            }
        });
    }

    @Override
    public boolean doesObjectExist(String buckeName, String objectKey) throws ObsException {
        GetObjectMetadataRequest request = new GetObjectMetadataRequest(buckeName, objectKey);
        return this.doesObjectExist(request);
    }

    @Override
    public boolean doesObjectExist(GetObjectMetadataRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request.getBucketName(), "bucke is null");
        ServiceUtils.asserParameterNotNull2(request.getObjectKey(), "objectKey is null");
        try {
            return this.doesObjectExistImpl(request);
        }
        catch (ServiceException e) {
            if (this.isAuthTypeNegotiation() && e.getResponseCode() == 400 && "Unsupported Authorization Type".equals(e.getErrorMessage()) && this.getProviderCredentials().getAuthType() == AuthTypeEnum.OBS) {
                this.getProviderCredentials().setThreadLocalAuthType(AuthTypeEnum.V2);
                return this.doesObjectExistImpl(request);
            }
            throw e;
        }
    }

    private <T> T doActionWithResult(String action, String bucketName, ActionCallbackWithResult<T> callback) throws ObsException {
        if (!this.isCname()) {
            ServiceUtils.asserParameterNotNull(bucketName, "bucketName is null");
        }
        InterfaceLogBean reqBean = new InterfaceLogBean(action, this.getEndpoint(), "");
        try {
            long start = System.currentTimeMillis();
            if (this.isAuthTypeNegotiation()) {
                callback.authTypeNegotiate(bucketName);
            }
            T ret = callback.action();
            reqBean.setRespTime(new Date());
            reqBean.setResultCode("0");
            if (ILOG.isInfoEnabled()) {
                ILOG.info(reqBean);
                ILOG.info("ObsClient [" + action + "] cost " + (System.currentTimeMillis() - start) + " ms");
            }
            T t = ret;
            return t;
        }
        catch (ServiceException e) {
            ObsException ex = ServiceUtils.changeFromServiceException(e);
            if (ex.getResponseCode() >= 400 && ex.getResponseCode() < 500) {
                if (ILOG.isWarnEnabled()) {
                    reqBean.setRespTime(new Date());
                    reqBean.setResultCode(String.valueOf(e.getResponseCode()));
                    ILOG.warn(reqBean);
                }
            } else if (ILOG.isErrorEnabled()) {
                reqBean.setRespTime(new Date());
                reqBean.setResultCode(String.valueOf(ex.getResponseCode()));
                ILOG.error(reqBean);
            }
            throw ex;
        }
        finally {
            if (this.isAuthTypeNegotiation()) {
                this.getProviderCredentials().removeThreadLocalAuthType();
            }
            AccessLoggerUtils.printLog();
        }
    }

    @Override
    public void close() throws IOException {
        this.shutdown();
    }

    public String base64Md5(InputStream is, long length, long offset) throws NoSuchAlgorithmException, IOException {
        return ServiceUtils.toBase64(ServiceUtils.computeMD5Hash(is, length, offset));
    }

    public String base64Md5(InputStream is) throws NoSuchAlgorithmException, IOException {
        return ServiceUtils.toBase64(ServiceUtils.computeMD5Hash(is));
    }

    private abstract class ActionCallbackWithResult<T> {
        private ActionCallbackWithResult() {
        }

        abstract T action() throws ServiceException;

        void authTypeNegotiate(String bucketName) throws ServiceException {
            AuthTypeEnum authTypeEnum = ObsClient.this.getApiVersion(bucketName);
            ObsClient.this.getProviderCredentials().setThreadLocalAuthType(authTypeEnum);
        }
    }
}

