/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.model;

import com.obs.services.model.KeyAndVersion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DeleteObjectsRequest {
    private String bucketName;
    private boolean quiet;
    private List<KeyAndVersion> keyAndVersions;

    public DeleteObjectsRequest() {
    }

    public DeleteObjectsRequest(String bucketName) {
        this.bucketName = bucketName;
    }

    public DeleteObjectsRequest(String bucketName, boolean quiet, KeyAndVersion[] keyAndVersions) {
        this.bucketName = bucketName;
        this.quiet = quiet;
        this.setKeyAndVersions(keyAndVersions);
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public List<KeyAndVersion> getKeyAndVersionsList() {
        if (this.keyAndVersions == null) {
            this.keyAndVersions = new ArrayList<KeyAndVersion>();
        }
        return this.keyAndVersions;
    }

    public KeyAndVersion addKeyAndVersion(String objectKey, String versionId) {
        KeyAndVersion kv = new KeyAndVersion(objectKey, versionId);
        this.getKeyAndVersionsList().add(kv);
        return kv;
    }

    public KeyAndVersion addKeyAndVersion(String objectKey) {
        return this.addKeyAndVersion(objectKey, null);
    }

    public KeyAndVersion[] getKeyAndVersions() {
        return this.getKeyAndVersionsList().toArray(new KeyAndVersion[this.getKeyAndVersionsList().size()]);
    }

    public void setKeyAndVersions(KeyAndVersion[] keyAndVersions) {
        if (keyAndVersions != null && keyAndVersions.length > 0) {
            this.keyAndVersions = new ArrayList<KeyAndVersion>(Arrays.asList(keyAndVersions));
        }
    }

    public String toString() {
        return "DeleteObjectsRequest [bucketName=" + this.bucketName + ", quiet=" + this.quiet + ", keyAndVersions=" + this.keyAndVersions + "]";
    }
}

