/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.utils;

import com.obs.services.ObsClient;
import com.obs.services.exception.ObsException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ReflectUtils {
    private static Class<?> androidBase64Class;
    private static Class<?> jdkBase64EncoderClass;
    private static Class<?> jdkBase64DecoderClass;
    private static Map<String, Field> fields;

    public static String toBase64(byte[] data) {
        if (androidBase64Class != null) {
            try {
                Method m = androidBase64Class.getMethod("encode", byte[].class, Integer.TYPE);
                return new String((byte[])m.invoke(null, data, 2));
            }
            catch (Exception m) {
                // empty catch block
            }
        }
        if (jdkBase64EncoderClass != null) {
            try {
                Method m = jdkBase64EncoderClass.getMethod("encode", byte[].class);
                String temp = (String)m.invoke(jdkBase64EncoderClass.newInstance(), new Object[]{data});
                return temp.replaceAll("\\s", "");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static byte[] fromBase64(String b64Data) throws UnsupportedEncodingException {
        if (androidBase64Class != null) {
            try {
                Method m = androidBase64Class.getMethod("decode", byte[].class, Integer.TYPE);
                return (byte[])m.invoke(null, b64Data.getBytes("UTF-8"), 2);
            }
            catch (Exception m) {
                // empty catch block
            }
        }
        if (jdkBase64DecoderClass != null) {
            try {
                Method m = jdkBase64DecoderClass.getMethod("decodeBuffer", String.class);
                return (byte[])m.invoke(jdkBase64DecoderClass.newInstance(), b64Data);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static void setInnerClient(Object obj, ObsClient obsClient) {
        if (obj != null && obsClient != null) {
            Class<?> clazz = obj.getClass();
            String name = clazz.getName();
            Field f = fields.get(name);
            try {
                if (f == null) {
                    f = ReflectUtils.getFieldFromClass(clazz, "innerClient");
                    f.setAccessible(true);
                    fields.put(name, f);
                }
                f.set(obj, obsClient);
            }
            catch (Exception e) {
                throw new ObsException(e.getMessage(), e);
            }
        }
    }

    private static Field getFieldFromClass(Class<?> clazz, String key) {
        while (true) {
            try {
                return clazz.getDeclaredField(key);
            }
            catch (NoSuchFieldException e) {
                if ((clazz = clazz.getSuperclass()) != null) continue;
                return null;
            }
            break;
        }
    }

    static {
        fields = new ConcurrentHashMap<String, Field>();
        try {
            androidBase64Class = Class.forName("android.util.Base64");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            jdkBase64EncoderClass = Class.forName("sun.misc.BASE64Encoder");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            jdkBase64DecoderClass = Class.forName("sun.misc.BASE64Decoder");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

