/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.utils;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class Mimetypes {
    private static final ILogger log = LoggerBuilder.getLogger(Mimetypes.class);
    public static final String MIMETYPE_XML = "application/xml";
    public static final String MIMETYPE_TEXT_XML = "text/xml";
    public static final String MIMETYPE_TEXT_PLAIN = "text/plain";
    public static final String MIMETYPE_HTML = "text/html";
    public static final String MIMETYPE_OCTET_STREAM = "application/octet-stream";
    public static final String MIMETYPE_BINARY_OCTET_STREAM = "binary/octet-stream";
    public static final String MIMETYPE_GZIP = "application/x-gzip";
    private final Map<String, String> extensionToMimetypeMap = new HashMap<String, String>();

    private Mimetypes() {
        this.extensionToMimetypeMap.put("txt", MIMETYPE_TEXT_PLAIN);
        this.extensionToMimetypeMap.put("html", MIMETYPE_HTML);
        this.extensionToMimetypeMap.put("htm", MIMETYPE_HTML);
        this.extensionToMimetypeMap.put("7z", "application/x-7z-compressed");
        this.extensionToMimetypeMap.put("aac", "audio/x-aac");
        this.extensionToMimetypeMap.put("ai", "application/postscript");
        this.extensionToMimetypeMap.put("aif", "audio/x-aiff");
        this.extensionToMimetypeMap.put("asc", MIMETYPE_TEXT_PLAIN);
        this.extensionToMimetypeMap.put("asf", "video/x-ms-asf");
        this.extensionToMimetypeMap.put("atom", "application/atom+xml");
        this.extensionToMimetypeMap.put("avi", "video/x-msvideo");
        this.extensionToMimetypeMap.put("bmp", "image/bmp");
        this.extensionToMimetypeMap.put("bz2", "application/x-bzip2");
        this.extensionToMimetypeMap.put("cer", "application/pkix-cert");
        this.extensionToMimetypeMap.put("crl", "application/pkix-crl");
        this.extensionToMimetypeMap.put("crt", "application/x-x509-ca-cert");
        this.extensionToMimetypeMap.put("css", "text/css");
        this.extensionToMimetypeMap.put("csv", "text/csv");
        this.extensionToMimetypeMap.put("cu", "application/cu-seeme");
        this.extensionToMimetypeMap.put("deb", "application/x-debian-package");
        this.extensionToMimetypeMap.put("doc", "application/msword");
        this.extensionToMimetypeMap.put("docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document");
        this.extensionToMimetypeMap.put("dvi", "application/x-dvi");
        this.extensionToMimetypeMap.put("eot", "application/vnd.ms-fontobject");
        this.extensionToMimetypeMap.put("eps", "application/postscript");
        this.extensionToMimetypeMap.put("epub", "application/epub+zip");
        this.extensionToMimetypeMap.put("etx", "text/x-setext");
        this.extensionToMimetypeMap.put("flac", "audio/flac");
        this.extensionToMimetypeMap.put("flv", "video/x-flv");
        this.extensionToMimetypeMap.put("gif", "image/gif");
        this.extensionToMimetypeMap.put("gz", "application/gzip");
        this.extensionToMimetypeMap.put("ico", "image/x-icon");
        this.extensionToMimetypeMap.put("ics", "text/calendar");
        this.extensionToMimetypeMap.put("ini", MIMETYPE_TEXT_PLAIN);
        this.extensionToMimetypeMap.put("iso", "application/x-iso9660-image");
        this.extensionToMimetypeMap.put("jar", "application/java-archive");
        this.extensionToMimetypeMap.put("jpe", "image/jpeg");
        this.extensionToMimetypeMap.put("jpeg", "image/jpeg");
        this.extensionToMimetypeMap.put("jpg", "image/jpeg");
        this.extensionToMimetypeMap.put("js", "text/javascript");
        this.extensionToMimetypeMap.put("json", "application/json");
        this.extensionToMimetypeMap.put("latex", "application/x-latex");
        this.extensionToMimetypeMap.put("log", MIMETYPE_TEXT_PLAIN);
        this.extensionToMimetypeMap.put("m4a", "audio/mp4");
        this.extensionToMimetypeMap.put("m4v", "video/mp4");
        this.extensionToMimetypeMap.put("mid", "audio/midi");
        this.extensionToMimetypeMap.put("midi", "audio/midi");
        this.extensionToMimetypeMap.put("mov", "video/quicktime");
        this.extensionToMimetypeMap.put("mp3", "audio/mpeg");
        this.extensionToMimetypeMap.put("mp4", "video/mp4");
        this.extensionToMimetypeMap.put("mp4a", "audio/mp4");
        this.extensionToMimetypeMap.put("mp4v", "video/mp4");
        this.extensionToMimetypeMap.put("mpe", "video/mpeg");
        this.extensionToMimetypeMap.put("mpeg", "video/mpeg");
        this.extensionToMimetypeMap.put("mpg", "video/mpeg");
        this.extensionToMimetypeMap.put("mpg4", "video/mp4");
        this.extensionToMimetypeMap.put("oga", "audio/ogg");
        this.extensionToMimetypeMap.put("ogg", "audio/ogg");
        this.extensionToMimetypeMap.put("ogv", "video/ogg");
        this.extensionToMimetypeMap.put("ogx", "application/ogg");
        this.extensionToMimetypeMap.put("pbm", "image/x-portable-bitmap");
        this.extensionToMimetypeMap.put("pdf", "application/pdf");
        this.extensionToMimetypeMap.put("pgm", "image/x-portable-graymap");
        this.extensionToMimetypeMap.put("png", "image/png");
        this.extensionToMimetypeMap.put("pnm", "image/x-portable-anymap");
        this.extensionToMimetypeMap.put("ppm", "image/x-portable-pixmap");
        this.extensionToMimetypeMap.put("ppt", "application/vnd.ms-powerpoint");
        this.extensionToMimetypeMap.put("pptx", "application/vnd.openxmlformats-officedocument.presentationml.presentation");
        this.extensionToMimetypeMap.put("ps", "application/postscript");
        this.extensionToMimetypeMap.put("qt", "video/quicktime");
        this.extensionToMimetypeMap.put("rar", "application/x-rar-compressed");
        this.extensionToMimetypeMap.put("ras", "image/x-cmu-raster");
        this.extensionToMimetypeMap.put("rss", "application/rss+xml");
        this.extensionToMimetypeMap.put("rtf", "application/rtf");
        this.extensionToMimetypeMap.put("sgm", "text/sgml");
        this.extensionToMimetypeMap.put("sgml", "text/sgml");
        this.extensionToMimetypeMap.put("svg", "image/svg+xml");
        this.extensionToMimetypeMap.put("swf", "application/x-shockwave-flash");
        this.extensionToMimetypeMap.put("tar", "application/x-tar");
        this.extensionToMimetypeMap.put("tif", "image/tiff");
        this.extensionToMimetypeMap.put("tiff", "image/tiff");
        this.extensionToMimetypeMap.put("torrent", "application/x-bittorrent");
        this.extensionToMimetypeMap.put("ttf", "application/x-font-ttf");
        this.extensionToMimetypeMap.put("wav", "audio/x-wav");
        this.extensionToMimetypeMap.put("webm", "video/webm");
        this.extensionToMimetypeMap.put("wma", "audio/x-ms-wma");
        this.extensionToMimetypeMap.put("wmv", "video/x-ms-wmv");
        this.extensionToMimetypeMap.put("woff", "application/x-font-woff");
        this.extensionToMimetypeMap.put("wsdl", "application/wsdl+xml");
        this.extensionToMimetypeMap.put("xbm", "image/x-xbitmap");
        this.extensionToMimetypeMap.put("xls", "application/vnd.ms-excel");
        this.extensionToMimetypeMap.put("xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        this.extensionToMimetypeMap.put("xml", MIMETYPE_XML);
        this.extensionToMimetypeMap.put("xpm", "image/x-xpixmap");
        this.extensionToMimetypeMap.put("xwd", "image/x-xwindowdump");
        this.extensionToMimetypeMap.put("yaml", "text/yaml");
        this.extensionToMimetypeMap.put("yml", "text/yaml");
        this.extensionToMimetypeMap.put("zip", "application/zip");
    }

    public static Mimetypes getInstance() {
        return MimetypesHolder.mimetypes;
    }

    public void loadAndReplaceMimetypes(InputStream is) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String line = null;
        while ((line = br.readLine()) != null) {
            if ((line = line.trim()).startsWith("#") || line.length() == 0) continue;
            StringTokenizer st = new StringTokenizer(line, " \t");
            if (st.countTokens() > 1) {
                String mimetype = st.nextToken();
                while (st.hasMoreTokens()) {
                    String extension = st.nextToken();
                    this.extensionToMimetypeMap.put(extension, mimetype);
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Setting mime type for extension '" + extension + "' to '" + mimetype + "'");
                }
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("Ignoring mimetype with no associated file extensions: '" + line + "'");
        }
    }

    public String getMimetype(String fileName) {
        int lastPeriodIndex;
        String mimetype = this.extensionToMimetypeMap.get("*");
        if (mimetype == null) {
            mimetype = MIMETYPE_OCTET_STREAM;
        }
        if ((lastPeriodIndex = fileName.lastIndexOf(".")) > 0 && lastPeriodIndex + 1 < fileName.length()) {
            String ext = fileName.substring(lastPeriodIndex + 1);
            if (this.extensionToMimetypeMap.keySet().contains(ext)) {
                mimetype = this.extensionToMimetypeMap.get(ext);
                if (log.isDebugEnabled()) {
                    log.debug("Recognised extension '" + ext + "', mimetype is: '" + mimetype + "'");
                }
                return mimetype;
            }
            if (log.isDebugEnabled()) {
                log.debug("Extension '" + ext + "' is unrecognized in mime type listing" + ", using default mime type: '" + mimetype + "'");
            }
        } else if (log.isDebugEnabled()) {
            log.debug("File name has no extension, mime type cannot be recognised for: " + fileName);
        }
        return mimetype;
    }

    public String getMimetype(File file) {
        return this.getMimetype(file.getName());
    }

    private static class MimetypesHolder {
        private static Mimetypes mimetypes;

        private MimetypesHolder() {
        }

        static {
            block4: {
                mimetypes = new Mimetypes();
                InputStream mimetypesFile = mimetypes.getClass().getResourceAsStream("/mime.types");
                if (mimetypesFile != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("Loading mime types from file in the classpath: mime.types");
                    }
                    try {
                        mimetypes.loadAndReplaceMimetypes(mimetypesFile);
                    }
                    catch (IOException e) {
                        if (!log.isErrorEnabled()) break block4;
                        log.error("Failed to load mime types from file in the classpath: mime.types", e);
                    }
                }
            }
        }
    }
}

