/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.ObsClient;
import com.obs.services.exception.ObsException;
import com.obs.services.internal.ConcurrentProgressManager;
import com.obs.services.internal.DefaultProgressStatus;
import com.obs.services.internal.ProgressManager;
import com.obs.services.internal.ServiceException;
import com.obs.services.internal.io.ProgressInputStream;
import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.model.AbortMultipartUploadRequest;
import com.obs.services.model.CompleteMultipartUploadRequest;
import com.obs.services.model.CompleteMultipartUploadResult;
import com.obs.services.model.DownloadFileRequest;
import com.obs.services.model.DownloadFileResult;
import com.obs.services.model.GetObjectMetadataRequest;
import com.obs.services.model.GetObjectRequest;
import com.obs.services.model.HeaderResponse;
import com.obs.services.model.InitiateMultipartUploadRequest;
import com.obs.services.model.InitiateMultipartUploadResult;
import com.obs.services.model.ObjectMetadata;
import com.obs.services.model.ObsObject;
import com.obs.services.model.PartEtag;
import com.obs.services.model.UploadFileRequest;
import com.obs.services.model.UploadPartRequest;
import com.obs.services.model.UploadPartResult;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class ResumableClient {
    private static final ILogger log = LoggerBuilder.getLogger("com.obs.services.ObsClient");
    private ObsClient obsClient;

    public ResumableClient(ObsClient obsClient) {
        this.obsClient = obsClient;
    }

    public CompleteMultipartUploadResult uploadFileResume(UploadFileRequest uploadFileRequest) {
        ServiceUtils.asserParameterNotNull(uploadFileRequest, "UploadFileRequest is null");
        ServiceUtils.asserParameterNotNull(uploadFileRequest.getBucketName(), "bucketName is null");
        ServiceUtils.asserParameterNotNull2(uploadFileRequest.getObjectKey(), "objectKey is null");
        ServiceUtils.asserParameterNotNull(uploadFileRequest.getUploadFile(), "uploadfile is null");
        if (uploadFileRequest.isEnableCheckpoint() && !ServiceUtils.isValid(uploadFileRequest.getCheckpointFile())) {
            uploadFileRequest.setCheckpointFile(uploadFileRequest.getUploadFile() + ".uploadFile_record");
        }
        try {
            return this.uploadFileCheckPoint(uploadFileRequest);
        }
        catch (ObsException e) {
            throw e;
        }
        catch (ServiceException e) {
            throw ServiceUtils.changeFromServiceException(e);
        }
        catch (Exception e) {
            throw new ObsException(e.getMessage(), e);
        }
    }

    protected void abortMultipartUploadSilent(String uploadId, String bucketName, String objectKey) {
        block2: {
            try {
                AbortMultipartUploadRequest request = new AbortMultipartUploadRequest(bucketName, objectKey, uploadId);
                this.obsClient.abortMultipartUpload(request);
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block2;
                log.warn("Abort multipart upload failed", e);
            }
        }
    }

    protected HeaderResponse abortMultipartUpload(String uploadId, String bucketName, String objectKey) {
        AbortMultipartUploadRequest request = new AbortMultipartUploadRequest(bucketName, objectKey, uploadId);
        return this.obsClient.abortMultipartUpload(request);
    }

    private CompleteMultipartUploadResult uploadFileCheckPoint(UploadFileRequest uploadFileRequest) throws Exception {
        UploadCheckPoint uploadCheckPoint = new UploadCheckPoint();
        if (uploadFileRequest.isEnableCheckpoint()) {
            boolean needRecreate = false;
            try {
                uploadCheckPoint.load(uploadFileRequest.getCheckpointFile());
            }
            catch (Exception e) {
                needRecreate = true;
            }
            if (!needRecreate) {
                if (!(uploadFileRequest.getBucketName().equals(uploadCheckPoint.bucketName) && uploadFileRequest.getObjectKey().equals(uploadCheckPoint.objectKey) && uploadFileRequest.getUploadFile().equals(uploadCheckPoint.uploadFile))) {
                    needRecreate = true;
                } else if (!uploadCheckPoint.isValid(uploadFileRequest.getUploadFile())) {
                    needRecreate = true;
                }
            }
            if (needRecreate) {
                Object uploadCheckFile;
                if (uploadCheckPoint.bucketName != null && uploadCheckPoint.objectKey != null && uploadCheckPoint.uploadID != null) {
                    this.abortMultipartUploadSilent(uploadCheckPoint.uploadID, uploadCheckPoint.bucketName, uploadCheckPoint.objectKey);
                }
                if (((File)(uploadCheckFile = new File(uploadFileRequest.getCheckpointFile()))).exists() && ((File)uploadCheckFile).isFile()) {
                    ((File)uploadCheckFile).delete();
                }
                this.prepare(uploadFileRequest, uploadCheckPoint);
            }
        } else {
            this.prepare(uploadFileRequest, uploadCheckPoint);
        }
        List<PartResult> partResults = this.uploadfile(uploadFileRequest, uploadCheckPoint);
        for (PartResult partResult : partResults) {
            if (!partResult.isFailed() || partResult.getException() == null) continue;
            if (!uploadFileRequest.isEnableCheckpoint()) {
                this.abortMultipartUploadSilent(uploadCheckPoint.uploadID, uploadFileRequest.getBucketName(), uploadFileRequest.getObjectKey());
            } else if (uploadCheckPoint.isAbort) {
                this.abortMultipartUploadSilent(uploadCheckPoint.uploadID, uploadFileRequest.getBucketName(), uploadFileRequest.getObjectKey());
                File uploadCheckFile = new File(uploadFileRequest.getCheckpointFile());
                if (uploadCheckFile.exists() && uploadCheckFile.isFile()) {
                    uploadCheckFile.delete();
                }
            }
            throw partResult.getException();
        }
        CompleteMultipartUploadRequest completeMultipartUploadRequest = new CompleteMultipartUploadRequest(uploadFileRequest.getBucketName(), uploadFileRequest.getObjectKey(), uploadCheckPoint.uploadID, uploadCheckPoint.partEtags);
        try {
            File uploadFileTmp;
            CompleteMultipartUploadResult result = this.obsClient.completeMultipartUpload(completeMultipartUploadRequest);
            if (uploadFileRequest.isEnableCheckpoint() && (uploadFileTmp = new File(uploadFileRequest.getCheckpointFile())).isFile() && uploadFileTmp.exists()) {
                uploadFileTmp.delete();
            }
            return result;
        }
        catch (ObsException e) {
            if (!uploadFileRequest.isEnableCheckpoint()) {
                this.abortMultipartUpload(uploadCheckPoint.uploadID, uploadFileRequest.getBucketName(), uploadFileRequest.getObjectKey());
            } else if (e.getResponseCode() >= 300 && e.getResponseCode() < 500 && e.getResponseCode() != 408) {
                this.abortMultipartUploadSilent(uploadCheckPoint.uploadID, uploadFileRequest.getBucketName(), uploadFileRequest.getObjectKey());
                File uploadCheckFile = new File(uploadFileRequest.getCheckpointFile());
                if (uploadCheckFile.exists() && uploadCheckFile.isFile()) {
                    uploadCheckFile.delete();
                }
            }
            throw e;
        }
    }

    private List<PartResult> uploadfile(UploadFileRequest uploadFileRequest, UploadCheckPoint uploadCheckPoint) throws Exception {
        ArrayList<PartResult> pieceResults = new ArrayList<PartResult>();
        ExecutorService executorService = Executors.newFixedThreadPool(uploadFileRequest.getTaskNum());
        ArrayList<Future<PartResult>> futures = new ArrayList<Future<PartResult>>();
        ProgressManager progressManager = null;
        if (uploadFileRequest.getProgressListener() == null) {
            for (int i = 0; i < uploadCheckPoint.uploadParts.size(); ++i) {
                UploadPart uploadPart = uploadCheckPoint.uploadParts.get(i);
                if (uploadPart.isCompleted) {
                    PartResult pr = new PartResult(uploadPart.partNumber, uploadPart.offset, uploadPart.size);
                    pr.setFailed(false);
                    pieceResults.add(pr);
                    continue;
                }
                futures.add(executorService.submit(new Mission(i, uploadCheckPoint, i, uploadFileRequest, this.obsClient)));
            }
        } else {
            long transferredBytes = 0L;
            LinkedList<Mission> unfinishedUploadMissions = new LinkedList<Mission>();
            for (int i = 0; i < uploadCheckPoint.uploadParts.size(); ++i) {
                UploadPart uploadPart = uploadCheckPoint.uploadParts.get(i);
                if (uploadPart.isCompleted) {
                    PartResult pr = new PartResult(uploadPart.partNumber, uploadPart.offset, uploadPart.size);
                    pr.setFailed(false);
                    pieceResults.add(pr);
                    transferredBytes += uploadPart.size;
                    continue;
                }
                unfinishedUploadMissions.add(new Mission(i, uploadCheckPoint, i, uploadFileRequest, this.obsClient));
            }
            progressManager = new ConcurrentProgressManager(uploadCheckPoint.uploadFileStatus.size, transferredBytes, uploadFileRequest.getProgressListener(), uploadFileRequest.getProgressInterval() > 0L ? uploadFileRequest.getProgressInterval() : 102400L);
            for (Mission mission : unfinishedUploadMissions) {
                mission.setProgressManager(progressManager);
                futures.add(executorService.submit(mission));
            }
        }
        executorService.shutdown();
        executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        for (Future future : futures) {
            try {
                PartResult tr = (PartResult)future.get();
                pieceResults.add(tr);
            }
            catch (ExecutionException e) {
                if (!uploadFileRequest.isEnableCheckpoint()) {
                    this.abortMultipartUploadSilent(uploadCheckPoint.uploadID, uploadFileRequest.getBucketName(), uploadFileRequest.getObjectKey());
                }
                throw e;
            }
        }
        if (progressManager != null) {
            progressManager.progressEnd();
        }
        return pieceResults;
    }

    private void prepare(UploadFileRequest uploadFileRequest, UploadCheckPoint uploadCheckPoint) throws Exception {
        uploadCheckPoint.uploadFile = uploadFileRequest.getUploadFile();
        uploadCheckPoint.bucketName = uploadFileRequest.getBucketName();
        uploadCheckPoint.objectKey = uploadFileRequest.getObjectKey();
        uploadCheckPoint.uploadFileStatus = FileStatus.getFileStatus(uploadCheckPoint.uploadFile, uploadFileRequest.isEnableCheckSum());
        uploadCheckPoint.uploadParts = this.splitUploadFile(uploadCheckPoint.uploadFileStatus.size, uploadFileRequest.getPartSize());
        uploadCheckPoint.partEtags = new ArrayList();
        InitiateMultipartUploadRequest initiateUploadRequest = new InitiateMultipartUploadRequest(uploadFileRequest.getBucketName(), uploadFileRequest.getObjectKey());
        InitiateMultipartUploadResult initiateUploadResult = this.obsClient.initiateMultipartUpload(initiateUploadRequest);
        uploadCheckPoint.uploadID = initiateUploadResult.getUploadId();
        if (uploadFileRequest.isEnableCheckpoint()) {
            try {
                uploadCheckPoint.record(uploadFileRequest.getCheckpointFile());
            }
            catch (Exception e) {
                this.abortMultipartUploadSilent(uploadCheckPoint.uploadID, uploadCheckPoint.bucketName, uploadCheckPoint.objectKey);
                throw e;
            }
        }
    }

    private ArrayList<UploadPart> splitUploadFile(long size, long partSize) {
        ArrayList<UploadPart> parts = new ArrayList<UploadPart>();
        long partNum = size / partSize;
        if (partNum >= 10000L) {
            partSize = size % 10000L == 0L ? size / 10000L : size / 10000L + 1L;
            partNum = size / partSize;
        }
        if (size % partSize > 0L) {
            ++partNum;
        }
        if (partNum == 0L) {
            UploadPart part = new UploadPart();
            part.partNumber = 1;
            part.offset = 0L;
            part.size = 0L;
            part.isCompleted = false;
            parts.add(part);
        } else {
            for (long i = 0L; i < partNum; ++i) {
                UploadPart part = new UploadPart();
                part.partNumber = (int)(i + 1L);
                part.offset = i * partSize;
                part.size = partSize;
                part.isCompleted = false;
                parts.add(part);
            }
            if (size % partSize > 0L) {
                parts.get((int)(parts.size() - 1)).size = size % partSize;
            }
        }
        return parts;
    }

    public DownloadFileResult downloadFileResume(DownloadFileRequest downloadFileRequest) {
        ServiceUtils.asserParameterNotNull(downloadFileRequest, "DownloadFileRequest is null");
        ServiceUtils.asserParameterNotNull(downloadFileRequest.getBucketName(), "the bucketName is null");
        String key = downloadFileRequest.getObjectKey();
        ServiceUtils.asserParameterNotNull2(key, "the objectKey is null");
        if (downloadFileRequest.getDownloadFile() == null) {
            downloadFileRequest.setDownloadFile(key);
        }
        if (downloadFileRequest.isEnableCheckpoint() && (downloadFileRequest.getCheckpointFile() == null || downloadFileRequest.getCheckpointFile().isEmpty())) {
            downloadFileRequest.setCheckpointFile(downloadFileRequest.getDownloadFile() + ".downloadFile_record");
        }
        try {
            return this.downloadCheckPoint(downloadFileRequest);
        }
        catch (ObsException e) {
            throw e;
        }
        catch (ServiceException e) {
            throw ServiceUtils.changeFromServiceException(e);
        }
        catch (Exception e) {
            throw new ObsException(e.getMessage(), e);
        }
    }

    private DownloadFileResult downloadCheckPoint(DownloadFileRequest downloadFileRequest) throws Exception {
        Object file;
        ObjectMetadata objectMetadata;
        DownloadFileResult downloadFileResult = new DownloadFileResult();
        try {
            GetObjectMetadataRequest request = new GetObjectMetadataRequest(downloadFileRequest.getBucketName(), downloadFileRequest.getObjectKey(), downloadFileRequest.getVersionId());
            objectMetadata = this.obsClient.getObjectMetadata(request);
        }
        catch (ObsException e) {
            if (e.getResponseCode() >= 300 && e.getResponseCode() < 500 && e.getResponseCode() != 408) {
                File file2;
                File tmpfile = new File(downloadFileRequest.getTempDownloadFile());
                if (tmpfile.exists() && tmpfile.isFile()) {
                    tmpfile.delete();
                }
                if ((file2 = new File(downloadFileRequest.getCheckpointFile())).isFile() && file2.exists()) {
                    file2.delete();
                }
            }
            throw e;
        }
        downloadFileResult.setObjectMetadata(objectMetadata);
        if (objectMetadata.getContentLength() == 0L) {
            File file3;
            File tmpfile = new File(downloadFileRequest.getTempDownloadFile());
            if (tmpfile.exists() && tmpfile.isFile()) {
                tmpfile.delete();
            }
            if ((file3 = new File(downloadFileRequest.getCheckpointFile())).isFile() && file3.exists()) {
                file3.delete();
            }
            File dfile = new File(downloadFileRequest.getDownloadFile());
            dfile.getParentFile().mkdirs();
            new RandomAccessFile(dfile, "rw").close();
            if (downloadFileRequest.getProgressListener() != null) {
                downloadFileRequest.getProgressListener().progressChanged(new DefaultProgressStatus(0L, 0L, 0L, 0L, 0L));
            }
            return downloadFileResult;
        }
        DownloadCheckPoint downloadCheckPoint = new DownloadCheckPoint();
        if (downloadFileRequest.isEnableCheckpoint()) {
            boolean needRecreate = false;
            try {
                downloadCheckPoint.load(downloadFileRequest.getCheckpointFile());
            }
            catch (Exception e) {
                needRecreate = true;
            }
            if (!needRecreate) {
                if (!(downloadFileRequest.getBucketName().equals(downloadCheckPoint.bucketName) && downloadFileRequest.getObjectKey().equals(downloadCheckPoint.objectKey) && downloadFileRequest.getDownloadFile().equals(downloadCheckPoint.downloadFile))) {
                    needRecreate = true;
                } else if (!downloadCheckPoint.isValid(downloadFileRequest.getTempDownloadFile(), objectMetadata)) {
                    needRecreate = true;
                } else if (downloadFileRequest.getVersionId() == null) {
                    if (downloadCheckPoint.versionId != null) {
                        needRecreate = true;
                    }
                } else if (!downloadFileRequest.getVersionId().equals(downloadCheckPoint.versionId)) {
                    needRecreate = true;
                }
            }
            if (needRecreate) {
                File tmpfile;
                if (downloadCheckPoint.tmpFileStatus != null && (tmpfile = new File(downloadCheckPoint.tmpFileStatus.tmpFilePath)).exists() && tmpfile.isFile()) {
                    tmpfile.delete();
                }
                if (((File)(file = new File(downloadFileRequest.getCheckpointFile()))).isFile() && ((File)file).exists()) {
                    ((File)file).delete();
                }
                this.prepare(downloadFileRequest, downloadCheckPoint, objectMetadata);
            }
        } else {
            this.prepare(downloadFileRequest, downloadCheckPoint, objectMetadata);
        }
        DownloadResult downloadResult = this.download(downloadCheckPoint, downloadFileRequest);
        file = downloadResult.getPartResults().iterator();
        while (file.hasNext()) {
            PartResultDown partResult = file.next();
            if (!partResult.isFailed() || partResult.getException() == null) continue;
            if (!downloadFileRequest.isEnableCheckpoint()) {
                File tmpfile = new File(downloadCheckPoint.tmpFileStatus.tmpFilePath);
                if (tmpfile.exists() && tmpfile.isFile()) {
                    tmpfile.delete();
                }
            } else if (downloadCheckPoint.isAbort) {
                File file4;
                File tmpfile = new File(downloadCheckPoint.tmpFileStatus.tmpFilePath);
                if (tmpfile.exists() && tmpfile.isFile()) {
                    tmpfile.delete();
                }
                if ((file4 = new File(downloadFileRequest.getCheckpointFile())).isFile() && file4.exists()) {
                    file4.delete();
                }
            }
            throw partResult.getException();
        }
        this.renameTo(downloadFileRequest.getTempDownloadFile(), downloadFileRequest.getDownloadFile());
        if (downloadFileRequest.isEnableCheckpoint() && ((File)(file = new File(downloadFileRequest.getCheckpointFile()))).isFile() && ((File)file).exists()) {
            ((File)file).delete();
        }
        return downloadFileResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renameTo(String tempDownloadFilePath, String downloadFilePath) throws IOException {
        block7: {
            File tmpfile = new File(tempDownloadFilePath);
            File downloadFile = new File(downloadFilePath);
            if (!tmpfile.exists()) {
                throw new FileNotFoundException("tmpFile '" + tmpfile + "' does not exist");
            }
            if (downloadFile.exists() && !downloadFile.delete()) {
                throw new IOException("downloadFile '" + downloadFile + "' is exist");
            }
            if (tmpfile.isDirectory() || downloadFile.isDirectory()) {
                throw new IOException("downloadPath is a directory");
            }
            boolean renameFlag = tmpfile.renameTo(downloadFile);
            if (renameFlag) break block7;
            FileInputStream input = null;
            FileOutputStream output = null;
            try {
                int length;
                input = new FileInputStream(tmpfile);
                output = new FileOutputStream(downloadFile);
                byte[] buffer = new byte[8192];
                while ((length = ((InputStream)input).read(buffer)) > 0) {
                    ((OutputStream)output).write(buffer, 0, length);
                }
            }
            catch (Throwable throwable) {
                ServiceUtils.closeStream(input);
                ServiceUtils.closeStream(output);
                throw throwable;
            }
            ServiceUtils.closeStream(input);
            ServiceUtils.closeStream(output);
            if (!tmpfile.delete()) {
                throw new IOException("the tmpfile '" + tmpfile + "' can not delete, please delete it to ensure the download finish.");
            }
        }
    }

    private DownloadResult download(DownloadCheckPoint downloadCheckPoint, DownloadFileRequest downloadFileRequest) throws Exception {
        ArrayList<PartResultDown> taskResults = new ArrayList<PartResultDown>();
        DownloadResult downloadResult = new DownloadResult();
        ExecutorService service = Executors.newFixedThreadPool(downloadFileRequest.getTaskNum());
        ArrayList<Future<PartResultDown>> futures = new ArrayList<Future<PartResultDown>>();
        ProgressManager progressManager = null;
        if (downloadFileRequest.getProgressListener() == null) {
            for (int i = 0; i < downloadCheckPoint.downloadParts.size(); ++i) {
                DownloadPart downloadPart = downloadCheckPoint.downloadParts.get(i);
                if (!downloadPart.isCompleted) {
                    Task task = new Task(i, "download-" + i, downloadCheckPoint, i, downloadFileRequest, this.obsClient);
                    futures.add(service.submit(task));
                    continue;
                }
                taskResults.add(new PartResultDown(i + 1, downloadPart.offset, downloadPart.end));
            }
        } else {
            LinkedList<Task> unfinishedTasks = new LinkedList<Task>();
            long l = 0L;
            for (int i = 0; i < downloadCheckPoint.downloadParts.size(); ++i) {
                DownloadPart downloadPart = downloadCheckPoint.downloadParts.get(i);
                if (!downloadPart.isCompleted) {
                    Task task = new Task(i, "download-" + i, downloadCheckPoint, i, downloadFileRequest, this.obsClient);
                    unfinishedTasks.add(task);
                    continue;
                }
                l += downloadPart.end - downloadPart.offset + 1L;
                taskResults.add(new PartResultDown(i + 1, downloadPart.offset, downloadPart.end));
            }
            progressManager = new ConcurrentProgressManager(downloadCheckPoint.objectStatus.size, l, downloadFileRequest.getProgressListener(), downloadFileRequest.getProgressInterval() > 0L ? downloadFileRequest.getProgressInterval() : 102400L);
            for (Task task : unfinishedTasks) {
                task.setProgressManager(progressManager);
                futures.add(service.submit(task));
            }
        }
        service.shutdown();
        service.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        for (Future future : futures) {
            PartResultDown tr = (PartResultDown)future.get();
            taskResults.add(tr);
        }
        downloadResult.setPartResults(taskResults);
        if (progressManager != null) {
            progressManager.progressEnd();
        }
        return downloadResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepare(DownloadFileRequest downloadFileRequest, DownloadCheckPoint downloadCheckPoint, ObjectMetadata objectMetadata) throws Exception {
        downloadCheckPoint.bucketName = downloadFileRequest.getBucketName();
        downloadCheckPoint.objectKey = downloadFileRequest.getObjectKey();
        downloadCheckPoint.versionId = downloadFileRequest.getVersionId();
        downloadCheckPoint.downloadFile = downloadFileRequest.getDownloadFile();
        ObjectStatus objStatus = new ObjectStatus();
        objStatus.size = objectMetadata.getContentLength();
        objStatus.lastModified = objectMetadata.getLastModified();
        objStatus.Etag = objectMetadata.getEtag();
        downloadCheckPoint.objectStatus = objStatus;
        downloadCheckPoint.downloadParts = this.splitObject(downloadCheckPoint.objectStatus.size, downloadFileRequest.getPartSize());
        File tmpfile = new File(downloadFileRequest.getTempDownloadFile());
        tmpfile.getParentFile().mkdirs();
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(tmpfile, "rw");
            randomAccessFile.setLength(downloadCheckPoint.objectStatus.size);
        }
        catch (Throwable throwable) {
            ServiceUtils.closeStream(randomAccessFile);
            throw throwable;
        }
        ServiceUtils.closeStream(randomAccessFile);
        downloadCheckPoint.tmpFileStatus = new TmpFileStatus(downloadCheckPoint.objectStatus.size, new Date(tmpfile.lastModified()), downloadFileRequest.getTempDownloadFile());
        if (downloadFileRequest.isEnableCheckpoint()) {
            try {
                downloadCheckPoint.record(downloadFileRequest.getCheckpointFile());
            }
            catch (Exception e) {
                if (tmpfile.exists() && tmpfile.isFile()) {
                    tmpfile.delete();
                }
                throw e;
            }
        }
    }

    private ArrayList<DownloadPart> splitObject(long size, long partSize) {
        ArrayList<DownloadPart> parts = new ArrayList<DownloadPart>();
        long piece = size / partSize;
        if (piece >= 10000L) {
            partSize = size % 10000L == 0L ? size / 10000L : size / 10000L + 1L;
        }
        long offset = 0L;
        int i = 0;
        while (offset < size) {
            DownloadPart downloadPart = new DownloadPart();
            downloadPart.partNumber = i;
            downloadPart.offset = offset;
            downloadPart.end = offset + partSize > size ? size - 1L : offset + partSize - 1L;
            parts.add(downloadPart);
            offset += partSize;
            ++i;
        }
        return parts;
    }

    static class DownloadResult {
        private List<PartResultDown> partResults;

        DownloadResult() {
        }

        public List<PartResultDown> getPartResults() {
            return this.partResults;
        }

        public void setPartResults(List<PartResultDown> partResults) {
            this.partResults = partResults;
        }
    }

    static class PartResultDown {
        private int partNumber;
        private long start;
        private long end;
        private boolean isFailed;
        private Exception exception;

        public PartResultDown(int partNumber, long start, long end) {
            this.partNumber = partNumber;
            this.start = start;
            this.end = end;
        }

        public long getStart() {
            return this.start;
        }

        public void setStart(long start) {
            this.start = start;
        }

        public long getEnd() {
            return this.end;
        }

        public void setEnd(long end) {
            this.end = end;
        }

        public int getpartNumber() {
            return this.partNumber;
        }

        public boolean isFailed() {
            return this.isFailed;
        }

        public void setFailed(boolean failed) {
            this.isFailed = failed;
        }

        public Exception getException() {
            return this.exception;
        }

        public void setException(Exception exception) {
            this.exception = exception;
        }
    }

    static class DownloadPart
    implements Serializable {
        private static final long serialVersionUID = 961987949814206093L;
        public int partNumber;
        public long offset;
        public long end;
        public boolean isCompleted;

        DownloadPart() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.partNumber;
            result = 31 * result + (this.isCompleted ? 0 : 8);
            result = 31 * result + (int)(this.end ^ this.end >>> 32);
            result = 31 * result + (int)(this.offset ^ this.offset >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            DownloadPart downloadPart;
            if (obj == null) {
                return false;
            }
            return obj instanceof DownloadPart && (downloadPart = (DownloadPart)obj).hashCode() == this.hashCode();
        }
    }

    static class TmpFileStatus
    implements Serializable {
        private static final long serialVersionUID = 4478330948103112660L;
        public long size;
        public Date lastModified;
        public String tmpFilePath;

        public TmpFileStatus(long size, Date lastMoidified, String tmpFilePath) {
            this.size = size;
            this.lastModified = lastMoidified;
            this.tmpFilePath = tmpFilePath;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.lastModified == null ? 0 : this.lastModified.hashCode());
            result = 31 * result + (this.tmpFilePath == null ? 0 : this.tmpFilePath.hashCode());
            result = 31 * result + (int)(this.size ^ this.size >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            TmpFileStatus tmpFileStatus;
            if (obj == null) {
                return false;
            }
            return obj instanceof TmpFileStatus && (tmpFileStatus = (TmpFileStatus)obj).hashCode() == this.hashCode();
        }
    }

    static class ObjectStatus
    implements Serializable {
        private static final long serialVersionUID = -6267040832855296342L;
        public long size;
        public Date lastModified;
        public String Etag;

        ObjectStatus() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.Etag == null ? 0 : this.Etag.hashCode());
            result = 31 * result + (this.lastModified == null ? 0 : this.lastModified.hashCode());
            result = 31 * result + (int)(this.size ^ this.size >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            ObjectStatus objectStatus;
            if (obj == null) {
                return false;
            }
            return obj instanceof ObjectStatus && (objectStatus = (ObjectStatus)obj).hashCode() == this.hashCode();
        }
    }

    static class DownloadCheckPoint
    implements Serializable {
        private static final long serialVersionUID = 2282950186694419179L;
        public int md5;
        public String bucketName;
        public String objectKey;
        public String versionId;
        public String downloadFile;
        public ObjectStatus objectStatus;
        public TmpFileStatus tmpFileStatus;
        ArrayList<DownloadPart> downloadParts;
        public volatile transient boolean isAbort = false;

        DownloadCheckPoint() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.bucketName == null ? 0 : this.bucketName.hashCode());
            result = 31 * result + (this.downloadFile == null ? 0 : this.downloadFile.hashCode());
            result = 31 * result + (this.versionId == null ? 0 : this.versionId.hashCode());
            result = 31 * result + (this.objectKey == null ? 0 : this.objectKey.hashCode());
            result = 31 * result + (this.objectStatus == null ? 0 : this.objectStatus.hashCode());
            result = 31 * result + (this.tmpFileStatus == null ? 0 : this.tmpFileStatus.hashCode());
            result = 31 * result + (this.downloadParts == null ? 0 : this.downloadParts.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            DownloadCheckPoint downloadCheckPoint;
            if (obj == null) {
                return false;
            }
            return obj instanceof DownloadCheckPoint && (downloadCheckPoint = (DownloadCheckPoint)obj).hashCode() == this.hashCode();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void load(String checkPointFile) throws Exception {
            FileInputStream fileIn = null;
            ObjectInputStream in = null;
            try {
                fileIn = new FileInputStream(checkPointFile);
                in = new ObjectInputStream(fileIn);
                DownloadCheckPoint info = (DownloadCheckPoint)in.readObject();
                this.assign(info);
            }
            catch (Throwable throwable) {
                ServiceUtils.closeStream(in);
                ServiceUtils.closeStream(fileIn);
                throw throwable;
            }
            ServiceUtils.closeStream(in);
            ServiceUtils.closeStream(fileIn);
        }

        private void assign(DownloadCheckPoint info) {
            this.md5 = info.md5;
            this.downloadFile = info.downloadFile;
            this.bucketName = info.bucketName;
            this.objectKey = info.objectKey;
            this.versionId = info.versionId;
            this.objectStatus = info.objectStatus;
            this.tmpFileStatus = info.tmpFileStatus;
            this.downloadParts = info.downloadParts;
        }

        public boolean isValid(String tmpFilePath, ObjectMetadata objectMetadata) {
            if (this.md5 != this.hashCode()) {
                return false;
            }
            if (objectMetadata.getContentLength() != this.objectStatus.size || !objectMetadata.getLastModified().equals(this.objectStatus.lastModified) || !objectMetadata.getEtag().equals(this.objectStatus.Etag)) {
                return false;
            }
            File tmpfile = new File(tmpFilePath);
            return this.tmpFileStatus.size == tmpfile.length();
        }

        public synchronized void update(int index, boolean completed, String tmpFilePath) throws IOException {
            this.downloadParts.get((int)index).isCompleted = completed;
            File tmpfile = new File(tmpFilePath);
            this.tmpFileStatus.lastModified = new Date(tmpfile.lastModified());
        }

        public synchronized void updateTmpFile(String tmpFilePath) throws IOException {
            File tmpfile = new File(tmpFilePath);
            this.tmpFileStatus.lastModified = new Date(tmpfile.lastModified());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void record(String checkPointFilePath) throws IOException {
            FileOutputStream fileOutStream = null;
            ObjectOutputStream objOutStream = null;
            this.md5 = this.hashCode();
            try {
                fileOutStream = new FileOutputStream(checkPointFilePath);
                objOutStream = new ObjectOutputStream(fileOutStream);
                objOutStream.writeObject(this);
            }
            finally {
                if (objOutStream != null) {
                    try {
                        objOutStream.close();
                    }
                    catch (Exception exception) {}
                }
                if (fileOutStream != null) {
                    try {
                        fileOutStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    static class Task
    implements Callable<PartResultDown> {
        private int id;
        private String name;
        private DownloadCheckPoint downloadCheckPoint;
        private int partIndex;
        private DownloadFileRequest downloadFileRequest;
        private ObsClient obsClient;
        private ProgressManager progressManager;

        public Task(int id, String name, DownloadCheckPoint downloadCheckPoint, int partIndex, DownloadFileRequest downloadFileRequest, ObsClient obsClient) {
            this.id = id;
            this.name = name;
            this.downloadCheckPoint = downloadCheckPoint;
            this.partIndex = partIndex;
            this.downloadFileRequest = downloadFileRequest;
            this.obsClient = obsClient;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public PartResultDown call() throws Exception {
            RandomAccessFile output = null;
            InputStream content = null;
            DownloadPart downloadPart = this.downloadCheckPoint.downloadParts.get(this.partIndex);
            PartResultDown tr = new PartResultDown(this.partIndex + 1, downloadPart.offset, downloadPart.end);
            if (!this.downloadCheckPoint.isAbort) {
                try {
                    int bytesOffset;
                    output = new RandomAccessFile(this.downloadFileRequest.getTempDownloadFile(), "rw");
                    output.seek(downloadPart.offset);
                    GetObjectRequest getObjectRequest = new GetObjectRequest(this.downloadFileRequest.getBucketName(), this.downloadFileRequest.getObjectKey());
                    getObjectRequest.setIfMatchTag(this.downloadFileRequest.getIfMatchTag());
                    getObjectRequest.setIfNoneMatchTag(this.downloadFileRequest.getIfNoneMatchTag());
                    getObjectRequest.setIfModifiedSince(this.downloadFileRequest.getIfModifiedSince());
                    getObjectRequest.setIfUnmodifiedSince(this.downloadFileRequest.getIfUnmodifiedSince());
                    getObjectRequest.setRangeStart(downloadPart.offset);
                    getObjectRequest.setRangeEnd(downloadPart.end);
                    getObjectRequest.setVersionId(this.downloadFileRequest.getVersionId());
                    ObsObject object = this.obsClient.getObject(getObjectRequest);
                    content = object.getObjectContent();
                    if (this.progressManager != null) {
                        content = new ProgressInputStream(content, this.progressManager, false);
                    }
                    byte[] buffer = new byte[4096];
                    while ((bytesOffset = content.read(buffer)) != -1) {
                        output.write(buffer, 0, bytesOffset);
                    }
                    this.downloadCheckPoint.update(this.partIndex, true, this.downloadFileRequest.getTempDownloadFile());
                }
                catch (ObsException e) {
                    block10: {
                        if (e.getResponseCode() >= 300 && e.getResponseCode() < 500 && e.getResponseCode() != 408) {
                            this.downloadCheckPoint.isAbort = true;
                        }
                        tr.setFailed(true);
                        tr.setException(e);
                        if (!log.isErrorEnabled()) break block10;
                        log.error(String.format("Task %d:%s download part %d failed: ", this.id, this.name, this.partIndex), e);
                    }
                    ServiceUtils.closeStream(output);
                    ServiceUtils.closeStream(content);
                    if (!this.downloadFileRequest.isEnableCheckpoint()) return tr;
                    this.downloadCheckPoint.updateTmpFile(this.downloadFileRequest.getTempDownloadFile());
                    this.downloadCheckPoint.record(this.downloadFileRequest.getCheckpointFile());
                    return tr;
                }
                catch (Exception e2) {
                    block11: {
                        tr.setFailed(true);
                        tr.setException(e2);
                        if (!log.isErrorEnabled()) break block11;
                        log.error(String.format("Task %d:%s download part %d failed: ", this.id, this.name, this.partIndex), e2);
                        {
                            catch (Throwable throwable) {
                                ServiceUtils.closeStream(output);
                                ServiceUtils.closeStream(content);
                                if (!this.downloadFileRequest.isEnableCheckpoint()) throw throwable;
                                this.downloadCheckPoint.updateTmpFile(this.downloadFileRequest.getTempDownloadFile());
                                this.downloadCheckPoint.record(this.downloadFileRequest.getCheckpointFile());
                                throw throwable;
                            }
                        }
                    }
                    ServiceUtils.closeStream(output);
                    ServiceUtils.closeStream(content);
                    if (!this.downloadFileRequest.isEnableCheckpoint()) return tr;
                    this.downloadCheckPoint.updateTmpFile(this.downloadFileRequest.getTempDownloadFile());
                    this.downloadCheckPoint.record(this.downloadFileRequest.getCheckpointFile());
                    return tr;
                }
                ServiceUtils.closeStream(output);
                ServiceUtils.closeStream(content);
                if (!this.downloadFileRequest.isEnableCheckpoint()) return tr;
                this.downloadCheckPoint.updateTmpFile(this.downloadFileRequest.getTempDownloadFile());
                this.downloadCheckPoint.record(this.downloadFileRequest.getCheckpointFile());
                return tr;
            }
            tr.setFailed(true);
            return tr;
        }

        public void setProgressManager(ProgressManager progressManager) {
            this.progressManager = progressManager;
        }
    }

    static class PartResult {
        private int partNumber;
        private long offset;
        private long length;
        private boolean isfailed;
        private Exception exception;

        public PartResult(int partNumber, long offset, long length) {
            this.partNumber = partNumber;
            this.offset = offset;
            this.length = length;
        }

        public int getpartNumber() {
            return this.partNumber;
        }

        public void setpartNumber(int partNumber) {
            this.partNumber = partNumber;
        }

        public long getOffset() {
            return this.offset;
        }

        public void setOffset(long offset) {
            this.offset = offset;
        }

        public long getLength() {
            return this.length;
        }

        public void setLength(long length) {
            this.length = length;
        }

        public boolean isFailed() {
            return this.isfailed;
        }

        public void setFailed(boolean isfailed) {
            this.isfailed = isfailed;
        }

        public Exception getException() {
            return this.exception;
        }

        public void setException(Exception exception) {
            this.exception = exception;
        }
    }

    static class UploadPart
    implements Serializable {
        private static final long serialVersionUID = 751520598820222785L;
        public int partNumber;
        public long offset;
        public long size;
        public boolean isCompleted;

        UploadPart() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.isCompleted ? 1 : 0);
            result = 31 * result + this.partNumber;
            result = 31 * result + (int)(this.offset ^ this.offset >>> 32);
            result = 31 * result + (int)(this.size ^ this.size >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            UploadPart uploadPart;
            if (obj == null) {
                return false;
            }
            return obj instanceof UploadPart && (uploadPart = (UploadPart)obj).hashCode() == obj.hashCode();
        }
    }

    static class FileStatus
    implements Serializable {
        private static final long serialVersionUID = -3135754191745936521L;
        public long size;
        public long lastModified;
        public String checkSum;

        FileStatus() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.checkSum == null ? 0 : this.checkSum.hashCode());
            result = 31 * result + (int)(this.lastModified ^ this.lastModified >>> 32);
            result = 31 * result + (int)(this.size ^ this.size >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            FileStatus fileStatus;
            if (obj == null) {
                return false;
            }
            return obj instanceof FileStatus && (fileStatus = (FileStatus)obj).hashCode() == obj.hashCode();
        }

        public static FileStatus getFileStatus(String uploadFile, boolean checkSum) throws IOException {
            FileStatus fileStatus = new FileStatus();
            File file = new File(uploadFile);
            fileStatus.size = file.length();
            fileStatus.lastModified = file.lastModified();
            if (checkSum) {
                try {
                    fileStatus.checkSum = ServiceUtils.toBase64(ServiceUtils.computeMD5Hash(new FileInputStream(file)));
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            return fileStatus;
        }
    }

    static class UploadCheckPoint
    implements Serializable {
        private static final long serialVersionUID = 5564757792864743464L;
        public int md5;
        public String uploadFile;
        public FileStatus uploadFileStatus;
        public String bucketName;
        public String objectKey;
        public String uploadID;
        public ArrayList<UploadPart> uploadParts;
        public ArrayList<PartEtag> partEtags;
        public volatile transient boolean isAbort = false;

        UploadCheckPoint() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void load(String checkPointFile) throws Exception {
            FileInputStream fileInput = null;
            ObjectInputStream in = null;
            try {
                fileInput = new FileInputStream(checkPointFile);
                in = new ObjectInputStream(fileInput);
                UploadCheckPoint tmp = (UploadCheckPoint)in.readObject();
                this.assign(tmp);
            }
            catch (Throwable throwable) {
                ServiceUtils.closeStream(in);
                ServiceUtils.closeStream(fileInput);
                throw throwable;
            }
            ServiceUtils.closeStream(in);
            ServiceUtils.closeStream(fileInput);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void record(String checkPointFile) throws IOException {
            this.md5 = this.hashCode();
            FileOutputStream fileOutput = null;
            ObjectOutputStream outStream = null;
            try {
                fileOutput = new FileOutputStream(checkPointFile);
                outStream = new ObjectOutputStream(fileOutput);
                outStream.writeObject(this);
            }
            catch (Throwable throwable) {
                ServiceUtils.closeStream(outStream);
                ServiceUtils.closeStream(fileOutput);
                throw throwable;
            }
            ServiceUtils.closeStream(outStream);
            ServiceUtils.closeStream(fileOutput);
        }

        public synchronized void update(int partIndex, PartEtag partETag, boolean completed) {
            this.partEtags.add(partETag);
            this.uploadParts.get((int)partIndex).isCompleted = completed;
        }

        public boolean isValid(String uploadFile) throws IOException {
            if (this.md5 != this.hashCode()) {
                return false;
            }
            File upload = new File(uploadFile);
            if (!this.uploadFile.equals(uploadFile) || this.uploadFileStatus.size != upload.length() || this.uploadFileStatus.lastModified != upload.lastModified()) {
                return false;
            }
            if (this.uploadFileStatus.checkSum != null) {
                try {
                    return this.uploadFileStatus.checkSum.equals(ServiceUtils.toBase64(ServiceUtils.computeMD5Hash(new FileInputStream(upload))));
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            return true;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.objectKey == null ? 0 : this.objectKey.hashCode());
            result = 31 * result + (this.bucketName == null ? 0 : this.bucketName.hashCode());
            result = 31 * result + (this.partEtags == null ? 0 : this.partEtags.hashCode());
            result = 31 * result + (this.uploadFile == null ? 0 : this.uploadFile.hashCode());
            result = 31 * result + (this.uploadFileStatus == null ? 0 : this.uploadFileStatus.hashCode());
            result = 31 * result + (this.uploadID == null ? 0 : this.uploadID.hashCode());
            result = 31 * result + (this.uploadParts == null ? 0 : this.uploadParts.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            UploadCheckPoint uploadCheckPoint;
            if (obj == null) {
                return false;
            }
            return obj instanceof UploadCheckPoint && (uploadCheckPoint = (UploadCheckPoint)obj).hashCode() == obj.hashCode();
        }

        private void assign(UploadCheckPoint tmp) {
            this.md5 = tmp.md5;
            this.bucketName = tmp.bucketName;
            this.uploadFile = tmp.uploadFile;
            this.uploadFileStatus = tmp.uploadFileStatus;
            this.objectKey = tmp.objectKey;
            this.uploadID = tmp.uploadID;
            this.uploadParts = tmp.uploadParts;
            this.partEtags = tmp.partEtags;
        }
    }

    static class Mission
    implements Callable<PartResult> {
        private int id;
        private UploadCheckPoint uploadCheckPoint;
        private int partIndex;
        private UploadFileRequest uploadFileRequest;
        private ObsClient obsClient;
        private ProgressManager progressManager;

        public Mission(int id, UploadCheckPoint uploadCheckPoint, int partIndex, UploadFileRequest uploadFileRequest, ObsClient obsClient) {
            this.id = id;
            this.uploadCheckPoint = uploadCheckPoint;
            this.partIndex = partIndex;
            this.uploadFileRequest = uploadFileRequest;
            this.obsClient = obsClient;
        }

        @Override
        public PartResult call() throws Exception {
            PartResult tr;
            block10: {
                tr = null;
                UploadPart uploadPart = this.uploadCheckPoint.uploadParts.get(this.partIndex);
                tr = new PartResult(this.partIndex + 1, uploadPart.offset, uploadPart.size);
                if (!this.uploadCheckPoint.isAbort) {
                    try {
                        UploadPartRequest uploadPartRequest = new UploadPartRequest();
                        uploadPartRequest.setBucketName(this.uploadFileRequest.getBucketName());
                        uploadPartRequest.setObjectKey(this.uploadFileRequest.getObjectKey());
                        uploadPartRequest.setUploadId(this.uploadCheckPoint.uploadID);
                        uploadPartRequest.setPartSize(uploadPart.size);
                        uploadPartRequest.setPartNumber(uploadPart.partNumber);
                        if (this.progressManager == null) {
                            uploadPartRequest.setFile(new File(this.uploadFileRequest.getUploadFile()));
                            uploadPartRequest.setOffset(uploadPart.offset);
                        } else {
                            FileInputStream input = new FileInputStream(this.uploadFileRequest.getUploadFile());
                            ((InputStream)input).skip(uploadPart.offset);
                            uploadPartRequest.setInput(new ProgressInputStream(input, this.progressManager, false));
                        }
                        UploadPartResult result = this.obsClient.uploadPart(uploadPartRequest);
                        PartEtag partEtag = new PartEtag(result.getEtag(), result.getPartNumber());
                        this.uploadCheckPoint.update(this.partIndex, partEtag, true);
                        tr.setFailed(false);
                        if (this.uploadFileRequest.isEnableCheckpoint()) {
                            this.uploadCheckPoint.record(this.uploadFileRequest.getCheckpointFile());
                        }
                        break block10;
                    }
                    catch (ObsException e) {
                        if (e.getResponseCode() >= 300 && e.getResponseCode() < 500 && e.getResponseCode() != 408) {
                            this.uploadCheckPoint.isAbort = true;
                        }
                        tr.setFailed(true);
                        tr.setException(e);
                        if (log.isErrorEnabled()) {
                            log.error(String.format("Task %d:%s upload part %d failed: ", this.id, "upload" + this.id, this.partIndex + 1), e);
                        }
                        break block10;
                    }
                    catch (Exception e) {
                        tr.setFailed(true);
                        tr.setException(e);
                        if (log.isErrorEnabled()) {
                            log.error(String.format("Task %d:%s upload part %d failed: ", this.id, "upload" + this.id, this.partIndex + 1), e);
                        }
                        break block10;
                    }
                }
                tr.setFailed(true);
            }
            return tr;
        }

        public void setProgressManager(ProgressManager progressManager) {
            this.progressManager = progressManager;
        }
    }
}

