/*
 * Decompiled with CFR 0.152.
 */
package shade.fasterxml.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import shade.fasterxml.jackson.core.JsonGenerator;
import shade.fasterxml.jackson.core.JsonToken;
import shade.fasterxml.jackson.core.type.WritableTypeId;
import shade.fasterxml.jackson.databind.JavaType;
import shade.fasterxml.jackson.databind.JsonMappingException;
import shade.fasterxml.jackson.databind.JsonNode;
import shade.fasterxml.jackson.databind.SerializerProvider;
import shade.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import shade.fasterxml.jackson.databind.jsontype.TypeSerializer;
import shade.fasterxml.jackson.databind.ser.std.StdSerializer;

public class RawSerializer<T>
extends StdSerializer<T> {
    public RawSerializer(Class<?> cls) {
        super(cls, false);
    }

    @Override
    public void serialize(T value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeRawValue(value.toString());
    }

    @Override
    public void serializeWithType(T value, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, typeSer.typeId(value, JsonToken.VALUE_EMBEDDED_OBJECT));
        this.serialize(value, g, provider);
        typeSer.writeTypeSuffix(g, typeIdDef);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode("string", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        this.visitStringFormat(visitor, typeHint);
    }
}

