/*
 * Decompiled with CFR 0.152.
 */
package com.hdl.myhttputils.module;

import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.google.gson.Gson;
import com.hdl.myhttputils.bean.HttpBody;
import com.hdl.myhttputils.bean.ICommCallback;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Set;

public abstract class HttpRequester {
    private static final String TAG = "HttpRequester";
    HttpBody mHttpBody;
    ICommCallback callback;
    Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1001: {
                    String json = (String)msg.obj;
                    HttpRequester.this.printJson(json);
                    if (HttpRequester.this.mHttpBody.getJavaBean() == String.class) {
                        HttpRequester.this.callback.onSucceed(json);
                    } else {
                        HttpRequester.this.callback.onSucceed(new Gson().fromJson(json, HttpRequester.this.mHttpBody.getJavaBean()));
                    }
                    HttpRequester.this.callback.onComplete();
                    break;
                }
                case 1004: {
                    HttpRequester.this.printErrorMsg("IOException");
                    HttpRequester.this.callback.onFailed(new IOException("IOException"));
                    HttpRequester.this.callback.onComplete();
                    break;
                }
                case 1002: {
                    HttpRequester.this.printErrorMsg("ServerException");
                    HttpRequester.this.callback.onFailed(new Exception("ServerException"));
                    HttpRequester.this.callback.onComplete();
                    break;
                }
                case 1003: {
                    HttpRequester.this.printErrorMsg("MalformedURLException");
                    HttpRequester.this.callback.onFailed(new MalformedURLException("MalformedURLException"));
                    HttpRequester.this.callback.onComplete();
                    break;
                }
                case 1005: {
                    Bundle bundle = (Bundle)msg.obj;
                    long total = bundle.getLong("contentLength");
                    long cur = bundle.getLong("curProgress");
                    HttpRequester.this.callback.onDownloading(total, cur);
                    break;
                }
                case 1006: {
                    HttpRequester.this.callback.onSucceed("succeed");
                    HttpRequester.this.callback.onComplete();
                    break;
                }
                case 1007: {
                    HttpRequester.this.callback.onComplete();
                    break;
                }
                case 1008: {
                    HttpRequester.this.printErrorMsg("NOFile");
                    HttpRequester.this.callback.onFailed(new Exception("NOFile"));
                    HttpRequester.this.callback.onComplete();
                }
            }
        }
    };

    public String getParams() {
        if (this.mHttpBody.getParams() == null || this.mHttpBody.getParams().size() == 0) {
            return null;
        }
        Map<String, Object> params = this.mHttpBody.getParams();
        String data = "";
        Set<Map.Entry<String, Object>> entrySet = params.entrySet();
        for (Map.Entry<String, Object> me : entrySet) {
            String value = "" + me.getValue();
            try {
                value = URLEncoder.encode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            data = data + me.getKey() + "=" + value + "&";
        }
        data = data.substring(0, data.lastIndexOf("&"));
        return data;
    }

    private void printJson(String json) {
        Log.i((String)TAG, (String)("|-------  The Json start  -------|\n\n\t" + json.toString() + "\n\n|-------  The Json end  -------|"));
    }

    public void printErrorMsg(String json) {
        Log.e((String)TAG, (String)("|\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014  The error msg  \u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014|\n\n\t" + json.toString() + "\n\n|\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014  The error msg  \u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014|"));
    }

    public abstract void request();
}

