/*
 * Decompiled with CFR 0.152.
 */
package com.hdl.myhttputils.module;

import android.os.Bundle;
import android.os.Message;
import com.hdl.myhttputils.bean.HttpBody;
import com.hdl.myhttputils.bean.ICommCallback;
import com.hdl.myhttputils.module.HttpRequester;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

public class DownLoadHttpRequester
extends HttpRequester {
    public DownLoadHttpRequester(HttpBody mHttpBody, ICommCallback callback) {
        this.mHttpBody = mHttpBody;
        this.callback = callback;
    }

    @Override
    public void request() {
        new Thread(){

            @Override
            public void run() {
                try {
                    URL url = new URL(DownLoadHttpRequester.this.mHttpBody.getUrl());
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    conn.setReadTimeout(DownLoadHttpRequester.this.mHttpBody.getReadTimeOut());
                    conn.setConnectTimeout(DownLoadHttpRequester.this.mHttpBody.getConnTimeOut());
                    if (conn.getResponseCode() == 200) {
                        InputStream is = conn.getInputStream();
                        int len = 0;
                        byte[] buf = new byte[0x100000];
                        File dir = new File(DownLoadHttpRequester.this.mHttpBody.getFileSaveDir());
                        if (!dir.exists()) {
                            dir.mkdirs();
                        }
                        long contentLength = conn.getContentLength();
                        FileOutputStream fos = new FileOutputStream(new File(dir, DownLoadHttpRequester.this.getFileName()));
                        long curProgress = 0L;
                        while ((len = is.read(buf)) != -1) {
                            fos.write(buf, 0, len);
                            Message msg = DownLoadHttpRequester.this.mHandler.obtainMessage();
                            msg.what = 1005;
                            Bundle bundle = new Bundle();
                            bundle.putLong("contentLength", contentLength);
                            bundle.putLong("curProgress", curProgress += (long)len);
                            msg.obj = bundle;
                            DownLoadHttpRequester.this.mHandler.sendMessage(msg);
                        }
                        is.close();
                        fos.close();
                        DownLoadHttpRequester.this.mHandler.sendEmptyMessage(1006);
                    } else {
                        DownLoadHttpRequester.this.mHandler.sendEmptyMessage(1002);
                    }
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                    DownLoadHttpRequester.this.mHandler.sendEmptyMessage(1003);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    DownLoadHttpRequester.this.mHandler.sendEmptyMessage(1004);
                }
            }
        }.start();
    }

    private String getFileName() {
        return this.mHttpBody.getUrl().substring(this.mHttpBody.getUrl().lastIndexOf("/") + 1);
    }
}

