/*
 * Decompiled with CFR 0.152.
 */
package com.hdl.myhttputils;

import android.util.Log;
import com.hdl.myhttputils.bean.CommCallback;
import com.hdl.myhttputils.bean.HttpBody;
import com.hdl.myhttputils.bean.ICommCallback;
import com.hdl.myhttputils.module.DownLoadHttpRequester;
import com.hdl.myhttputils.module.GetHttpRequester;
import com.hdl.myhttputils.module.PostHttpRequester;
import com.hdl.myhttputils.module.ProvideHttpRequester;
import com.hdl.myhttputils.module.UpLoadHttpRequester;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import java.util.Map;

public class MyHttpUtils {
    private static final String TAG = "MyHttpUtils";
    private HttpBody mHttpBody = new HttpBody();
    private ICommCallback callback;

    public static MyHttpUtils build() {
        return new MyHttpUtils();
    }

    public MyHttpUtils url(String url) {
        this.mHttpBody.setUrl(url);
        return this;
    }

    public MyHttpUtils uploadUrl(String uploadUrl) {
        this.mHttpBody.setUploadUrl(uploadUrl);
        return this;
    }

    public MyHttpUtils setJavaBean(Class javaBean) {
        this.mHttpBody.setJavaBean(javaBean);
        return this;
    }

    public MyHttpUtils setReadTimeOut(int readTimeOut) {
        this.mHttpBody.setReadTimeOut(readTimeOut);
        return this;
    }

    public MyHttpUtils setConnTimeOut(int connTimeOut) {
        this.mHttpBody.setConnTimeOut(connTimeOut);
        return this;
    }

    public MyHttpUtils setHttpBody(HttpBody mHttpBody) {
        this.mHttpBody = mHttpBody;
        return this;
    }

    public HttpBody getHttpBody() {
        return this.mHttpBody;
    }

    public MyHttpUtils addParam(String key, Object value) {
        this.mHttpBody.addParam(key, value);
        return this;
    }

    public MyHttpUtils addParams(Map<String, Object> params) {
        this.mHttpBody.setParams(params);
        return this;
    }

    public MyHttpUtils setFileSaveDir(String dir) {
        this.mHttpBody.setFileSaveDir(dir);
        return this;
    }

    public MyHttpUtils addFile(String filePath) {
        List<File> files = this.mHttpBody.getFiles();
        File file = new File(filePath);
        Log.e((String)TAG, (String)("addFile: \u6587\u4ef6\u8def\u5f84\u4e3a----------" + filePath));
        if (file.exists()) {
            files.add(file);
            this.mHttpBody.setFiles(files);
        } else {
            this.callback.onFailed(new FileNotFoundException("NOFile"));
            this.callback.onComplete();
        }
        return this;
    }

    public MyHttpUtils addFile(File filePath) {
        List<File> files = this.mHttpBody.getFiles();
        if (filePath.exists()) {
            files.add(filePath);
            this.mHttpBody.setFiles(files);
        } else {
            this.callback.onFailed(new FileNotFoundException("NOFile"));
            this.callback.onComplete();
        }
        return this;
    }

    public MyHttpUtils addFiles(List<File> filePaths) {
        List<File> files = this.mHttpBody.getFiles();
        try {
            for (File filePath : filePaths) {
                if (!filePath.exists()) continue;
                files.add(filePath);
            }
            this.mHttpBody.setFiles(files);
        }
        catch (Exception e) {
            this.callback.onFailed(new Exception("NOFile"));
            this.callback.onComplete();
        }
        return this;
    }

    public MyHttpUtils addFilesByPath(List<String> filePaths) {
        List<File> files = this.mHttpBody.getFiles();
        for (String filePath : filePaths) {
            File file = new File(filePath);
            if (file.exists()) {
                files.add(file);
                continue;
            }
            this.callback.onFailed(new FileNotFoundException("NOFile"));
            this.callback.onComplete();
        }
        this.mHttpBody.setFiles(files);
        return this;
    }

    public MyHttpUtils onExecute(CommCallback callback) {
        this.callback = callback;
        ProvideHttpRequester requester = new ProvideHttpRequester(new GetHttpRequester(this.mHttpBody, callback));
        requester.startRequest();
        return this;
    }

    public MyHttpUtils onExecuteByPost(CommCallback callback) {
        this.callback = callback;
        ProvideHttpRequester requester = new ProvideHttpRequester(new PostHttpRequester(this.mHttpBody, callback));
        requester.startRequest();
        return this;
    }

    public MyHttpUtils onExecuteDwonload(CommCallback callback) {
        this.callback = callback;
        ProvideHttpRequester requester = new ProvideHttpRequester(new DownLoadHttpRequester(this.mHttpBody, callback));
        requester.startRequest();
        return this;
    }

    public MyHttpUtils onExecuteUpLoad(CommCallback callback) {
        this.callback = callback;
        ProvideHttpRequester requester = new ProvideHttpRequester(new UpLoadHttpRequester(this.mHttpBody, callback));
        requester.startRequest();
        return this;
    }
}

