package com.hdl.myhttputils;

import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.RequiresApi;
import android.util.Log;

import com.google.gson.Gson;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

import static android.provider.Telephony.Mms.Part.CHARSET;

public class MyHttpUtils {
    private List<File> files;
    private String urlPath;
    private Class clazz;
    private File filePath;
    private String fileSavePath;
    private CommCallback callback;
    private HashMap<String, String> map;
    private static final int WHAT_URLFAILED = 1001;
    private static final int WHAT_IOFAILED = 1002;
    private static final int WHAT_REQFAILED = 1003;
    private static final int WHAT_REQSUCCESS = 1004;
    private static final int WHAT_PROGRESS = 1005;
    private static final int WHAT_DOWNLOAD_FINISHED = 1006;
    private static final String TAG = "MyHttpUtils";
    private int readTimeout = 30000;
    private int connectTimeout = 5000;
    private Handler mHanler = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case WHAT_URLFAILED:
                    callback.onFailed("URLException");
                    break;
                case WHAT_IOFAILED:
                    callback.onFailed("IOException");
                    break;
                case WHAT_REQFAILED:
                    callback.onFailed("CODEException");
                    break;
                case WHAT_REQSUCCESS:
                    String json = (String) msg.obj;
                    Log.i(TAG, json);
                    callback.onSucess(new Gson().fromJson(json, clazz));
                    break;
                case WHAT_PROGRESS:
                    Bundle bundle = (Bundle) msg.obj;
                    long total = bundle.getLong("contentLength");
                    long cur = bundle.getLong("curProgress");
                    callback.onDownloading(total, cur);
                    break;
                case WHAT_DOWNLOAD_FINISHED:
                    callback.onSucess("OK");
                    break;
            }
        }
    };


    public MyHttpUtils url(String urlPath) {
        this.urlPath = urlPath;
        return this;
    }

    public MyHttpUtils setJavaBean(Class clazz) {
        this.clazz = clazz;
        return this;
    }

    public MyHttpUtils addParam(HashMap<String, String> map) {
        this.map = map;
        return this;
    }

    public MyHttpUtils setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public MyHttpUtils setConnTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public MyHttpUtils addUploadFile(File filePath) {
        this.filePath = filePath;
        return this;
    }

    public MyHttpUtils addUploadFile(String filePath) {
        this.filePath = new File(filePath);
        return this;
    }

    public MyHttpUtils addUploadFiles(List<File> files) {
        this.files = files;
        return this;
    }

    public MyHttpUtils setFileSavePath(String fileSavePath) {
        this.fileSavePath = fileSavePath;
        return this;
    }

    public void onExecuteByPost(final CommCallback callback) {
        this.callback = callback;
        new Thread() {
            @Override
            public void run() {

                try {
                    URL url = new URL(urlPath);
                    HttpURLConnection conn = (HttpURLConnection) url.openConnection();
                    conn.setReadTimeout(readTimeout);
                    conn.setConnectTimeout(connectTimeout);
                    conn.setDoOutput(true);
                    conn.setDoInput(true);
                    conn.setRequestMethod("POST");
                    conn.setUseCaches(false);
                    conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                    conn.connect();
                    DataOutputStream out = new DataOutputStream(conn.getOutputStream());
                    String content = "";
                    if (map.size() > 0) {
                        Set<Map.Entry<String, String>> set = map.entrySet();
                        Iterator<Map.Entry<String, String>> it = set.iterator();
                        while (it.hasNext()) {
                            Map.Entry<String, String> me = it.next();
                            content += me.getKey() + "=" + me.getValue() + "&";

                        }
                        content = content.substring(0, content.length() - 1);
                        Log.i(TAG, content);
                    }
                    out.writeBytes(content);
                    out.flush();
                    out.close();
                    if (conn.getResponseCode() == 200) {
                        InputStream is = conn.getInputStream();
                        int len = 0;
                        byte[] buf = new byte[1024 * 1024];
                        StringBuilder json = new StringBuilder();
                        while ((len = is.read(buf)) != -1) {
                            json.append(new String(buf, 0, len));
                        }
                        is.close();
                        Message msg = mHanler.obtainMessage();
                        msg.what = WHAT_REQSUCCESS;
                        msg.obj = json.toString();
                        mHanler.sendMessage(msg);
                    } else {
                        mHanler.sendEmptyMessage(WHAT_REQFAILED);
                    }
                } catch (MalformedURLException e) {
                    e.printStackTrace();
                    mHanler.sendEmptyMessage(WHAT_URLFAILED);
                } catch (IOException e) {
                    mHanler.sendEmptyMessage(WHAT_IOFAILED);
                    e.printStackTrace();
                }
            }
        }.start();
    }

    public void onExecute(CommCallback callback) {
        this.callback = callback;
        new Thread() {
            @Override
            public void run() {
                try {
                    URL url = new URL(urlPath);
                    HttpURLConnection conn = (HttpURLConnection) url.openConnection();
                    conn.setReadTimeout(readTimeout);
                    conn.setConnectTimeout(connectTimeout);
                    if (conn.getResponseCode() == 200) {
                        InputStream is = conn.getInputStream();
                        int len = 0;
                        byte[] buf = new byte[1024 * 1024];
                        StringBuilder json = new StringBuilder();
                        while ((len = is.read(buf)) != -1) {
                            json.append(new String(buf, 0, len));
                        }
                        is.close();
                        Message msg = mHanler.obtainMessage();
                        msg.what = WHAT_REQSUCCESS;
                        msg.obj = json.toString();
                        mHanler.sendMessage(msg);
                    } else {
                        mHanler.sendEmptyMessage(WHAT_REQFAILED);
                    }
                } catch (MalformedURLException e) {
                    e.printStackTrace();
                    mHanler.sendEmptyMessage(WHAT_URLFAILED);
                } catch (IOException e) {
                    mHanler.sendEmptyMessage(WHAT_IOFAILED);
                    e.printStackTrace();
                }
            }
        }.start();
    }

    private String getFileName() {
        return urlPath.substring(urlPath.lastIndexOf("/") + 1);
    }

    public void downloadFile(final CommCallback callback) {
        this.callback = callback;
        new Thread() {
            @Override
            public void run() {
                try {
                    URL url = new URL(urlPath);
                    HttpURLConnection conn = (HttpURLConnection) url.openConnection();
                    conn.setReadTimeout(readTimeout);
                    conn.setConnectTimeout(connectTimeout);
                    if (conn.getResponseCode() == 200) {
                        InputStream is = conn.getInputStream();
                        int len = 0;
                        byte[] buf = new byte[1024 * 1024];
                        File dir = new File(fileSavePath);
                        if (!dir.exists()) {
                            dir.mkdirs();
                        }
                        long contentLength = conn.getContentLength();
                        FileOutputStream fos = new FileOutputStream(new File(dir, getFileName()));
                        long curProgress = 0;
                        while ((len = is.read(buf)) != -1) {
                            fos.write(buf, 0, len);
                            curProgress += len;
                            Message msg = mHanler.obtainMessage();
                            msg.what = WHAT_PROGRESS;
                            Bundle bundle = new Bundle();
                            bundle.putLong("contentLength", contentLength);
                            bundle.putLong("curProgress", curProgress);
                            msg.obj = bundle;
                            mHanler.sendMessage(msg);
                        }
                        is.close();
                        fos.close();
                        mHanler.sendEmptyMessage(WHAT_DOWNLOAD_FINISHED);
                    } else {
                        mHanler.sendEmptyMessage(WHAT_REQFAILED);
                    }
                } catch (MalformedURLException e) {
                    e.printStackTrace();
                    mHanler.sendEmptyMessage(WHAT_URLFAILED);
                } catch (IOException e) {
                    mHanler.sendEmptyMessage(WHAT_IOFAILED);
                    e.printStackTrace();
                }
            }
        }.start();
    }

    public void uploadFile(final CommCallback callback) {
        this.callback = callback;
        new Thread() {
            @RequiresApi(api = Build.VERSION_CODES.KITKAT)
            @Override
            public void run() {
                String BOUNDARY = UUID.randomUUID().toString();
                String PREFIX = "--", LINE_END = "\r\n";
                String CONTENT_TYPE = "multipart/form-data";
                try {
                    URL url = new URL(urlPath);
                    HttpURLConnection conn = (HttpURLConnection) url.openConnection();
                    conn.setReadTimeout(readTimeout);
                    conn.setConnectTimeout(connectTimeout);
                    conn.setDoInput(true);
                    conn.setDoOutput(true);
                    conn.setUseCaches(false);
                    conn.setRequestMethod("POST");
                    conn.setRequestProperty("Charset", CHARSET);
                    conn.setRequestProperty("connection", "keep-alive");
                    conn.setRequestProperty("Content-Type", CONTENT_TYPE + ";boundary="
                            + BOUNDARY);
                    if (filePath != null) {
                        OutputStream outputSteam = conn.getOutputStream();
                        DataOutputStream dos = new DataOutputStream(outputSteam);
                        StringBuffer sb = new StringBuffer();
                        sb.append(PREFIX);
                        sb.append(BOUNDARY);
                        sb.append(LINE_END);
                        sb.append("Content-Disposition: form-data; name=\"img\"; filename=\""
                                + filePath.getName() + "\"" + LINE_END);
                        sb.append("Content-Type: application/octet-stream; charset="
                                + CHARSET + LINE_END);
                        sb.append(LINE_END);
                        dos.write(sb.toString().getBytes());
                        InputStream is = new FileInputStream(filePath);
                        byte[] bytes = new byte[1024 * 1024];
                        int len = 0;
                        while ((len = is.read(bytes)) != -1) {
                            dos.write(bytes, 0, len);
                        }
                        is.close();
                        dos.write(LINE_END.getBytes());
                        byte[] end_data = (PREFIX + BOUNDARY + PREFIX + LINE_END)
                                .getBytes();
                        dos.write(end_data);
                        dos.flush();
                        dos.close();
                        StringBuilder json = new StringBuilder();
                        if (conn.getResponseCode() == 200) {
                            int length = 0;
                            byte buf[] = new byte[1024 * 1024];
                            InputStream cis = conn.getInputStream();
                            while ((length = cis.read(buf)) != -1) {
                                json.append(new String(buf, 0, length));
                            }
                            cis.close();
                            Message msg = mHanler.obtainMessage();
                            msg.what = WHAT_REQSUCCESS;
                            msg.obj = json.toString();
                            mHanler.sendMessage(msg);
                        } else {
                            mHanler.sendEmptyMessage(WHAT_REQFAILED);
                        }
                    }
                } catch (MalformedURLException e) {
                    e.printStackTrace();
                    mHanler.sendEmptyMessage(WHAT_URLFAILED);
                } catch (IOException e) {
                    e.printStackTrace();
                    mHanler.sendEmptyMessage(WHAT_IOFAILED);
                }
            }
        }.start();
    }

    public void uploadFileMult(final CommCallback callback) {
        this.callback = callback;
        new Thread() {
            @RequiresApi(api = Build.VERSION_CODES.KITKAT)
            @Override
            public void run() {
                String BOUNDARY = UUID.randomUUID().toString();
                String PREFIX = "--", LINE_END = "\r\n";
                String CONTENT_TYPE = "multipart/form-data";
                try {
                    URL url = new URL(urlPath);
                    HttpURLConnection conn = (HttpURLConnection) url.openConnection();
                    conn.setReadTimeout(readTimeout);
                    conn.setConnectTimeout(connectTimeout);
                    conn.setDoInput(true);
                    conn.setDoOutput(true);
                    conn.setUseCaches(false);
                    conn.setRequestMethod("POST");
                    conn.setRequestProperty("Charset", CHARSET);
                    // 设置编码
                    conn.setRequestProperty("connection", "keep-alive");
                    conn.setRequestProperty("Content-Type", CONTENT_TYPE + ";boundary="
                            + BOUNDARY);

                    OutputStream outputSteam = conn.getOutputStream();
                    DataOutputStream dos = new DataOutputStream(outputSteam);
                    for (File file : files) {
                        Log.e("get", file.getName());
                        StringBuffer sb = new StringBuffer();
                        sb.append(PREFIX);
                        sb.append(BOUNDARY);
                        sb.append(LINE_END);
                        sb.append("Content-Disposition: form-data; name=\"file\"; filename=\""
                                + file.getName() + "\"" + LINE_END);
                        sb.append("Content-Type: application/octet-stream; charset="
                                + CHARSET + LINE_END);
                        sb.append(LINE_END);
                        dos.write(sb.toString().getBytes());
                        FileInputStream fis = new FileInputStream(file);
                        byte[] bytes = new byte[64 * 1024];
                        int len = 0;
                        while ((len = fis.read(bytes)) != -1) {
                            dos.write(bytes, 0, len);
                        }
                        fis.close();
                        dos.write(LINE_END.getBytes());
                    }
                    byte[] end_data = (PREFIX + BOUNDARY + PREFIX + LINE_END)
                            .getBytes();
                    dos.write(end_data);
                    dos.flush();
                    dos.close();
                    StringBuilder json = new StringBuilder();
                    if (conn.getResponseCode() == 200) {
                        int length = 0;
                        byte buf[] = new byte[1024 * 1024];
                        InputStream cis = conn.getInputStream();
                        while ((length = cis.read(buf)) != -1) {
                            json.append(new String(buf, 0, length));
                        }
                        cis.close();
                        Message msg = mHanler.obtainMessage();
                        msg.what = WHAT_REQSUCCESS;
                        msg.obj = json.toString();
                        mHanler.sendMessage(msg);
                    } else {
                        mHanler.sendEmptyMessage(WHAT_REQFAILED);
                    }

                } catch (MalformedURLException e) {
                    e.printStackTrace();
                    mHanler.sendEmptyMessage(WHAT_URLFAILED);
                } catch (IOException e) {
                    e.printStackTrace();
                    mHanler.sendEmptyMessage(WHAT_IOFAILED);
                }
            }
        }.start();
    }
}
