/*
 * Decompiled with CFR 0.152.
 */
package com.huaban.analysis.jieba;

import com.huaban.analysis.jieba.CharacterUtil;
import com.huaban.analysis.jieba.Pair;
import com.huaban.analysis.jieba.SegToken;
import com.huaban.analysis.jieba.TrieNode;
import com.huaban.analysis.jieba.WordDictionary;
import com.huaban.analysis.jieba.viterbi.FinalSeg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JiebaSegmenter {
    private static WordDictionary wordDict = WordDictionary.getInstance();
    private static FinalSeg finalSeg = FinalSeg.getInstance();

    private Map<Integer, List<Integer>> createDAG(String sentence) {
        HashMap<Integer, List<Integer>> dag = new HashMap<Integer, List<Integer>>();
        TrieNode trie = wordDict.getTrie();
        int N = sentence.length();
        int i = 0;
        int j = 0;
        TrieNode p = trie;
        while (i < N) {
            char ch = sentence.charAt(j);
            if (p.childs.containsKey(Character.valueOf(ch))) {
                p = p.childs.get(Character.valueOf(ch));
                if (p.childs.containsKey(Character.valueOf(' '))) {
                    if (!dag.containsKey(i)) {
                        ArrayList<Integer> value = new ArrayList<Integer>();
                        dag.put(i, value);
                        value.add(j);
                    } else {
                        ((List)dag.get(i)).add(j);
                    }
                }
                if (++j < N) continue;
                j = ++i;
                p = trie;
                continue;
            }
            p = trie;
            j = ++i;
        }
        i = 0;
        while (i < N) {
            if (!dag.containsKey(i)) {
                ArrayList<Integer> value = new ArrayList<Integer>();
                value.add(i);
                dag.put(i, value);
            }
            ++i;
        }
        return dag;
    }

    private Map<Integer, Pair<Integer>> calc(String sentence, Map<Integer, List<Integer>> dag) {
        int N = sentence.length();
        HashMap<Integer, Pair<Integer>> route = new HashMap<Integer, Pair<Integer>>();
        route.put(N, new Pair<Integer>(0, 0.0));
        int i = N - 1;
        while (i > -1) {
            Pair<Integer> candidate = null;
            for (Integer x : dag.get(i)) {
                double freq = wordDict.getFreq(sentence.substring(i, x + 1)) + route.get((Object)Integer.valueOf((int)(x.intValue() + 1))).freq;
                if (candidate == null) {
                    candidate = new Pair<Integer>(x, freq);
                    continue;
                }
                if (!(candidate.freq < freq)) continue;
                candidate.freq = freq;
                candidate.key = x;
            }
            route.put(i, candidate);
            --i;
        }
        return route;
    }

    public List<SegToken> process(String paragraph, SegMode mode) {
        ArrayList<SegToken> tokens;
        block24: {
            tokens = new ArrayList<SegToken>();
            StringBuilder sb = new StringBuilder();
            int offset = 0;
            int i = 0;
            while (i < paragraph.length()) {
                char ch = CharacterUtil.regularize(paragraph.charAt(i));
                if (CharacterUtil.ccFind(ch)) {
                    sb.append(ch);
                } else {
                    if (sb.length() > 0) {
                        if (mode == SegMode.SEARCH) {
                            for (String token : this.sentenceProcess(sb.toString())) {
                                tokens.add(new SegToken(token, offset, offset += token.length()));
                            }
                        } else {
                            for (String token : this.sentenceProcess(sb.toString())) {
                                int j;
                                if (token.length() > 2) {
                                    String gram2 = "";
                                    j = 0;
                                    while (j < token.length() - 1) {
                                        gram2 = token.substring(j, j + 2);
                                        if (wordDict.containsFreq(gram2)) {
                                            tokens.add(new SegToken(gram2, offset + j, offset + j + 2));
                                        }
                                        ++j;
                                    }
                                }
                                if (token.length() > 3) {
                                    String gram3 = "";
                                    j = 0;
                                    while (j < token.length() - 2) {
                                        gram3 = token.substring(j, j + 3);
                                        if (wordDict.containsFreq(gram3)) {
                                            tokens.add(new SegToken(gram3, offset + j, offset + j + 3));
                                        }
                                        ++j;
                                    }
                                }
                                tokens.add(new SegToken(token, offset, offset += token.length()));
                            }
                        }
                        sb = new StringBuilder();
                        offset = i;
                    }
                    tokens.add(new SegToken(paragraph.substring(i, i + 1), offset++, offset));
                }
                ++i;
            }
            if (sb.length() <= 0) break block24;
            if (mode == SegMode.SEARCH) {
                for (String token : this.sentenceProcess(sb.toString())) {
                    tokens.add(new SegToken(token, offset, offset += token.length()));
                }
            } else {
                for (String token : this.sentenceProcess(sb.toString())) {
                    if (token.length() > 2) {
                        String gram2 = "";
                        int j = 0;
                        while (j < token.length() - 1) {
                            gram2 = token.substring(j, j + 2);
                            if (wordDict.containsFreq(gram2)) {
                                tokens.add(new SegToken(gram2, offset + j, offset + j + 2));
                            }
                            ++j;
                        }
                    }
                    if (token.length() > 3) {
                        String gram3 = "";
                        int j = 0;
                        while (j < token.length() - 2) {
                            gram3 = token.substring(j, j + 3);
                            if (wordDict.containsFreq(gram3)) {
                                tokens.add(new SegToken(gram3, offset + j, offset + j + 3));
                            }
                            ++j;
                        }
                    }
                    tokens.add(new SegToken(token, offset, offset += token.length()));
                }
            }
        }
        return tokens;
    }

    public List<String> sentenceProcess(String sentence) {
        ArrayList<String> tokens = new ArrayList<String>();
        int N = sentence.length();
        Map<Integer, List<Integer>> dag = this.createDAG(sentence);
        Map<Integer, Pair<Integer>> route = this.calc(sentence, dag);
        int x = 0;
        int y = 0;
        String buf = "";
        while (x < N) {
            y = (Integer)route.get((Object)Integer.valueOf((int)x)).key + 1;
            String lWord = sentence.substring(x, y);
            if (y - x == 1) {
                buf = String.valueOf(buf) + lWord;
            } else {
                if (buf.length() > 0) {
                    if (buf.length() == 1) {
                        tokens.add(buf);
                        buf = "";
                    } else {
                        if (wordDict.containsFreq(buf)) {
                            int i = 0;
                            while (i < buf.length()) {
                                tokens.add(buf.substring(i, i + 1));
                                ++i;
                            }
                        } else {
                            finalSeg.cut(buf, tokens);
                        }
                        buf = "";
                    }
                }
                tokens.add(lWord);
            }
            x = y;
        }
        if (buf.length() > 0) {
            if (buf.length() == 1) {
                tokens.add(buf);
                buf = "";
            } else {
                if (wordDict.containsFreq(buf)) {
                    int i = 0;
                    while (i < buf.length()) {
                        tokens.add(buf.substring(i, i + 1));
                        ++i;
                    }
                } else {
                    finalSeg.cut(buf, tokens);
                }
                buf = "";
            }
        }
        return tokens;
    }

    public static enum SegMode {
        INDEX,
        SEARCH;

    }
}

