/*
 * Decompiled with CFR 0.152.
 */
package com.hs.progressbutton;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.widget.ImageView;

@SuppressLint(value={"AppCompatCustomView"})
public class CustomImageView
extends ImageView {
    private int desiredWidth;
    private int mStartImage;
    private int mEndImage;

    public CustomImageView(Context context) {
        super(context);
    }

    public CustomImageView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public CustomImageView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    public CustomImageView(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    public void setDesiredDimensions(int w) {
        this.desiredWidth = w;
    }

    protected void onDraw(Canvas canvas) {
        Drawable imageDrawable = this.getDrawable();
        if (imageDrawable == null || this.getWidth() == 0 || this.getHeight() == 0) {
            return;
        }
        Bitmap b = ((BitmapDrawable)imageDrawable).getBitmap();
        Bitmap bitmap = b.copy(Bitmap.Config.ARGB_8888, true);
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.desiredWidth < w || this.desiredWidth < h) {
            w = this.desiredWidth;
            Bitmap roundBitmap = this.cropBitmap(bitmap, w);
            canvas.drawBitmap(roundBitmap, 0.0f, 0.0f, null);
        } else {
            super.onDraw(canvas);
        }
    }

    public Bitmap cropBitmap(Bitmap bitmap, int radius) {
        Bitmap resultBitmap = bitmap.getWidth() != radius || bitmap.getHeight() != radius ? Bitmap.createScaledBitmap((Bitmap)bitmap, (int)radius, (int)radius, (boolean)false) : bitmap;
        Bitmap finalBitmap = Bitmap.createBitmap((int)resultBitmap.getWidth(), (int)resultBitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(finalBitmap);
        Paint paint = new Paint();
        Rect rect = new Rect(0, 0, resultBitmap.getWidth(), resultBitmap.getHeight());
        paint.setAntiAlias(true);
        paint.setFilterBitmap(true);
        canvas.drawARGB(0, 0, 0, 0);
        canvas.drawCircle((float)(resultBitmap.getWidth() / 2) + 0.7f, (float)(resultBitmap.getHeight() / 2) + 0.7f, (float)(resultBitmap.getWidth() / 2) + 0.1f, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(resultBitmap, rect, rect, paint);
        return finalBitmap;
    }

    public void setStartImage(int drawable) {
        this.mStartImage = drawable;
        if (this.mStartImage != 0) {
            this.setImageResource(this.mStartImage);
        }
    }

    public void setEndImage(int drawable) {
        this.mEndImage = drawable;
    }

    public void showEndImage() {
        if (this.mEndImage != 0) {
            this.setImageResource(this.mEndImage);
        }
    }
}

