/*
 * Decompiled with CFR 0.152.
 */
package com.hs.progressbutton;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.util.AttributeSet;
import android.widget.ProgressBar;
import java.lang.reflect.Field;

public class CustomProgressBar
extends ProgressBar {
    private Class<?> mDrawableState;

    public CustomProgressBar(Context context) {
        super(context);
    }

    public CustomProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public CustomProgressBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    public CustomProgressBar(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    protected synchronized void onDraw(Canvas canvas) {
        super.onDraw(canvas);
    }

    public void setProgressColor(int color) {
        LayerDrawable ld = (LayerDrawable)this.getProgressDrawable();
        GradientDrawable drawable = (GradientDrawable)ld.findDrawableByLayerId(16908301);
        drawable.setColor(color);
    }

    public void setInnerRadius(int radius) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        LayerDrawable ld = (LayerDrawable)this.getProgressDrawable();
        GradientDrawable drawable = (GradientDrawable)ld.findDrawableByLayerId(16908301);
        GradientDrawable drawable1 = (GradientDrawable)ld.findDrawableByLayerId(16908303);
        if (this.mDrawableState == null) {
            this.mDrawableState = this.resolveState();
        }
        if (this.mDrawableState != null) {
            Field innerRadius = this.resolveDeclaredField(this.mDrawableState, "mInnerRadius");
            innerRadius.setInt(drawable.getConstantState(), radius);
            innerRadius.setInt(drawable1.getConstantState(), radius);
        }
    }

    public void setColor(int color) throws SecurityException, IllegalArgumentException {
        LayerDrawable ld = (LayerDrawable)this.getProgressDrawable();
        GradientDrawable drawable = (GradientDrawable)ld.findDrawableByLayerId(16908303);
        drawable.setColors(new int[]{color, color, color});
    }

    public void setThickness(int thickness) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        LayerDrawable ld = (LayerDrawable)this.getProgressDrawable();
        GradientDrawable drawable = (GradientDrawable)ld.findDrawableByLayerId(16908301);
        GradientDrawable drawable1 = (GradientDrawable)ld.findDrawableByLayerId(16908303);
        if (this.mDrawableState == null) {
            this.mDrawableState = this.resolveState();
        }
        Field innerRadius = this.resolveDeclaredField(this.mDrawableState, "mThickness");
        innerRadius.setInt(drawable.getConstantState(), thickness);
        innerRadius.setInt(drawable1.getConstantState(), thickness);
    }

    private Class<?> resolveState() {
        Class<?>[] c;
        for (Class<?> aClass : c = GradientDrawable.class.getDeclaredClasses()) {
            if (!aClass.getSimpleName().equals("GradientState")) continue;
            return aClass;
        }
        return null;
    }

    private Field resolveDeclaredField(Class<?> aClass, String fieldName) throws NoSuchFieldException {
        Field field = aClass.getDeclaredField(fieldName);
        field.setAccessible(true);
        return field;
    }
}

