/*
 * Decompiled with CFR 0.152.
 */
package com.hrh.retainer;

import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import com.hrh.retainer.IClassRetainer;
import java.util.HashMap;
import java.util.Map;

public class Retainer {
    private static Map<String, IClassRetainer<?>> mClassNameToRetainer = new HashMap();

    public static void restore(FragmentActivity target) {
        Retainer.restore(target, target.getSupportFragmentManager());
    }

    public static void restore(Fragment target) {
        Retainer.restore(target, target.getFragmentManager());
    }

    public static <T> void restore(T target, FragmentManager manager) {
        IClassRetainer<T> retainerForClass = Retainer.findOrCreateRetainerForClass(target);
        if (retainerForClass != null) {
            retainerForClass.restore(target, manager);
        }
    }

    public static void retain(FragmentActivity target) {
        Retainer.retain(target, target.getSupportFragmentManager());
    }

    public static void retain(Fragment target) {
        Retainer.retain(target, target.getFragmentManager());
    }

    public static <T> void retain(T target, FragmentManager manager) {
        IClassRetainer<T> retainerForClass = Retainer.findOrCreateRetainerForClass(target);
        if (retainerForClass != null) {
            retainerForClass.retain(target, manager);
        }
    }

    private static <T> IClassRetainer<T> findOrCreateRetainerForClass(T target) {
        String retainerClassName = target.getClass().getSimpleName() + "Retainer";
        try {
            IClassRetainer retainer = mClassNameToRetainer.get(retainerClassName);
            if (retainer == null) {
                retainer = (IClassRetainer)Class.forName(String.format("%s.%s", target.getClass().getPackage().getName(), retainerClassName)).newInstance();
                mClassNameToRetainer.put(retainerClassName, retainer);
            }
            return retainer;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

