/*
 * Decompiled with CFR 0.152.
 */
package com.hqs.common.app;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;

public class AppCallbackProcessor {
    private static Map<String, WeakReference<AppCallback>> callbacks = null;
    public static String defaultCallbackId = "qs_appDefaultCallback";

    public static void addCallback(AppCallback callback) {
        AppCallbackProcessor.addCallback(callback, defaultCallbackId);
    }

    public static void addCallback(AppCallback callback, String callbackId) {
        if (callbacks == null) {
            callbacks = new HashMap<String, WeakReference<AppCallback>>();
        }
        callbacks.put(callbackId, new WeakReference<AppCallback>(callback));
    }

    public static void call(Map<String, Object> params) {
        AppCallbackProcessor.call(params, defaultCallbackId);
    }

    public static void call(Map<String, Object> params, String callbackId) {
        AppCallback callback;
        if (callbacks != null && callbacks.containsKey(callbackId) && (callback = (AppCallback)callbacks.get(callbackId).get()) != null) {
            callback.call(params);
            callbacks.remove(callbackId);
        }
    }

    public static void removeAllCallbacks() {
        callbacks = null;
    }

    public static void removeCallback(String callbackId) {
        if (callbacks != null && callbacks.containsKey(callbackId)) {
            callbacks.remove(callbackId);
        }
    }

    public static interface AppCallback {
        public void call(Map<String, Object> var1);
    }
}

