/*
 * Decompiled with CFR 0.152.
 */
package com.hqs.common.app;

import java.util.HashMap;

public class AppCallbackProcessor {
    private static HashMap<String, AppCallback> callbacks = null;

    public static void setCallback(AppCallback callback) {
        AppCallbackProcessor.setCallback(callback, "appDefaultCallback");
    }

    public static void setCallback(AppCallback callback, String callbackId) {
        HashMap<String, AppCallback> callbacks = new HashMap<String, AppCallback>();
        callbacks.put(callbackId, callback);
        AppCallbackProcessor.setCallbacks(callbacks);
    }

    public static void setCallbacks(HashMap<String, AppCallback> callbacks) {
        if (callbacks == null) {
            return;
        }
        if (AppCallbackProcessor.callbacks == null) {
            AppCallbackProcessor.callbacks = callbacks;
        } else {
            AppCallbackProcessor.callbacks.putAll(callbacks);
        }
    }

    public static void call(HashMap<String, Object> params) {
        AppCallbackProcessor.call(params, "appDefaultCallback");
    }

    public static void call(HashMap<String, Object> params, String callbackId) {
        AppCallback callback;
        if (callbacks != null && callbacks.containsKey(callbackId) && (callback = callbacks.get(callbackId)) != null) {
            callback.call(params);
            callbacks.remove(callbackId);
        }
    }

    public static void removeAllCallbacks() {
        callbacks = null;
    }

    public static void removeCallback(String callbackId) {
        if (callbacks != null && callbacks.containsKey(callbackId)) {
            callbacks.remove(callbackId);
        }
    }

    public static interface AppCallback {
        public void call(HashMap<String, Object> var1);
    }
}

