/*
 * Decompiled with CFR 0.152.
 */
package com.hqs.common.app;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class AppCallbackProcessor {
    private static HashMap<String, WeakReference<AppCallback>> callbacks = null;

    public static void setCallback(AppCallback callback) {
        AppCallbackProcessor.setCallback(callback, "appDefaultCallback");
    }

    public static void setCallback(AppCallback callback, String callbackId) {
        HashMap<String, AppCallback> callbacks = new HashMap<String, AppCallback>();
        callbacks.put(callbackId, callback);
        AppCallbackProcessor.setCallbacks(callbacks);
    }

    public static void setCallbacks(Map<String, AppCallback> callbacks) {
        if (callbacks == null) {
            return;
        }
        Set<String> keys = callbacks.keySet();
        if (keys.size() == 0) {
            return;
        }
        if (AppCallbackProcessor.callbacks == null) {
            AppCallbackProcessor.callbacks = new HashMap();
        }
        for (String key : keys) {
            WeakReference<AppCallback> callbackWeakReference = new WeakReference<AppCallback>(callbacks.get(key));
            AppCallbackProcessor.callbacks.put(key, callbackWeakReference);
        }
    }

    public static void call(Map<String, Object> params) {
        AppCallbackProcessor.call(params, "appDefaultCallback");
    }

    public static void call(Map<String, Object> params, String callbackId) {
        AppCallback callback;
        WeakReference<AppCallback> callbackWeakReference;
        if (callbacks != null && callbacks.containsKey(callbackId) && (callbackWeakReference = callbacks.get(callbackId)) != null && (callback = (AppCallback)callbackWeakReference.get()) != null) {
            callback.call(params);
            callbacks.remove(callbackId);
        }
    }

    public static void removeAllCallbacks() {
        callbacks = null;
    }

    public static void removeCallback(String callbackId) {
        if (callbacks != null && callbacks.containsKey(callbackId)) {
            callbacks.remove(callbackId);
        }
    }

    public static interface AppCallback {
        public void call(Map<String, Object> var1);
    }
}

