/*
 * Decompiled with CFR 0.152.
 */
package com.hqs.common.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.hqs.common.R;
import java.util.Timer;
import java.util.TimerTask;

public class TimerButton
extends RelativeLayout {
    private int backgroundColorNormal = -1;
    private int backgroundColorDisable = -1;
    private String titleNormal;
    public int totalTime = -1;
    private int curTime = -1;
    private Context context;
    private TextView titleView;
    private Timer timer;

    public TimerButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        this.setup();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.TimerButton);
        int titleColor = a.getColor(R.styleable.TimerButton_titleColor, -16776961);
        this.totalTime = a.getInteger(R.styleable.TimerButton_totalTime, 60);
        this.titleNormal = a.getString(R.styleable.TimerButton_titleNormal);
        this.backgroundColorNormal = a.getColor(R.styleable.TimerButton_backgroundColorNormal, -256);
        this.backgroundColorDisable = a.getColor(R.styleable.TimerButton_backgroundColorDisable, -7829368);
        a.recycle();
        this.titleView.setTextColor(titleColor);
        this.titleView.setText((CharSequence)this.titleNormal);
        this.setBackgroundColor(this.backgroundColorNormal);
    }

    public TimerButton(Context context) {
        super(context);
        this.context = context;
        this.setup();
    }

    private void setup() {
        this.titleView = new TextView(this.context);
        this.addView((View)this.titleView);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(13, -1);
        this.titleView.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    public void startTimer() {
        if (this.timer == null) {
            this.setBackgroundColor(this.backgroundColorDisable);
            this.timer = new Timer();
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    if (TimerButton.this.curTime < 0) {
                        TimerButton.this.curTime = TimerButton.this.totalTime;
                    }
                    if (TimerButton.this.curTime == 0) {
                        TimerButton.this.reset();
                    } else {
                        final String text = TimerButton.this.curTime + "s";
                        TimerButton.this.titleView.post(new Runnable(){

                            @Override
                            public void run() {
                                TimerButton.this.setTitle(text.toLowerCase());
                            }
                        });
                    }
                    TimerButton.this.curTime--;
                }
            };
            this.timer.schedule(task, 0L, 1000L);
        }
    }

    public void setBackgroundColorNormal(int backgroundColorNormal) {
        this.backgroundColorNormal = backgroundColorNormal;
    }

    public void setBackgroundColorDisable(int backgroundColorDisable) {
        this.backgroundColorDisable = backgroundColorDisable;
    }

    public String getTitleNormal() {
        return this.titleNormal;
    }

    public void setTitleNormal(String titleNormal) {
        this.titleNormal = titleNormal;
    }

    public void setTitle(String title) {
        this.titleView.setText((CharSequence)title);
    }

    public void stop() {
        if (this.timer != null) {
            this.reset();
        }
    }

    private void reset() {
        this.timer.cancel();
        this.timer = null;
        this.curTime = -1;
        this.setBackgroundColor(this.backgroundColorNormal);
        this.setTitle(this.titleNormal);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.curTime < 0) {
            return super.onTouchEvent(event);
        }
        return true;
    }
}

