/*
 * Decompiled with CFR 0.152.
 */
package com.hqs.common.utils;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.view.View;

public class ScreenUtils {
    private static float de = 0.0f;

    private ScreenUtils() {
        throw new UnsupportedOperationException("cannot be instantiated");
    }

    public static float density(Context context) {
        if (de == 0.0f) {
            de = context.getResources().getDisplayMetrics().density;
        }
        return de;
    }

    public static float screenW(Context context) {
        float sh = context.getResources().getDisplayMetrics().heightPixels;
        float sw = context.getResources().getDisplayMetrics().widthPixels;
        sw = sh > sw ? sw : sh;
        return sw;
    }

    public static float screenH(Context context) {
        float sh = context.getResources().getDisplayMetrics().heightPixels;
        float sw = context.getResources().getDisplayMetrics().widthPixels;
        sh = sh > sw ? sh : sw;
        return sh;
    }

    public static int getStatusHeight(Context context) {
        int statusHeight = -1;
        try {
            Class<?> clazz = Class.forName("com.android.internal.R$dimen");
            Object object = clazz.newInstance();
            int height = Integer.parseInt(clazz.getField("status_bar_height").get(object).toString());
            statusHeight = context.getResources().getDimensionPixelSize(height);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return statusHeight;
    }

    public static Bitmap snapShotWithStatusBar(Activity activity) {
        View view = activity.getWindow().getDecorView();
        view.setDrawingCacheEnabled(true);
        view.buildDrawingCache();
        Bitmap bmp = view.getDrawingCache();
        int width = (int)ScreenUtils.screenW((Context)activity);
        int height = (int)ScreenUtils.screenH((Context)activity);
        Bitmap bp = null;
        bp = Bitmap.createBitmap((Bitmap)bmp, (int)0, (int)0, (int)width, (int)height);
        view.destroyDrawingCache();
        return bp;
    }

    public static Bitmap snapShotWithoutStatusBar(Activity activity) {
        View view = activity.getWindow().getDecorView();
        view.setDrawingCacheEnabled(true);
        view.buildDrawingCache();
        Bitmap bmp = view.getDrawingCache();
        Rect frame = new Rect();
        activity.getWindow().getDecorView().getWindowVisibleDisplayFrame(frame);
        int statusBarHeight = frame.top;
        int width = (int)ScreenUtils.screenW((Context)activity);
        int height = (int)ScreenUtils.screenH((Context)activity);
        Bitmap bp = null;
        bp = Bitmap.createBitmap((Bitmap)bmp, (int)0, (int)statusBarHeight, (int)width, (int)(height - statusBarHeight));
        view.destroyDrawingCache();
        return bp;
    }

    public static void setScreenOrientationPortrait(Activity activity) {
        activity.setRequestedOrientation(1);
    }

    public static void setScreenOrientationLandscape(Activity activity) {
        activity.setRequestedOrientation(0);
    }
}

