/*
 * Decompiled with CFR 0.152.
 */
package com.hqs.common.utils;

import com.hqs.common.utils.SDCardUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class Log {
    public static boolean debug;
    public static String tag;
    private static boolean saveToFile;
    public static String logFilePath;
    private static ArrayList<String> tmpLogs;
    private static String logFileDir;
    public static int bufferSize;

    public static void print(String logString) {
        Log.print(new String[]{logString});
    }

    public static void print(String ... logString) {
        if (logString == null) {
            logString = new String[]{"null"};
        }
        for (String str : logString) {
            if (debug) {
                android.util.Log.e((String)tag, (String)str);
            }
            Log.save(str);
        }
    }

    public static void print(Number log) {
        Log.print(new Number[]{log});
    }

    public static void print(Number ... log) {
        for (Number i : log) {
            if (debug) {
                android.util.Log.e((String)tag, (String)(i + ""));
            }
            Log.save(i + "");
        }
    }

    public static void print(Object log) {
        Log.print(new Object[]{log});
    }

    public static void print(Object ... log) {
        if (log == null) {
            Log.print(new String[]{"null"});
        } else {
            for (Object obj : log) {
                String l = obj == null ? "null" : obj.toString();
                if (debug) {
                    android.util.Log.e((String)tag, (String)l);
                }
                Log.save(l);
            }
        }
    }

    private static void save(String logString) {
        if (saveToFile) {
            String log = tag + logString + "\n";
            tmpLogs.add(log);
            if (tmpLogs.size() > bufferSize) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        Log.save();
                    }
                }).start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save() {
        if (!saveToFile) {
            return;
        }
        OutputStream os = null;
        FilterOutputStream bos = null;
        try {
            logFilePath = Log.getLogFilePath();
            File file = new File(logFilePath);
            if (tmpLogs.size() == 0) {
                tmpLogs.add("There is no log to save!!!");
            }
            os = new FileOutputStream(file);
            bos = new BufferedOutputStream(os);
            for (String s : tmpLogs) {
                bos.write(s.getBytes(Charset.forName("UTF-8")));
            }
            ((BufferedOutputStream)bos).flush();
            tmpLogs.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void setSaveToFile(boolean saveToFile) {
        if (SDCardUtils.isSDCardEnable() && (Log.saveToFile = saveToFile)) {
            tmpLogs = new ArrayList();
        }
    }

    private static String getLogFilePath() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd_HHmmss");
        String fileName = df.format(new Date());
        File file = new File(logFileDir);
        if (!file.exists()) {
            file.mkdirs();
        }
        return logFileDir + fileName + ".log";
    }

    public static void setLogFileDir(String logFileDir) {
        Log.logFileDir = logFileDir;
    }

    public static String getLogFileDir() {
        return logFileDir;
    }

    static {
        File file;
        debug = true;
        tag = "---log---";
        saveToFile = false;
        logFilePath = null;
        bufferSize = 80;
        if (SDCardUtils.isSDCardEnable() && !(file = new File(logFileDir = SDCardUtils.getSDCardPath() + "com.hqs.common.log" + File.separator)).exists()) {
            file.mkdir();
        }
    }
}

