/*
 * Decompiled with CFR 0.152.
 */
package com.hqs.common.view;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.Button;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.hqs.common.R;
import com.hqs.common.utils.ViewUtil;
import java.lang.ref.WeakReference;

public class QDialog {
    private Activity activity;
    private static RelativeLayout contentView;
    private static OnDialogClickListener dialogClickListener;
    private static int enterAnim;
    private static int exitAnim;
    private static Button leftButton;
    private static Button rightButton;
    private TextView tvMessage;
    private TextView tvDivider0;
    private TextView tvDivider1;
    private static int margin;
    private static boolean cancelable;
    private static int backgroundRes;
    private static WeakReference<Activity> dialogActivity;

    public QDialog(Activity activity) {
        this.activity = activity;
        this.setup();
    }

    private void setup() {
        LayoutInflater inflater = LayoutInflater.from((Context)this.activity);
        contentView = (RelativeLayout)inflater.inflate(R.layout.dialog_cancelable, null);
        leftButton = (Button)contentView.findViewById(R.id.btn_left);
        rightButton = (Button)contentView.findViewById(R.id.btn_right);
        this.tvMessage = (TextView)contentView.findViewById(R.id.tv_message);
        this.tvDivider1 = (TextView)contentView.findViewById(R.id.tv_divider1);
        this.tvDivider0 = (TextView)contentView.findViewById(R.id.tv_divider);
        ViewUtil.setRoundCornerToView((View)leftButton, 0.0f, -7829368, -1);
        ViewUtil.setRoundCornerToView((View)rightButton, 0.0f, -7829368, -1);
    }

    public QDialog setSingleButtonMode() {
        leftButton.setVisibility(8);
        this.tvDivider1.setVisibility(8);
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)rightButton.getLayoutParams();
        layoutParams.addRule(9, -1);
        rightButton.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        return this;
    }

    public void show(String message, OnDialogClickListener onDialogClickListener) {
        this.tvMessage.setText((CharSequence)message);
        dialogClickListener = onDialogClickListener;
        Intent intent = new Intent((Context)this.activity, DialogActivity.class);
        this.activity.startActivity(intent);
        this.activity.overridePendingTransition(0, 0);
    }

    public Button getLeftButton() {
        return leftButton;
    }

    public Button getRightButton() {
        return rightButton;
    }

    public void dismiss() {
        DialogActivity activity;
        if (dialogActivity != null && (activity = (DialogActivity)((Object)dialogActivity.get())) != null) {
            activity.onFinish();
            if (dialogClickListener != null) {
                dialogClickListener.onCancel();
            }
            dialogActivity = null;
        }
    }

    public OnDialogClickListener getOnDialogClickListener() {
        return dialogClickListener;
    }

    public QDialog setDividerHeight(int h) {
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.tvDivider0.getLayoutParams();
        params.height = h;
        this.tvDivider0.setLayoutParams((ViewGroup.LayoutParams)params);
        params = (RelativeLayout.LayoutParams)this.tvDivider1.getLayoutParams();
        params.width = h;
        this.tvDivider1.setLayoutParams((ViewGroup.LayoutParams)params);
        return this;
    }

    public QDialog setLeftButtonText(String text) {
        leftButton.setText((CharSequence)text);
        return this;
    }

    public QDialog setLeftButtonTextColor(int color2) {
        leftButton.setTextColor(color2);
        return this;
    }

    public QDialog setRightButtonText(String text) {
        rightButton.setText((CharSequence)text);
        return this;
    }

    public QDialog setRightButtonTextColor(int color2) {
        rightButton.setTextColor(color2);
        return this;
    }

    public QDialog setAnimation(int enterAnim, int exitAnim) {
        QDialog.enterAnim = enterAnim;
        QDialog.exitAnim = exitAnim;
        return this;
    }

    public QDialog setDividerColor(int color2) {
        this.tvDivider0.setBackgroundColor(color2);
        this.tvDivider1.setBackgroundColor(color2);
        return this;
    }

    public QDialog setBackgroundRes(int res) {
        backgroundRes = res;
        return this;
    }

    public QDialog setCancelable(boolean cancelable) {
        QDialog.cancelable = cancelable;
        return this;
    }

    public static void destroy() {
        backgroundRes = -1;
        contentView = null;
        cancelable = false;
        dialogActivity = null;
        leftButton = null;
        rightButton = null;
        dialogClickListener = null;
    }

    public void release() {
        this.activity = null;
        this.tvMessage = null;
        this.tvDivider1 = null;
        this.tvDivider0 = null;
    }

    static {
        enterAnim = R.anim.dialog_in_qs;
        exitAnim = R.anim.dialog_out_qs;
        margin = 40;
        cancelable = false;
        backgroundRes = -1;
    }

    public static class DialogActivity
    extends Activity {
        private RelativeLayout relativeLayout;

        protected void onCreate(Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
            dialogActivity = new WeakReference<DialogActivity>(this);
            this.relativeLayout = new RelativeLayout((Context)this);
            this.setContentView((View)this.relativeLayout);
            if (backgroundRes == -1) {
                this.relativeLayout.setBackgroundResource(R.color.dialogBackgroundColor);
            } else {
                this.relativeLayout.setBackgroundResource(backgroundRes);
            }
            this.relativeLayout.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (cancelable) {
                        if (dialogClickListener != null) {
                            dialogClickListener.onCancel();
                        }
                        DialogActivity.this.onFinish();
                    }
                }
            });
            this.relativeLayout.addView((View)contentView);
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
            layoutParams.addRule(13);
            layoutParams.leftMargin = margin;
            layoutParams.rightMargin = margin;
            contentView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            contentView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                }
            });
            Animation animation = AnimationUtils.loadAnimation((Context)this, (int)enterAnim);
            this.relativeLayout.setAnimation(animation);
            animation.start();
            leftButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (dialogClickListener != null) {
                        dialogClickListener.onClickLeftButton();
                    }
                    DialogActivity.this.onFinish();
                }
            });
            rightButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (dialogClickListener != null) {
                        dialogClickListener.onClickRightButton();
                    }
                    DialogActivity.this.onFinish();
                }
            });
        }

        private void onFinish() {
            this.relativeLayout.clearAnimation();
            Animation animation = AnimationUtils.loadAnimation((Context)this, (int)exitAnim);
            animation.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    DialogActivity.this.finish();
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
            this.relativeLayout.setAnimation(animation);
            animation.start();
        }

        protected void onDestroy() {
            QDialog.destroy();
            super.onDestroy();
        }

        public void finish() {
            super.finish();
            this.overridePendingTransition(0, 0);
        }
    }

    public static interface OnDialogClickListener {
        public void onClickRightButton();

        public void onClickLeftButton();

        public void onCancel();
    }
}

