/*
 * Decompiled with CFR 0.152.
 */
package com.hqs.common.view.tabbar;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.hqs.common.utils.ViewUtil;
import com.hqs.common.view.tabbar.TabBarItem;
import java.util.ArrayList;

public class TabBarView
extends RelativeLayout {
    private final String tag = "TabBarView";
    private ArrayList<TabBarItem> tabBarItems;
    private ArrayList<ItemView> itemViews;
    private Context context;
    private int currentSelectedIndex = -1;
    private OnSelectedTabBarItemListener onSelectedTabBarItemListener;
    private OnClickTabBarItemListener onClickTabBarItemListener;
    private int titleColor = -16777216;
    private int barTintColor = -16711681;
    private int rippleColor = -16776961;
    private int selectedTitleColor = -3355444;
    private int titleSize = 16;

    public TabBarView(Context context) {
        super(context);
        this.context = context;
        this.setup();
    }

    public TabBarView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        this.setup();
    }

    private void setup() {
    }

    public ArrayList<TabBarItem> getTabBarItems() {
        return this.tabBarItems;
    }

    public void setTabBarItems(ArrayList<TabBarItem> tabBarItems) {
        if (tabBarItems == null) {
            return;
        }
        this.tabBarItems = tabBarItems;
        this.removeAllViews();
        this.addSubViews();
    }

    public int getCurrentSelectedIndex() {
        return this.currentSelectedIndex;
    }

    public void setCurrentSelectedIndex(int currentSelectedIndex) {
        if (this.itemViews == null) {
            return;
        }
        if (currentSelectedIndex >= 0 && currentSelectedIndex < this.itemViews.size()) {
            ItemView itemView = this.itemViews.get(currentSelectedIndex);
            this.selectItemView(itemView, this.tabBarItems.get(currentSelectedIndex));
        }
    }

    public OnSelectedTabBarItemListener getOnSelectedTabBarItemListener() {
        return this.onSelectedTabBarItemListener;
    }

    public void setOnSelectedTabBarItemListener(OnSelectedTabBarItemListener onSelectedTabBarItemListener) {
        this.onSelectedTabBarItemListener = onSelectedTabBarItemListener;
    }

    public OnClickTabBarItemListener getOnClickTabBarItemListener() {
        return this.onClickTabBarItemListener;
    }

    public void setOnClickTabBarItemListener(OnClickTabBarItemListener onClickTabBarItemListener) {
        this.onClickTabBarItemListener = onClickTabBarItemListener;
    }

    public int getSelectedTitleColor() {
        return this.selectedTitleColor;
    }

    public void setSelectedTitleColor(int selectedTitleColor) {
        this.selectedTitleColor = selectedTitleColor;
    }

    public int getTitleSize() {
        return this.titleSize;
    }

    public void setTitleSize(int titleSize) {
        this.titleSize = titleSize;
    }

    public int getTitleColor() {
        return this.titleColor;
    }

    public void setTitleColor(int titleColor) {
        this.titleColor = titleColor;
    }

    private void setAppearance() {
        int count = this.itemViews.size();
        for (int i = 0; i < count; ++i) {
            ItemView itemView = this.itemViews.get(i);
            itemView.titleView.setTextSize((float)this.titleSize);
            if (i == this.currentSelectedIndex) {
                itemView.titleView.setTextColor(this.selectedTitleColor);
                continue;
            }
            itemView.titleView.setTextColor(this.titleColor);
        }
    }

    public int getBarTintColor() {
        return this.barTintColor;
    }

    public void setBarTintColor(int barTintColor) {
        this.barTintColor = barTintColor;
    }

    public int getRippleColor() {
        return this.rippleColor;
    }

    public void setRippleColor(int rippleColor) {
        this.rippleColor = rippleColor;
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        this.layoutSubviews();
    }

    private void addSubViews() {
        if (this.itemViews == null) {
            this.itemViews = new ArrayList();
        }
        int count = this.tabBarItems.size();
        for (int i = 0; i < count; ++i) {
            final TabBarItem item = this.tabBarItems.get(i);
            final ItemView itemView = new ItemView(this.context);
            itemView.imageView.setImageResource(item.iconRes);
            itemView.titleView.setText((CharSequence)item.title);
            itemView.tag = i;
            itemView.titleView.setTextColor(this.titleColor);
            itemView.badgeView.setText(item.badgeValue);
            itemView.setBgColor(this.barTintColor);
            this.addView((View)itemView);
            this.itemViews.add(itemView);
            itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    TabBarView.this.selectItemView(itemView, item);
                    if (TabBarView.this.onClickTabBarItemListener != null) {
                        TabBarView.this.onClickTabBarItemListener.onClickTabBarItem(item, itemView, itemView.tag);
                    }
                }
            });
        }
    }

    private void selectItemView(ItemView itemView, TabBarItem item) {
        if (itemView.isSelected) {
            return;
        }
        itemView.isSelected = true;
        if (this.onSelectedTabBarItemListener != null) {
            this.onSelectedTabBarItemListener.onSelectedTabBarItem(this.currentSelectedIndex, itemView.tag);
        }
        if (this.currentSelectedIndex != itemView.tag && this.currentSelectedIndex != -1) {
            ItemView iView = this.itemViews.get(this.currentSelectedIndex);
            TabBarItem item2 = this.tabBarItems.get(this.currentSelectedIndex);
            iView.imageView.setImageResource(item2.iconRes);
            iView.titleView.setTextColor(this.titleColor);
            iView.isSelected = false;
        }
        this.currentSelectedIndex = itemView.tag;
        itemView.imageView.setImageResource(item.selectedIconRes);
        itemView.titleView.setTextColor(this.selectedTitleColor);
    }

    private void layoutSubviews() {
        if (this.itemViews == null) {
            return;
        }
        int itemH = this.getHeight();
        int itemW = this.getWidth() / this.tabBarItems.size();
        int count = this.itemViews.size();
        for (int i = 0; i < count; ++i) {
            ItemView itemView = this.itemViews.get(i);
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(itemW, itemH);
            params.leftMargin = itemW * i;
            itemView.setLayoutParams((ViewGroup.LayoutParams)params);
        }
        this.setAppearance();
    }

    private void log(String logString) {
        Log.e((String)"TabBarView", (String)logString);
    }

    private void log(int log) {
        Log.e((String)"TabBarView", (String)(log + ""));
    }

    private void log(float log) {
        Log.e((String)"TabBarView", (String)(log + ""));
    }

    private void log(double log) {
        Log.e((String)"TabBarView", (String)(log + ""));
    }

    private void log(Object log) {
        Log.e((String)"TabBarView", (String)log.toString());
    }

    public class BadgeView
    extends TextView {
        private int bgColor;
        private float cornerRadius;
        private Paint paint;

        public BadgeView(Context context) {
            super(context);
            this.paint = new Paint();
            this.paint.setAntiAlias(true);
            if (Build.VERSION.SDK_INT >= 17) {
                this.setTextAlignment(4);
            }
            this.setTextColor(-1);
            this.setTextSize((float)((double)TabBarView.this.titleSize * 0.66));
        }

        public void setBackgroundColor(int color2) {
            super.setBackgroundColor(color2);
            this.bgColor = color2;
            this.paint.setColor(this.bgColor);
        }

        public void setLayoutParams(ViewGroup.LayoutParams params) {
            super.setLayoutParams(params);
            this.setCornerRadius((float)((double)this.getHeight() * 0.5));
        }

        private void setCornerRadius(final float cornerRadius) {
            this.cornerRadius = cornerRadius;
            ShapeDrawable drawable = new ShapeDrawable();
            drawable.setShape(new Shape(){

                public void draw(Canvas canvas, Paint paint) {
                    canvas.drawRoundRect(new RectF(0.0f, 0.0f, (float)BadgeView.this.getWidth(), (float)BadgeView.this.getHeight()), cornerRadius, cornerRadius, BadgeView.this.paint);
                }
            });
            if (Build.VERSION.SDK_INT >= 16) {
                this.setBackground((Drawable)drawable);
            }
        }

        public void setText(CharSequence text, TextView.BufferType type) {
            block3: {
                super.setText(text, type);
                if (text == null || text.length() == 0) {
                    this.setVisibility(4);
                    return;
                }
                this.setVisibility(0);
                int padding = 20;
                try {
                    Integer.parseInt(text.toString());
                    this.setPadding(padding, 0, padding, 3);
                }
                catch (Exception ex) {
                    this.setPadding(padding, 0, padding, 6);
                    if (text.charAt(text.length() - 1) != '+') break block3;
                    this.setPadding(padding, 0, padding, 5);
                }
            }
        }
    }

    public class ItemView
    extends RelativeLayout {
        private ImageView imageView;
        private TextView titleView;
        private BadgeView badgeView;
        private int bgColor;
        private int rippleColor;
        private RelativeLayout bgview;
        private Button button;
        private View.OnClickListener listener;
        private int tag;
        private boolean isSelected;
        private float badgeViewOffsetRate;
        private float imgWHRate;

        public ItemView(Context context) {
            super(context);
            this.bgColor = -16776961;
            this.rippleColor = -256;
            this.isSelected = false;
            this.badgeViewOffsetRate = 0.3f;
            this.imgWHRate = 0.56f;
            this.bgview = new RelativeLayout(context);
            this.imageView = new ImageView(context);
            this.titleView = new TextView(context);
            this.badgeView = new BadgeView(context);
            this.addButton();
            this.addView((View)this.bgview);
            this.addView((View)this.imageView);
            this.addView((View)this.titleView);
            this.addView((View)this.badgeView);
            this.titleView.setTextSize((float)TabBarView.this.titleSize);
            this.badgeView.setBackgroundColor(-65536);
        }

        private void addButton() {
            int margin;
            this.button = new Button(TabBarView.this.context);
            RelativeLayout.LayoutParams pButton = new RelativeLayout.LayoutParams(-1, -1);
            pButton.topMargin = margin = -15;
            pButton.bottomMargin = margin;
            pButton.leftMargin = margin;
            pButton.rightMargin = margin;
            this.button.setLayoutParams((ViewGroup.LayoutParams)pButton);
            this.bgview.addView((View)this.button);
            this.button.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    ItemView.this.listener.onClick(v);
                }
            });
        }

        public void setOnClickListener(View.OnClickListener l) {
            super.setOnClickListener(l);
            this.listener = l;
        }

        public void setBgColor(int color2) {
            this.bgColor = color2;
            if (Build.VERSION.SDK_INT >= 16) {
                ViewUtil.setRoundCornerToView((View)this.button, 0.0f, this.rippleColor, this.bgColor);
            } else {
                this.button.setBackgroundColor(this.bgColor);
            }
        }

        public void setLayoutParams(ViewGroup.LayoutParams params) {
            super.setLayoutParams(params);
            RelativeLayout.LayoutParams pButton = new RelativeLayout.LayoutParams(-1, -1);
            this.bgview.setLayoutParams((ViewGroup.LayoutParams)pButton);
            int margin = (int)((double)params.height * 0.06);
            int imgW = (int)((float)params.height * this.imgWHRate);
            RelativeLayout.LayoutParams pImg = new RelativeLayout.LayoutParams(imgW, imgW);
            pImg.addRule(14, -1);
            pImg.addRule(10, -1);
            pImg.topMargin = margin;
            this.imageView.setLayoutParams((ViewGroup.LayoutParams)pImg);
            int titleH = params.height - imgW - margin;
            RelativeLayout.LayoutParams pTitle = new RelativeLayout.LayoutParams(-2, titleH);
            pTitle.addRule(12, -1);
            pTitle.addRule(14, -1);
            pTitle.topMargin = margin;
            this.titleView.setLayoutParams((ViewGroup.LayoutParams)pTitle);
            RelativeLayout.LayoutParams pBadge = new RelativeLayout.LayoutParams(-2, -2);
            pBadge.addRule(9, -1);
            pBadge.addRule(10, -1);
            pBadge.topMargin = margin;
            pBadge.leftMargin = (int)((double)params.width * 0.5 + (double)((float)imgW * this.badgeViewOffsetRate));
            this.badgeView.setLayoutParams((ViewGroup.LayoutParams)pBadge);
        }

        public void setBadgeValue(String value) {
            this.badgeView.setText(value);
        }
    }

    public static interface OnClickTabBarItemListener {
        public void onClickTabBarItem(TabBarItem var1, ItemView var2, int var3);
    }

    public static interface OnSelectedTabBarItemListener {
        public void onSelectedTabBarItem(int var1, int var2);
    }
}

