/*
 * Decompiled with CFR 0.152.
 */
package com.hqs.common.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Handler;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.hqs.common.R;
import java.util.Timer;
import java.util.TimerTask;

public class TimerButton
extends RelativeLayout {
    private int backgroundColorNormalRes = -1;
    private int backgroundColorDisableRes = -1;
    private String titleNormal;
    public int totalTime = -1;
    private int curTime = -1;
    private Context context;
    private TextView titleView;
    public Handler handler = null;
    private Timer timer;

    public TimerButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        this.setup();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.TimerButton);
        int titleColor = a.getColor(R.styleable.TimerButton_titleColor, -16776961);
        this.totalTime = a.getInteger(R.styleable.TimerButton_totalTime, 60);
        this.titleNormal = a.getString(R.styleable.TimerButton_titleNormal);
        a.recycle();
        this.titleView.setTextColor(titleColor);
        this.titleView.setText((CharSequence)this.titleNormal);
    }

    public TimerButton(Context context) {
        super(context);
        this.context = context;
        this.setup();
    }

    private void setup() {
        this.titleView = new TextView(this.context);
        this.addView((View)this.titleView);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(13, -1);
        this.titleView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.setBackgroundColor(-16711936);
    }

    public void startTimer() {
        if (this.handler == null) {
            Log.e((String)"timerButton", (String)"handler is null, please set handler before call the function (startTimer())");
            return;
        }
        if (this.timer == null) {
            this.timer = new Timer();
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    if (TimerButton.this.curTime < 0) {
                        TimerButton.this.curTime = TimerButton.this.totalTime;
                    }
                    String text = TimerButton.this.curTime + "s";
                    if (TimerButton.this.curTime == 0) {
                        TimerButton.this.timer.cancel();
                        TimerButton.this.timer = null;
                        TimerButton.this.curTime = -1;
                        text = TimerButton.this.titleNormal;
                    }
                    final String t = text;
                    TimerButton.this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            TimerButton.this.setTitle(t.toLowerCase());
                        }
                    });
                    TimerButton.this.curTime--;
                }
            };
            this.timer.schedule(task, 0L, 1000L);
        }
    }

    public void startTimer(int totalTime) {
        this.totalTime = totalTime;
        this.startTimer();
    }

    public int getBackgroundColorNormalRes() {
        return this.backgroundColorNormalRes;
    }

    public void setBackgroundColorNormalRes(int backgroundColorNormalRes) {
        this.backgroundColorNormalRes = backgroundColorNormalRes;
    }

    public int getBackgroundColorDisableRes() {
        return this.backgroundColorDisableRes;
    }

    public void setBackgroundColorDisableRes(int backgroundColorDisableRes) {
        this.backgroundColorDisableRes = backgroundColorDisableRes;
    }

    public String getTitleNormal() {
        return this.titleNormal;
    }

    public void setTitleNormal(String titleNormal) {
        this.titleNormal = titleNormal;
    }

    public void setTitle(String title) {
        this.titleView.setText((CharSequence)title);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.curTime < 0) {
            return super.onTouchEvent(event);
        }
        return true;
    }
}

