/*
 * Decompiled with CFR 0.152.
 */
package com.hqs.common.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.hqs.common.R;

public class NavigationBar
extends RelativeLayout {
    public RelativeLayout contentView;
    public ImageView backImageView;
    public TextView leftItemView;
    public TextView rightItemView;
    public TextView titleView;
    public RelativeLayout rlLeftItem;
    public RelativeLayout rlRightItem;
    private View.OnClickListener onLeftItemClickListener;
    private View.OnClickListener onRightItemClickListener;

    public NavigationBar(Context context) {
        super(context);
        this.initView(context);
    }

    public NavigationBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    private void initView(Context context) {
        this.contentView = (RelativeLayout)LayoutInflater.from((Context)context).inflate(R.layout.navigation_bar_layout, null);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
        this.contentView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.addView((View)this.contentView);
        this.backImageView = (ImageView)this.contentView.findViewById(R.id.backImageView);
        this.titleView = (TextView)this.contentView.findViewById(R.id.title);
        this.leftItemView = (TextView)this.contentView.findViewById(R.id.leftItem);
        this.rightItemView = (TextView)this.contentView.findViewById(R.id.rightItem);
        this.rlLeftItem = (RelativeLayout)this.contentView.findViewById(R.id.rl_left_item);
        this.rlRightItem = (RelativeLayout)this.contentView.findViewById(R.id.rl_right_item);
        if (this.rlLeftItem != null) {
            this.rlLeftItem.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (NavigationBar.this.onLeftItemClickListener != null) {
                        NavigationBar.this.onLeftItemClickListener.onClick(v);
                    }
                }
            });
            this.rlRightItem.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (NavigationBar.this.onRightItemClickListener != null) {
                        NavigationBar.this.onRightItemClickListener.onClick(v);
                    }
                }
            });
        }
    }

    public void setTitle(String title) {
        this.titleView.setText((CharSequence)title);
    }

    public void setLeftItem(String title) {
        if (title == null || title.trim().length() == 0) {
            this.rlLeftItem.setVisibility(4);
        } else {
            this.leftItemView.setText((CharSequence)title);
            this.backImageView.setVisibility(8);
            this.rlLeftItem.setVisibility(0);
        }
    }

    public void setRightItem(String title) {
        if (title == null || title.trim().length() == 0) {
            this.rlRightItem.setVisibility(4);
        } else {
            this.rlRightItem.setVisibility(0);
            this.rightItemView.setText((CharSequence)title);
        }
    }

    public View.OnClickListener getOnRightItemClickListener() {
        return this.onRightItemClickListener;
    }

    public void setOnRightItemClickListener(View.OnClickListener onRightItemClickListener) {
        this.onRightItemClickListener = onRightItemClickListener;
    }

    public View.OnClickListener getOnLeftItemClickListener() {
        return this.onLeftItemClickListener;
    }

    public void setOnLeftItemClickListener(View.OnClickListener onLeftItemClickListener) {
        this.onLeftItemClickListener = onLeftItemClickListener;
    }

    public void showBackButton() {
        this.rlLeftItem.setVisibility(0);
        this.leftItemView.setVisibility(4);
    }

    public void hideBackButton() {
        this.rlLeftItem.setVisibility(4);
    }
}

