/*
 * Decompiled with CFR 0.152.
 */
package com.hqs.common.utils;

import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.util.Log;
import android.view.View;

public class ViewUtil {
    public static void setRoundCornerToView(View view, float cornerRadius, boolean ripple, int backgroundColor) {
        ViewUtil.setRippleDrawableRoundCorner(view, cornerRadius, ripple, ViewUtil.lighterColor(backgroundColor), backgroundColor);
    }

    public static void setRoundCornerToView(View view, float cornerRadius, int rippleColor, int backgroundColor) {
        ViewUtil.setRippleDrawableRoundCorner(view, cornerRadius, true, rippleColor, backgroundColor);
    }

    private static void setRippleDrawableRoundCorner(View view, float cornerRadius, boolean ripple, int backgroundColor) {
        ViewUtil.setRippleDrawableRoundCorner(view, cornerRadius, ripple, ViewUtil.lighterColor(backgroundColor), backgroundColor);
    }

    private static void setRippleDrawableRoundCorner(final View view, final float cornerRadius, boolean ripple, int rippleColor, final int backgroundColor) {
        ShapeDrawable shapeDrawable = new ShapeDrawable();
        shapeDrawable.setShape(new Shape(){

            public void draw(Canvas canvas, Paint paint) {
                paint.setColor(backgroundColor);
                canvas.drawRoundRect(new RectF(0.0f, 0.0f, (float)view.getWidth(), (float)view.getHeight()), cornerRadius, cornerRadius, paint);
            }
        });
        if (Build.VERSION.SDK_INT >= 21) {
            if (ripple) {
                RippleDrawable newRippleDrawable = null;
                newRippleDrawable = new RippleDrawable(ColorStateList.valueOf((int)rippleColor), (Drawable)shapeDrawable, (Drawable)shapeDrawable);
                view.setBackground((Drawable)newRippleDrawable);
            } else {
                view.setBackground((Drawable)shapeDrawable);
            }
        } else if (Build.VERSION.SDK_INT >= 16) {
            view.setBackground((Drawable)shapeDrawable);
        } else {
            view.setBackgroundColor(backgroundColor);
        }
    }

    private static int lighterColor(int color) {
        int r = Color.red((int)color);
        int b = Color.blue((int)color);
        int g = Color.green((int)color);
        int a = Color.alpha((int)color);
        int offset = 20;
        int newColor = Color.argb((int)(a -= offset), (int)r, (int)g, (int)b);
        return newColor;
    }

    public static void log(String obj) {
        Log.e((String)"====", (String)obj);
    }

    public static void log(double obj) {
        Log.e((String)"====", (String)(obj + ""));
    }
}

