/*
 * Decompiled with CFR 0.152.
 */
package com.hqs.common.view;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.hqs.R;
import com.hqs.common.utils.ViewUtil;

public class DialogView
extends RelativeLayout {
    private Context context;
    private RelativeLayout contentView;
    private OnDialogClickListener dialogClickListener;
    private Dialog dialog;
    public Button leftButton;
    public Button rightButton;
    public TextView tvMessage;
    private TextView tvDivider;

    public DialogView(Context context) {
        super(context);
        this.context = context;
        this.setup();
    }

    private void setup() {
        AlertDialog.Builder builder = Build.VERSION.SDK_INT >= 21 ? new AlertDialog.Builder(this.context, 16974393) : new AlertDialog.Builder(this.context);
        LayoutInflater inflater = LayoutInflater.from((Context)this.context);
        this.contentView = (RelativeLayout)inflater.inflate(R.layout.dialog_cancelable, null);
        builder.setView((View)this.contentView);
        builder.setCancelable(false);
        this.leftButton = (Button)this.contentView.findViewById(R.id.btn_left);
        this.rightButton = (Button)this.contentView.findViewById(R.id.btn_right);
        this.tvMessage = (TextView)this.contentView.findViewById(R.id.tv_message);
        this.tvDivider = (TextView)this.contentView.findViewById(R.id.tv_divider1);
        ViewUtil.setRoundCornerToView((View)this.leftButton, 0.0f, -7829368, -1);
        ViewUtil.setRoundCornerToView((View)this.rightButton, 0.0f, -7829368, -1);
        this.dialog = builder.create();
        this.leftButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (DialogView.this.dialogClickListener != null) {
                    DialogView.this.dialogClickListener.onClickCancelButton();
                }
                DialogView.this.dialog.dismiss();
            }
        });
        this.rightButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (DialogView.this.dialogClickListener != null) {
                    DialogView.this.dialogClickListener.onClickOKButton();
                }
                DialogView.this.dialog.dismiss();
            }
        });
    }

    public void setSingleButtonMode() {
        this.leftButton.setVisibility(8);
        this.tvDivider.setVisibility(8);
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.rightButton.getLayoutParams();
        layoutParams.addRule(9, -1);
        this.rightButton.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    public void show(String message, OnDialogClickListener onDialogClickListener) {
        if (this.dialog != null) {
            this.tvMessage.setText((CharSequence)message);
            this.dialogClickListener = onDialogClickListener;
            this.dialog.show();
        }
    }

    public void dismiss() {
        if (this.dialog != null) {
            this.dialog.dismiss();
            this.dialog = null;
        }
    }

    public static interface OnDialogClickListener {
        public void onClickOKButton();

        public void onClickCancelButton();
    }
}

