package com.hqs.common.utils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

/**
 * Created by apple on 16/9/27.
 */

public class Log {

    public static boolean enable = true;
    public static String tag = "---log---";
    private static boolean saveToFile = false;
    public static String logFilePath = null;
    private static ArrayList<String> tmpLogs;
    private static String logFileDir;

    static {
        if (SDCardUtils.isSDCardEnable()) {
            logFileDir = SDCardUtils.getSDCardPath() + "com.hqs.common.log" + File.separator;
            File file = new File(logFileDir);
            if (file.exists() == false) {
                file.mkdir();
            }
        }
    }

    // log
    public static void print(String logString) {
        if (enable == false) {
            return;
        }
        if (logString == null) {
            logString = "null";
        }
        android.util.Log.e(tag, logString);
        save(logString);
    }

    public static void print(int log) {

        if (enable == false) {
            return;
        }
        android.util.Log.e(tag, log + "");
        save(log + "");
    }

    public static void print(float log) {

        if (enable == false) {
            return;
        }
        android.util.Log.e(tag, log + "");
        save(log + "");
    }

    public static void print(double log) {

        if (enable == false) {
            return;
        }
        android.util.Log.e(tag, log + "");
        save(log + "");
    }

    public static void print(Object log) {

        if (enable == false) {
            return;
        }
        String l;
        if (log == null) {
            l = "null";
        } else {
            l = log.toString();
        }
        android.util.Log.e(tag, l);
        save(l);
    }

    private static void save(final String logString) {
        if (saveToFile) {
            String log = tag + logString + "\n";
            tmpLogs.add(log);
            if (tmpLogs.size() > 300) {
                new Thread(new Runnable() {
                    @Override
                    public void run() {
                    Log.save();
                    }
                }).start();
            }
        }
    }

    public static void save(){
        OutputStream os = null;
        BufferedOutputStream bos = null;
        try {
            File file = new File(logFilePath);

            logFilePath = getLogFilePath();
            os = new FileOutputStream(file);
            bos = new BufferedOutputStream(os);

            for (String s : tmpLogs) {
                bos.write(s.getBytes(Charset.forName("UTF-8")));
            }
            bos.flush();
            tmpLogs.clear();

        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (os != null) {
                try {
                    os.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (bos != null) {
                try {
                    bos.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void setSaveToFile(boolean saveToFile) {
        if (SDCardUtils.isSDCardEnable()) {
            Log.saveToFile = saveToFile;
            if (Log.saveToFile) {
                Log.tmpLogs = new ArrayList<>();
            }
        }
    }

    private static String getLogFilePath() {
        DateFormat df = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
        String fileName = df.format(new Date());
        return logFileDir + fileName + ".txt";
    }

    public static void setLogFileDir(String logFileDir) {
        Log.logFileDir = logFileDir;
    }

    public static String getLogFileDir() {
        return logFileDir;
    }
}
