/*
 * Decompiled with CFR 0.152.
 */
package com.hqs.common.utils;

import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.RadialGradient;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.graphics.drawable.Drawable;
import java.util.Random;

public class ColorUtil {
    public static ColorStateList colorStateList(int normal) {
        return ColorUtil.colorStateList(normal, normal);
    }

    public static ColorStateList colorStateList(int normal, int pressed) {
        return ColorUtil.colorStateList(normal, pressed, pressed, pressed);
    }

    public static ColorStateList colorStateList(int normal, int pressed, int focused, int unable) {
        int[] colors = new int[]{pressed, focused, normal, focused, unable, focused};
        int[][] states = new int[][]{{16842919, 16842910}, {16842910, 16842908}, {16842910}, {16842908}, {16842909}, {0x10100A1}};
        ColorStateList colorList = new ColorStateList((int[][])states, colors);
        return colorList;
    }

    public static int randomColor() {
        Random random = new Random();
        return Color.argb((int)255, (int)random.nextInt(256), (int)random.nextInt(256), (int)random.nextInt(256));
    }

    public static int randomDarkColor() {
        Random random = new Random();
        return Color.argb((int)255, (int)(random.nextInt(100) + 5), (int)(random.nextInt(100) + 5), (int)(random.nextInt(100) + 5));
    }

    public static int randomLightColor() {
        Random random = new Random();
        return Color.argb((int)255, (int)(random.nextInt(156) + 100), (int)(random.nextInt(156) + 100), (int)(random.nextInt(156) + 100));
    }

    public static Drawable linearGradient(Point startPoint, Point endPoint, int[] colors, float[] positions, Shader.TileMode mode) {
        MyColorDrawable colorDrawable = new MyColorDrawable();
        colorDrawable.type = 0;
        colorDrawable.startPoint = startPoint;
        colorDrawable.endPoint = endPoint;
        MyColorDrawable.access$302(colorDrawable, colors);
        MyColorDrawable.access$402(colorDrawable, positions);
        colorDrawable.tileMode = mode;
        return colorDrawable;
    }

    public static Drawable linearGradient(Point startPoint, Point endPoint, int[] colors, float[] positions) {
        return ColorUtil.linearGradient(startPoint, endPoint, colors, positions, Shader.TileMode.MIRROR);
    }

    public static Drawable linearGradientVertical(int[] colors, float[] positions) {
        Point startPoint = new Point(0, 0);
        Point endPoint = null;
        return ColorUtil.linearGradient(startPoint, endPoint, colors, positions, Shader.TileMode.MIRROR);
    }

    public static Drawable linearGradientHorizontal(int[] colors, float[] positions) {
        Point startPoint = null;
        Point endPoint = new Point(0, 0);
        return ColorUtil.linearGradient(startPoint, endPoint, colors, positions, Shader.TileMode.MIRROR);
    }

    public static Drawable linearGradientVertical(int color1, int color2) {
        Point startPoint = new Point(0, 0);
        Point endPoint = null;
        int[] colors = new int[]{color1, color2};
        float[] positions = new float[]{0.0f, 1.0f};
        return ColorUtil.linearGradient(startPoint, endPoint, colors, positions, Shader.TileMode.MIRROR);
    }

    public static Drawable linearGradientHorizontal(int color1, int color2) {
        Point startPoint = null;
        Point endPoint = new Point(0, 0);
        int[] colors = new int[]{color1, color2};
        float[] positions = new float[]{0.0f, 1.0f};
        return ColorUtil.linearGradient(startPoint, endPoint, colors, positions, Shader.TileMode.MIRROR);
    }

    public static Drawable radialGradient(Point centerPoint, float radius, int[] colors, float[] positions, Shader.TileMode mode) {
        MyColorDrawable colorDrawable = new MyColorDrawable();
        colorDrawable.type = 1;
        colorDrawable.centerPoint = centerPoint;
        colorDrawable.radius = radius;
        MyColorDrawable.access$302(colorDrawable, colors);
        MyColorDrawable.access$402(colorDrawable, positions);
        colorDrawable.tileMode = mode;
        return colorDrawable;
    }

    public static Drawable radialGradient(Point centerPoint, float radius, int[] colors, float[] positions) {
        return ColorUtil.radialGradient(centerPoint, radius, colors, positions, Shader.TileMode.CLAMP);
    }

    public static Drawable sweepGradient(Point centerPoint, int[] colors, float[] positions) {
        MyColorDrawable colorDrawable = new MyColorDrawable();
        colorDrawable.type = 2;
        colorDrawable.centerPoint = centerPoint;
        MyColorDrawable.access$302(colorDrawable, colors);
        MyColorDrawable.access$402(colorDrawable, positions);
        return colorDrawable;
    }

    private static class MyColorDrawable
    extends Drawable {
        private int alpha = 255;
        private Paint mPaint;
        private Point startPoint;
        private Point endPoint;
        private int[] colors;
        private float[] positions;
        private Point centerPoint;
        private float radius;
        private Shader.TileMode tileMode = Shader.TileMode.MIRROR;
        static final int TYPE_LINEAR_GRADIENT = 0;
        static final int TYPE_RADIAL_GRADIENT = 1;
        static final int TYPE_SWEEP_GRADIENT = 2;
        private int type = 0;

        public MyColorDrawable() {
            this.mPaint = new Paint();
        }

        public void draw(Canvas canvas) {
            Rect bounds = this.getBounds();
            if (this.startPoint != null && this.startPoint.x == 0 && this.startPoint.y == 0 && this.endPoint == null) {
                this.endPoint = new Point(0, bounds.height());
            } else if (this.startPoint == null && this.endPoint != null && this.endPoint.x == 0 && this.endPoint.y == 0) {
                this.startPoint = new Point(0, 0);
                this.endPoint.x = bounds.width();
            } else {
                if (this.startPoint == null) {
                    this.startPoint = new Point(0, 0);
                }
                if (this.endPoint == null) {
                    this.endPoint = new Point(bounds.width(), bounds.height());
                }
            }
            if (this.type == 2) {
                SweepGradient sg = new SweepGradient((float)this.centerPoint.x, (float)this.centerPoint.y, this.colors, this.positions);
                this.mPaint.setShader((Shader)sg);
            } else if (this.type == 1) {
                RadialGradient rg = new RadialGradient((float)this.centerPoint.x, (float)this.centerPoint.y, this.radius, this.colors, this.positions, this.tileMode);
                this.mPaint.setShader((Shader)rg);
            } else {
                LinearGradient lg = new LinearGradient((float)this.startPoint.x, (float)this.startPoint.y, (float)this.endPoint.x, (float)this.endPoint.y, this.colors, this.positions, this.tileMode);
                this.mPaint.setShader((Shader)lg);
            }
            this.mPaint.setAlpha(this.alpha);
            canvas.drawRect(this.getBounds(), this.mPaint);
        }

        public void setAlpha(int alpha) {
            this.alpha = alpha;
        }

        public int getAlpha() {
            return this.alpha;
        }

        public void setColorFilter(ColorFilter colorFilter) {
        }

        public int getOpacity() {
            return -1;
        }

        static /* synthetic */ int[] access$302(MyColorDrawable x0, int[] x1) {
            x0.colors = x1;
            return x1;
        }

        static /* synthetic */ float[] access$402(MyColorDrawable x0, float[] x1) {
            x0.positions = x1;
            return x1;
        }
    }
}

