/*
 * Decompiled with CFR 0.152.
 */
package com.hqs.common.utils;

import android.os.Environment;
import android.os.StatFs;
import java.io.File;

public class SDCardUtils {
    private SDCardUtils() {
        throw new UnsupportedOperationException("cannot be instantiated");
    }

    public static boolean isSDCardEnable() {
        return Environment.getExternalStorageState().equals("mounted");
    }

    public static String getSDCardPath() {
        return Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator;
    }

    public static long getSDCardAllSize() {
        if (SDCardUtils.isSDCardEnable()) {
            StatFs stat = new StatFs(SDCardUtils.getSDCardPath());
            long availableBlocks = (long)stat.getAvailableBlocks() - 4L;
            long freeBlocks = stat.getAvailableBlocks();
            return freeBlocks * availableBlocks;
        }
        return 0L;
    }

    public static long getFreeBytes(String filePath) {
        filePath = filePath.startsWith(SDCardUtils.getSDCardPath()) ? SDCardUtils.getSDCardPath() : Environment.getDataDirectory().getAbsolutePath();
        StatFs stat = new StatFs(filePath);
        long availableBlocks = (long)stat.getAvailableBlocks() - 4L;
        return (long)stat.getBlockSize() * availableBlocks;
    }

    public static String getRootDirectoryPath() {
        return Environment.getRootDirectory().getAbsolutePath();
    }
}

