/*
 * Decompiled with CFR 0.152.
 */
package com.hqs.common.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.Shape;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.hqs.R;
import java.util.ArrayList;

public class WelcomeView
extends RelativeLayout {
    private final String tag = "WelcomeView";
    private ViewPager viewPager;
    private ViewPagerAapter adapter;
    private Context context;
    private PageControlView pageControlView;
    private RoundButton button;
    private ButtonClickHandle buttonClickHandle;
    private PageChangeHandle pageChangeHandle;
    private ArrayList<Integer> imagesRes = new ArrayList();

    public WelcomeView(Context context) {
        super(context);
        this.context = context;
        this.setup();
    }

    public WelcomeView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        this.setup();
    }

    private void setup() {
        this.viewPager = new ViewPager(this.context);
        this.adapter = new ViewPagerAapter();
        this.viewPager.setAdapter((PagerAdapter)this.adapter);
        this.viewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){
            private int prePosition = -1;

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                WelcomeView.this.pageControlView.onPageScrolled(position, positionOffset);
            }

            public void onPageSelected(int position) {
                WelcomeView.this.pageControlView.setCurrentPageIndex(position);
                if (WelcomeView.this.pageChangeHandle != null) {
                    WelcomeView.this.pageChangeHandle.onPageChanged(position);
                }
                AlphaAnimation animation = null;
                if (((WelcomeView)WelcomeView.this).pageControlView.currentPageIndex == WelcomeView.this.imagesRes.size() - 1) {
                    animation = new AlphaAnimation(0.0f, 1.0f);
                    WelcomeView.this.button.setEnabled(true);
                } else {
                    WelcomeView.this.button.setEnabled(false);
                    if (this.prePosition == WelcomeView.this.imagesRes.size() - 1) {
                        animation = new AlphaAnimation(1.0f, 0.0f);
                    }
                }
                if (animation != null) {
                    animation.setDuration(400L);
                    animation.setFillAfter(true);
                    WelcomeView.this.button.startAnimation((Animation)animation);
                }
                WelcomeView.this.log("onPageSelected   " + position);
                this.prePosition = position;
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
        this.addView((View)this.viewPager);
        this.pageControlView = new PageControlView(this.context);
        this.addView(this.pageControlView);
        DisplayMetrics dm = new DisplayMetrics();
        dm = this.context.getResources().getDisplayMetrics();
        float density = dm.density;
        this.button = new RoundButton(this.context);
        this.button.setText("\u5f00\u59cb\u4f53\u9a8c");
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams((int)(120.0f * density), (int)(38.0f * density));
        params.bottomMargin = (int)(100.0f * density);
        params.addRule(14, -1);
        params.addRule(12, -1);
        this.button.setPadding(1, 1, 1, 1);
        this.button.setLayoutParams((ViewGroup.LayoutParams)params);
        this.addView((View)this.button);
        AlphaAnimation animation = new AlphaAnimation(1.0f, 0.0f);
        animation.setDuration(1L);
        animation.setFillAfter(true);
        this.button.startAnimation((Animation)animation);
        this.button.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (WelcomeView.this.buttonClickHandle != null) {
                    WelcomeView.this.buttonClickHandle.onClickButton((RoundButton)v);
                }
            }
        });
        this.button.setEnabled(false);
    }

    public ArrayList<Integer> getImagesRes() {
        return this.imagesRes;
    }

    public void setImagesRes(ArrayList<Integer> imagesRes) {
        if (imagesRes == null) {
            return;
        }
        this.imagesRes = imagesRes;
        this.adapter.notifyDataSetChanged();
        this.pageControlView.pageCount = imagesRes.size();
    }

    public void setTintColor(int color) {
        this.pageControlView.tintColor = color;
    }

    public void setSelectTintColor(int color) {
        this.pageControlView.selectedTintColor = color;
    }

    public void setPageChangeHandle(PageChangeHandle pageChangeHandle) {
        this.pageChangeHandle = pageChangeHandle;
    }

    public void setButtonClickHandle(ButtonClickHandle buttonClickHandle) {
        this.buttonClickHandle = buttonClickHandle;
    }

    public RoundButton getButton() {
        return this.button;
    }

    private void log(String logString) {
        Log.e((String)"WelcomeView", (String)logString);
    }

    private void log(int log) {
        Log.e((String)"WelcomeView", (String)(log + ""));
    }

    private void log(float log) {
        Log.e((String)"WelcomeView", (String)(log + ""));
    }

    private void log(double log) {
        Log.e((String)"WelcomeView", (String)(log + ""));
    }

    private void log(Object log) {
        Log.e((String)"WelcomeView", (String)log.toString());
    }

    public class RoundButton
    extends Button {
        private Paint paint;
        private int normalColor;

        public RoundButton(Context context) {
            super(context);
            this.paint = new Paint();
            this.paint.setAntiAlias(true);
        }

        @TargetApi(value=16)
        public void setCornerRadius(final float cornerRadius, int backgroundColorRes) {
            try {
                this.paint.setColor(WelcomeView.this.context.getResources().getColor(backgroundColorRes));
            }
            catch (Exception exception) {
                // empty catch block
            }
            ShapeDrawable drawable = new ShapeDrawable();
            drawable.setShape(new Shape(){

                public void draw(Canvas canvas, Paint paint) {
                    canvas.drawRoundRect(new RectF(0.0f, 0.0f, (float)RoundButton.this.getWidth(), (float)RoundButton.this.getHeight()), cornerRadius, cornerRadius, RoundButton.this.paint);
                }
            });
            this.setBackground((Drawable)drawable);
        }

        @TargetApi(value=16)
        public boolean onTouchEvent(MotionEvent event) {
            if (this.isEnabled()) {
                super.onTouchEvent(event);
                switch (event.getAction()) {
                    case 0: {
                        this.setTextColor(this.getHighlightColor());
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        this.setTextColor(this.normalColor);
                    }
                }
                return true;
            }
            return false;
        }

        public void setHighlightColor(int color) {
            super.setHighlightColor(color);
        }

        public void setNormalColor(int normalColor) {
            this.normalColor = normalColor;
            this.setTextColor(normalColor);
        }
    }

    public static interface ButtonClickHandle {
        public void onClickButton(RoundButton var1);
    }

    public static interface PageChangeHandle {
        public void onPageChanged(int var1);
    }

    class PageControlView
    extends View {
        public int pageCount;
        public int currentPageIndex;
        public float spacing;
        public float pointRadius;
        public int tintColor;
        public int selectedTintColor;
        public Paint paint;
        public float positionOffset;

        public PageControlView(Context context) {
            super(context);
            this.currentPageIndex = 0;
            this.spacing = 0.0f;
            this.pointRadius = 0.0f;
            this.tintColor = -3355444;
            this.selectedTintColor = -12303292;
            this.setup();
        }

        private void setup() {
            this.spacing = this.pointRadius = this.getResources().getDimension(R.dimen.pointRadius);
            this.paint = new Paint();
            this.paint.setAntiAlias(true);
        }

        protected void onDraw(Canvas canvas) {
            float originX = (float)((double)((float)this.getWidth() - (this.pointRadius * 2.0f * (float)this.pageCount + this.spacing * (float)(this.pageCount - 1))) * 0.5 + (double)this.pointRadius);
            float cx = 0.0f;
            float cy = (float)((double)this.getHeight() - (double)this.getWidth() * 0.15);
            for (int i = 0; i < this.pageCount; ++i) {
                cx = originX + (float)i * (this.pointRadius * 2.0f + this.spacing);
                this.paint.setColor(this.tintColor);
                canvas.drawCircle(cx, cy, this.pointRadius, this.paint);
            }
            cx = originX + ((float)this.currentPageIndex + this.positionOffset) * (this.pointRadius * 2.0f + this.spacing);
            this.paint.setColor(this.selectedTintColor);
            canvas.drawCircle(cx, cy, this.pointRadius, this.paint);
        }

        public void onPageScrolled(int position, float positionOffset) {
            this.positionOffset = position < this.currentPageIndex ? positionOffset - 1.0f : positionOffset;
            this.invalidate();
        }

        public void setCurrentPageIndex(int currentPageIndex) {
            this.currentPageIndex = currentPageIndex;
            this.positionOffset = 0.0f;
            this.invalidate();
        }
    }

    class ViewPagerItem
    extends ImageView {
        public ViewPagerItem(Context context) {
            super(context);
        }
    }

    class ViewPagerAapter
    extends PagerAdapter {
        ViewPagerAapter() {
        }

        public int getCount() {
            return WelcomeView.this.imagesRes.size();
        }

        public boolean isViewFromObject(View view, Object object) {
            return view == object;
        }

        public Object instantiateItem(ViewGroup container, int position) {
            ViewPagerItem item = new ViewPagerItem(WelcomeView.this.context);
            item.setBackgroundResource((Integer)WelcomeView.this.imagesRes.get(position));
            container.addView((View)item);
            return item;
        }

        public void destroyItem(ViewGroup container, int position, Object object) {
            container.removeView((View)object);
        }
    }
}

