/*
 * Decompiled with CFR 0.152.
 */
package com.hqs.common.view;

import android.content.Context;
import android.graphics.drawable.BitmapDrawable;
import android.os.Build;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.hqs.R;
import com.hqs.common.utils.SDCardUtils;
import com.hqs.common.utils.ScreenUtils;
import com.jph.takephoto.compress.CompressConfig;
import com.jph.takephoto.compress.CompressImageUtil;
import com.jph.takephoto.model.TImage;
import java.io.File;
import java.util.ArrayList;
import java.util.UUID;

public class SelectPhotoView
extends HorizontalScrollView {
    private LinearLayout contentView;
    private ImageView addImgView;
    private ArrayList<TImage> images = new ArrayList();
    private ArrayList<ImageView> imgViews;
    private ArrayList<String> smallImgPaths;
    private ArrayList<ImageView> imgViewsCache;
    private int lineSpacing = 10;
    private Context context;
    private int addButtonPadding = 10;
    private View rightView;
    private int preNetImageCount = 0;
    public String cacheDir = null;
    private ImageView.ScaleType imageScaleType = ImageView.ScaleType.CENTER_CROP;
    public Handler handler = new Handler();
    private CompressImageUtil compressImage;
    private AdapterView.OnItemClickListener onItemClickListener;
    private View.OnClickListener onClickAddButtonListener;

    public SelectPhotoView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        this.initView();
    }

    private void initView() {
        this.rightView = new View(this.context);
        if (Build.VERSION.SDK_INT >= 16) {
            this.setScrollBarSize(this.lineSpacing);
        }
        this.imgViews = new ArrayList();
        this.imgViewsCache = new ArrayList();
        this.smallImgPaths = new ArrayList();
        this.contentView = new LinearLayout(this.context);
        this.contentView.setOrientation(0);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -1);
        this.contentView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.addView((View)this.contentView);
        this.addImgView = new ImageView(this.context);
        this.addImgView.setImageResource(R.mipmap.select_photos);
        this.addImgView.setScaleType(ImageView.ScaleType.FIT_XY);
        this.contentView.addView((View)this.addImgView);
        this.imgViews.add(this.addImgView);
        this.addImgView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (SelectPhotoView.this.onClickAddButtonListener != null) {
                    SelectPhotoView.this.onClickAddButtonListener.onClick(v);
                }
            }
        });
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.adjustViewsSize();
    }

    public View.OnClickListener getOnClickAddButtonListener() {
        return this.onClickAddButtonListener;
    }

    public void setOnClickAddButtonListener(View.OnClickListener onClickAddButtonListener) {
        this.onClickAddButtonListener = onClickAddButtonListener;
    }

    public ArrayList<TImage> getImages() {
        return this.images;
    }

    public ArrayList<String> getImagePaths() {
        ArrayList<String> filePaths = new ArrayList<String>();
        if (this.images != null && this.images.size() > 0) {
            for (TImage image : this.images) {
                filePaths.add(image.getPath());
            }
        }
        return filePaths;
    }

    public ArrayList<ImageView> getImgViews() {
        return this.imgViews;
    }

    public void compressImage(String imgPath, String newImgPath, CompressImageUtil.CompressListener listener) {
        if (this.compressImage == null) {
            CompressConfig config = new CompressConfig();
            config.enableQualityCompress(true);
            this.compressImage = new CompressImageUtil(config);
        }
        this.compressImage.compress(imgPath, newImgPath, listener);
    }

    private void resetImages() {
        this.contentView.removeAllViews();
        this.imgViews.clear();
        if (this.images != null && this.images.size() + this.preNetImageCount > 0) {
            for (int i = 0; i < this.images.size() + this.preNetImageCount; ++i) {
                final ImageView imgView = this.imageViewFromImgViewsCache(i);
                this.contentView.addView((View)imgView);
                this.imgViews.add(imgView);
                imgView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (SelectPhotoView.this.onItemClickListener != null) {
                            int index = SelectPhotoView.this.imgViews.indexOf(imgView);
                            SelectPhotoView.this.onItemClickListener.onItemClick(null, (View)imgView, index, (long)index);
                        }
                    }
                });
                if (i < this.preNetImageCount) continue;
                if (this.cacheDir == null) {
                    this.cacheDir = SDCardUtils.getSDCardPath() + "/SelectPhoto/";
                }
                String imgPath = this.images.get(i - this.preNetImageCount).getPath();
                String newPath = this.smallImgPath(i - this.preNetImageCount, this.cacheDir);
                this.compressImage(imgPath, newPath, new CompressImageUtil.CompressListener(){

                    public void onCompressSuccess(final String imgPath) {
                        SelectPhotoView.this.handler.post(new Runnable(){

                            @Override
                            public void run() {
                                imgView.setImageDrawable(BitmapDrawable.createFromPath((String)imgPath));
                            }
                        });
                    }

                    public void onCompressFailed(String imgPath, String msg) {
                    }
                });
            }
        }
        this.imgViews.add(this.addImgView);
        this.contentView.addView((View)this.addImgView);
        this.contentView.addView(this.rightView);
        this.adjustViewsSize();
    }

    private ImageView imageViewFromImgViewsCache(int index) {
        if (index >= this.imgViewsCache.size()) {
            while (index >= this.imgViewsCache.size()) {
                ImageView imgView = new ImageView(this.context);
                imgView.setScaleType(this.imageScaleType);
                this.imgViewsCache.add(imgView);
            }
        }
        return this.imgViewsCache.get(index);
    }

    private String smallImgPath(int index, String basePath) {
        File file = new File(basePath);
        if (!file.exists()) {
            file.mkdir();
        }
        if (index >= this.smallImgPaths.size()) {
            while (index >= this.smallImgPaths.size()) {
                String path = basePath + "/" + UUID.randomUUID().toString() + ".png";
                this.smallImgPaths.add(path);
            }
        }
        return this.smallImgPaths.get(index);
    }

    private void adjustViewsSize() {
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(0, 0);
        params.height = params.width = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom() - this.lineSpacing * 2;
        params.leftMargin = this.lineSpacing;
        params.topMargin = this.lineSpacing;
        params.bottomMargin = this.lineSpacing;
        if (this.imgViews != null && this.imgViews.size() > 0) {
            for (int i = 0; i < this.imgViews.size(); ++i) {
                ImageView imgView = this.imgViews.get(i);
                imgView.setLayoutParams((ViewGroup.LayoutParams)params);
            }
        }
        LinearLayout.LayoutParams params1 = new LinearLayout.LayoutParams(0, 0);
        params1.width = this.lineSpacing;
        params1.height = params.width;
        this.rightView.setLayoutParams((ViewGroup.LayoutParams)params1);
        this.addImgView.setPadding(this.addButtonPadding, this.addButtonPadding, this.addButtonPadding, this.addButtonPadding);
    }

    public void removeImageAt(int index) {
        if (index >= this.preNetImageCount && index < this.imgViews.size()) {
            this.images.remove(index - this.preNetImageCount);
            this.smallImgPaths.remove(index - this.preNetImageCount);
            this.contentView.removeViewAt(index);
            this.imgViews.remove(index);
        }
    }

    public void removeAllLocalImage() {
        this.images.clear();
    }

    public void addImages(ArrayList<TImage> images) {
        this.images.addAll(images);
        this.resetImages();
    }

    public void addImage(TImage image) {
        int index = this.images == null ? 0 : this.images.size();
        this.addImageAt(image, index);
    }

    public void addImageAt(TImage image, int index) {
        if (this.images == null) {
            this.images = new ArrayList();
            this.images.add(image);
        } else {
            this.images.add(index, image);
        }
        this.resetImages();
    }

    public void clearImageCache() {
        this.imgViewsCache.clear();
    }

    public int getLineSpacing() {
        return this.lineSpacing;
    }

    public void setLineSpacing(int lineSpacing) {
        this.lineSpacing = (int)((float)lineSpacing * ScreenUtils.density(this.context));
    }

    public int getAddButtonPadding() {
        return this.addButtonPadding;
    }

    public void setAddButtonPadding(int addButtonPadding) {
        this.addButtonPadding = (int)((float)addButtonPadding * ScreenUtils.density(this.context));
    }

    public ImageView.ScaleType getImageScaleType() {
        return this.imageScaleType;
    }

    public int getPreNetImageCount() {
        return this.preNetImageCount;
    }

    public void setPreNetImageCount(int preNetImageCount) {
        this.preNetImageCount = preNetImageCount;
        this.resetImages();
    }

    public void setPreNetImageCountOnly(int preNetImageCount) {
        this.preNetImageCount = preNetImageCount;
    }

    public void setImageScaleType(ImageView.ScaleType imageScaleType) {
        this.imageScaleType = imageScaleType;
        for (int i = 0; i < this.imgViewsCache.size(); ++i) {
            ImageView imgView = this.imgViewsCache.get(i);
            imgView.setScaleType(imageScaleType);
        }
    }

    public ArrayList<String> getSmallImgPaths() {
        return this.smallImgPaths;
    }

    public AdapterView.OnItemClickListener getOnItemClickListener() {
        return this.onItemClickListener;
    }

    public void setOnItemClickListener(AdapterView.OnItemClickListener onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
    }
}

