/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.util;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.n3.IRIResolver;
import com.hp.hpl.jena.query.DataSource;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.core.DataSourceGraphImpl;
import com.hp.hpl.jena.sparql.core.DataSourceImpl;
import com.hp.hpl.jena.sparql.core.DatasetDesc;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.util.graph.GraphFactory;
import com.hp.hpl.jena.util.FileManager;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatasetUtils {
    public static Dataset createDataset(String uri, List<String> namedSourceList) {
        return DatasetUtils.createDataset(uri, namedSourceList, null, null);
    }

    public static Dataset createDataset(String uri, List<String> namedSourceList, FileManager fileManager, String baseURI) {
        ArrayList<String> uriList = new ArrayList<String>();
        uriList.add(uri);
        return DatasetUtils.createDataset(uriList, namedSourceList, fileManager, baseURI);
    }

    public static Dataset createDataset(List<String> uriList, List<String> namedSourceList) {
        return DatasetUtils.createDataset(uriList, namedSourceList, null, null);
    }

    public static Dataset createDataset(List<String> uriList, List<String> namedSourceList, FileManager fileManager, String baseURI) {
        DataSourceImpl ds = new DataSourceImpl();
        DatasetUtils.addInGraphs(ds, uriList, namedSourceList, fileManager, baseURI);
        return ds;
    }

    public static Dataset createDataset(DatasetDesc datasetDesc) {
        return DatasetUtils.createDataset(datasetDesc.getDefaultGraphURIs(), datasetDesc.getNamedGraphURIs(), null, null);
    }

    public static Dataset createDataset(DatasetDesc datasetDesc, FileManager fileManager, String baseURI) {
        return DatasetUtils.createDataset(datasetDesc.getDefaultGraphURIs(), datasetDesc.getNamedGraphURIs(), fileManager, baseURI);
    }

    public static Dataset addInGraphs(DataSource ds, List<String> uriList, List<String> namedSourceList) {
        return DatasetUtils.addInGraphs(ds, uriList, namedSourceList, null, null);
    }

    public static Dataset addInGraphs(DataSource ds, List<String> uriList, List<String> namedSourceList, FileManager fileManager, String baseURI) {
        String absURI;
        if (fileManager == null) {
            fileManager = FileManager.get();
        }
        if (ds.getDefaultModel() == null) {
            ds.setDefaultModel(GraphFactory.makeDefaultModel());
        }
        if (uriList != null) {
            for (String sourceURI : uriList) {
                absURI = null;
                absURI = baseURI != null ? IRIResolver.resolve((String)sourceURI, (String)baseURI) : IRIResolver.resolveGlobal((String)sourceURI);
                fileManager.readModel(ds.getDefaultModel(), sourceURI, absURI, null);
            }
        }
        if (namedSourceList != null) {
            for (String sourceURI : namedSourceList) {
                absURI = null;
                absURI = baseURI != null ? IRIResolver.resolve((String)sourceURI, (String)baseURI) : IRIResolver.resolveGlobal((String)sourceURI);
                Model m = GraphFactory.makeDefaultModel();
                fileManager.readModel(m, sourceURI, absURI, null);
                ds.addNamedModel(absURI, m);
            }
        }
        return ds;
    }

    public static DatasetGraph createDatasetGraph(DatasetDesc datasetDesc) {
        return DatasetUtils.createDatasetGraph(datasetDesc.getDefaultGraphURIs(), datasetDesc.getNamedGraphURIs(), null, null);
    }

    public static DatasetGraph createDatasetGraph(DatasetDesc datasetDesc, FileManager fileManager, String baseURI) {
        return DatasetUtils.createDatasetGraph(datasetDesc.getDefaultGraphURIs(), datasetDesc.getNamedGraphURIs(), fileManager, baseURI);
    }

    public static DatasetGraph createDatasetGraph(String uri, List<String> namedSourceList, FileManager fileManager, String baseURI) {
        ArrayList<String> uriList = new ArrayList<String>();
        uriList.add(uri);
        return DatasetUtils.createDatasetGraph(uriList, namedSourceList, fileManager, baseURI);
    }

    public static DatasetGraph createDatasetGraph(List<String> uriList, List<String> namedSourceList, FileManager fileManager, String baseURI) {
        DataSourceGraphImpl ds = new DataSourceGraphImpl();
        if (fileManager == null) {
            fileManager = FileManager.get();
        }
        if (uriList != null) {
            Model m = GraphFactory.makeDefaultModel();
            for (String sourceURI : uriList) {
                String absURI = null;
                absURI = baseURI != null ? IRIResolver.resolve((String)baseURI, (String)sourceURI) : IRIResolver.resolveGlobal((String)sourceURI);
                fileManager.readModel(m, sourceURI, absURI, null);
            }
            ds.setDefaultGraph(m.getGraph());
        } else {
            ds.setDefaultGraph(GraphFactory.createDefaultGraph());
        }
        if (namedSourceList != null) {
            for (String sourceURI : namedSourceList) {
                String absURI = null;
                absURI = baseURI != null ? IRIResolver.resolve((String)baseURI, (String)sourceURI) : IRIResolver.resolveGlobal((String)sourceURI);
                Model m = fileManager.loadModel(sourceURI, absURI, null);
                Node gn = Node.createURI((String)sourceURI);
                ds.addGraph(gn, m.getGraph());
            }
        }
        return ds;
    }
}

