/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.syntax;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.TriplePath;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.core.VarExprList;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.ElementAssign;
import com.hp.hpl.jena.sparql.syntax.ElementExists;
import com.hp.hpl.jena.sparql.syntax.ElementMinus;
import com.hp.hpl.jena.sparql.syntax.ElementNamedGraph;
import com.hp.hpl.jena.sparql.syntax.ElementNotExists;
import com.hp.hpl.jena.sparql.syntax.ElementPathBlock;
import com.hp.hpl.jena.sparql.syntax.ElementSubQuery;
import com.hp.hpl.jena.sparql.syntax.ElementTriplesBlock;
import com.hp.hpl.jena.sparql.syntax.ElementVisitor;
import com.hp.hpl.jena.sparql.syntax.ElementVisitorBase;
import com.hp.hpl.jena.sparql.syntax.ElementWalker;
import com.hp.hpl.jena.sparql.util.VarUtils;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternVars {
    public static Set<Var> vars(Element element) {
        return PatternVars.vars(new LinkedHashSet<Var>(), element);
    }

    public static Set<Var> vars(Set<Var> s, Element element) {
        PatternVarsVisitor v = new PatternVarsVisitor(s);
        WalkerSkipMinus walker = new WalkerSkipMinus(v);
        ElementWalker.walk(element, walker, v);
        return s;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PatternVarsVisitor
    extends ElementVisitorBase {
        private Set<Var> acc;

        private PatternVarsVisitor(Set<Var> s) {
            this.acc = s;
        }

        @Override
        public void visit(ElementTriplesBlock el) {
            Iterator<Triple> iter = el.patternElts();
            while (iter.hasNext()) {
                Triple t = iter.next();
                VarUtils.addVarsFromTriple(this.acc, t);
            }
        }

        @Override
        public void visit(ElementPathBlock el) {
            Iterator<TriplePath> iter = el.patternElts();
            while (iter.hasNext()) {
                TriplePath tp = iter.next();
                if (tp.isTriple()) {
                    VarUtils.addVarsFromTriple(this.acc, tp.asTriple());
                    continue;
                }
                VarUtils.addVarsFromTriplePath(this.acc, tp);
            }
        }

        @Override
        public void visit(ElementExists el) {
        }

        @Override
        public void visit(ElementNotExists el) {
        }

        @Override
        public void visit(ElementNamedGraph el) {
            VarUtils.addVar(this.acc, el.getGraphNameNode());
        }

        @Override
        public void visit(ElementSubQuery el) {
            el.getQuery().setResultVars();
            VarExprList x = el.getQuery().getProject();
            this.acc.addAll(x.getVars());
        }

        @Override
        public void visit(ElementAssign el) {
            this.acc.add(el.getVar());
        }
    }

    static class WalkerSkipMinus
    extends ElementWalker.Walker {
        protected WalkerSkipMinus(ElementVisitor visitor) {
            super(visitor);
        }

        public void visit(ElementMinus el) {
            this.proc.visit(el);
        }
    }
}

