/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.sse.writers;

import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.util.IndentedWriter;

public class WriterLib {
    static final int UNDEF = 0;
    public static final int NL = 1;
    public static final int NoNL = -1;
    public static final int NoSP = -2;

    public static void start(IndentedWriter out, String tag, int linePolicy) {
        WriterLib._start(out, tag, linePolicy, "(");
    }

    public static void finish(IndentedWriter out, String tag) {
        WriterLib._finish(out, tag, ")");
    }

    public static void start(IndentedWriter out) {
        WriterLib._start(out, "(");
    }

    public static void finish(IndentedWriter out) {
        WriterLib._finish(out, ")");
    }

    public static void start2(IndentedWriter out, String tag, int linePolicy) {
        WriterLib._start(out, tag, linePolicy, "[");
    }

    public static void finish2(IndentedWriter out, String tag) {
        WriterLib._finish(out, tag, "]");
    }

    public static void start2(IndentedWriter out) {
        WriterLib._start(out, "[");
    }

    public static void finish2(IndentedWriter out) {
        WriterLib._finish(out, "]");
    }

    private static void _start(IndentedWriter out, String tag, int linePolicy, String startMarker) {
        WriterLib._start(out, startMarker);
        out.print(tag);
        switch (linePolicy) {
            case 1: {
                out.println();
                break;
            }
            case -1: {
                out.print(" ");
                break;
            }
            case -2: {
                break;
            }
            case 0: {
                throw new ARQInternalErrorException("Explicit tag not no line policy");
            }
        }
        out.incIndent();
    }

    private static void _finish(IndentedWriter out, String tag, String finishMarker) {
        out.decIndent();
        WriterLib._finish(out, finishMarker);
    }

    private static void _start(IndentedWriter out, String startMarker) {
        out.print(startMarker);
    }

    private static void _finish(IndentedWriter out, String finishMarker) {
        out.print(finishMarker);
    }
}

