/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.resultset;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.lib.org.json.JSONObject;
import com.hp.hpl.jena.sparql.resultset.ResultSetProcessor;
import com.hp.hpl.jena.sparql.util.ALog;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class JSONOutputResultSet
implements ResultSetProcessor {
    static boolean multiLineValues = false;
    static boolean multiLineVarNames = false;
    private boolean outputGraphBNodeLabels = false;
    private IndentedWriter out;
    private int bNodeCounter = 0;
    private Map<Resource, String> bNodeMap = new HashMap<Resource, String>();
    boolean firstSolution = true;
    boolean firstBindingInSolution = true;

    JSONOutputResultSet(OutputStream outStream) {
        this(new IndentedWriter(outStream));
    }

    JSONOutputResultSet(IndentedWriter indentedOut) {
        this.out = indentedOut;
        this.outputGraphBNodeLabels = ARQ.isTrue(ARQ.outputGraphBNodeLabels);
    }

    public void start(ResultSet rs) {
        this.out.println("{");
        this.out.incIndent();
        this.doHead(rs);
        this.out.println(JSONOutputResultSet.quoteName("results") + ": {");
        this.out.incIndent();
        this.out.println(JSONOutputResultSet.quoteName("bindings") + ": [");
        this.out.incIndent();
        this.firstSolution = true;
    }

    public void finish(ResultSet rs) {
        this.out.println();
        this.out.decIndent();
        this.out.println("]");
        this.out.decIndent();
        this.out.println("}");
        this.out.decIndent();
        this.out.println("}");
        this.out.flush();
    }

    private void doHead(ResultSet rs) {
        this.out.println(JSONOutputResultSet.quoteName("head") + ": {");
        this.out.incIndent();
        this.doLink(rs);
        this.doVars(rs);
        this.out.decIndent();
        this.out.println("} ,");
    }

    private void doLink(ResultSet rs) {
    }

    private void doVars(ResultSet rs) {
        this.out.print(JSONOutputResultSet.quoteName("vars") + ": [ ");
        if (multiLineVarNames) {
            this.out.println();
        }
        this.out.incIndent();
        Iterator<String> iter = rs.getResultVars().iterator();
        while (iter.hasNext()) {
            String varname = iter.next();
            this.out.print("\"" + varname + "\"");
            if (multiLineVarNames) {
                this.out.println();
            }
            if (!iter.hasNext()) continue;
            this.out.print(" , ");
        }
        this.out.println(" ]");
        this.out.decIndent();
    }

    public void start(QuerySolution qs) {
        if (!this.firstSolution) {
            this.out.println(" ,");
        }
        this.firstSolution = false;
        this.out.println("{");
        this.out.incIndent();
        this.firstBindingInSolution = true;
    }

    public void finish(QuerySolution qs) {
        this.out.println();
        this.out.decIndent();
        this.out.print("}");
    }

    public void binding(String varName, RDFNode value) {
        if (value == null) {
            return;
        }
        if (!this.firstBindingInSolution) {
            this.out.println(" ,");
        }
        this.firstBindingInSolution = false;
        this.out.print(JSONOutputResultSet.quote(varName) + ": { ");
        if (multiLineValues) {
            this.out.println();
        }
        this.out.incIndent();
        if (value.isLiteral()) {
            this.printLiteral((Literal)value);
        } else if (value.isResource()) {
            this.printResource((Resource)value);
        } else {
            ALog.warn(this, "Unknown RDFNode type in result set: " + value.getClass());
        }
        this.out.decIndent();
        if (!multiLineValues) {
            this.out.print(" ");
        }
        this.out.print("}");
    }

    private void printUnbound() {
        this.out.print(JSONOutputResultSet.quoteName("type") + ": " + JSONOutputResultSet.quote("unbound") + " , ");
        if (multiLineValues) {
            this.out.println();
        }
        this.out.print(JSONOutputResultSet.quoteName("value") + ": null");
        if (multiLineValues) {
            this.out.println();
        }
    }

    private void printLiteral(Literal literal) {
        String datatype = literal.getDatatypeURI();
        String lang = literal.getLanguage();
        if (datatype != null) {
            this.out.print(JSONOutputResultSet.quoteName("datatype") + ": " + JSONOutputResultSet.quote(datatype) + " , ");
            if (multiLineValues) {
                this.out.println();
            }
            this.out.print(JSONOutputResultSet.quoteName("type") + ": " + JSONOutputResultSet.quote("typed-literal") + " , ");
            if (multiLineValues) {
                this.out.println();
            }
        } else {
            this.out.print(JSONOutputResultSet.quoteName("type") + ": " + JSONOutputResultSet.quote("literal") + " , ");
            if (multiLineValues) {
                this.out.println();
            }
            if (lang != null && !lang.equals("")) {
                this.out.print(JSONOutputResultSet.quoteName("xml:lang") + ": " + JSONOutputResultSet.quote(lang) + " , ");
                if (multiLineValues) {
                    this.out.println();
                }
            }
        }
        this.out.print(JSONOutputResultSet.quoteName("value") + ": " + JSONOutputResultSet.quote(literal.getLexicalForm()));
        if (multiLineValues) {
            this.out.println();
        }
    }

    private void printResource(Resource resource) {
        if (resource.isAnon()) {
            String label;
            if (this.outputGraphBNodeLabels) {
                label = resource.getId().getLabelString();
            } else {
                if (!this.bNodeMap.containsKey(resource)) {
                    this.bNodeMap.put(resource, "b" + this.bNodeCounter++);
                }
                label = this.bNodeMap.get(resource);
            }
            this.out.print(JSONOutputResultSet.quoteName("type") + ": " + JSONOutputResultSet.quote("bnode") + " , ");
            if (multiLineValues) {
                this.out.println();
            }
            this.out.print(JSONOutputResultSet.quoteName("value") + ": " + JSONOutputResultSet.quote(label));
            if (multiLineValues) {
                this.out.println();
            }
        } else {
            this.out.print(JSONOutputResultSet.quoteName("type") + ": " + JSONOutputResultSet.quote("uri") + " , ");
            if (multiLineValues) {
                this.out.println();
            }
            this.out.print(JSONOutputResultSet.quoteName("value") + ": " + JSONOutputResultSet.quote(resource.getURI()));
            if (multiLineValues) {
                this.out.println();
            }
            return;
        }
    }

    private static String quote(String string) {
        return JSONObject.quote(string);
    }

    private static String quoteName(String string) {
        return JSONOutputResultSet.quote(string);
    }
}

