/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.nodevalue;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.AbstractDateTime;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDateTime;
import com.hp.hpl.jena.datatypes.xsd.XSDDuration;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.ExprEvalTypeException;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.nodevalue.NumericType;
import com.hp.hpl.jena.sparql.util.ALog;
import com.hp.hpl.jena.sparql.util.DateTimeStruct;
import com.hp.hpl.jena.sparql.util.StringUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;

public class XSDFuncOp {
    private static final int DIVIDE_PRECISION = 24;
    private static final BigDecimal BigDecimalZero = new BigDecimal(0.0);
    public static boolean strictDateTimeFO = false;
    public static final String defaultTimezone = "Z";

    private XSDFuncOp() {
    }

    public static NodeValue add(NodeValue nv1, NodeValue nv2) {
        switch (XSDFuncOp.classifyNumeric("add", nv1, nv2)) {
            case OP_INTEGER: {
                return NodeValue.makeInteger(nv1.getInteger().add(nv2.getInteger()));
            }
            case OP_DECIMAL: {
                return NodeValue.makeDecimal(nv1.getDecimal().add(nv2.getDecimal()));
            }
            case OP_FLOAT: {
                return NodeValue.makeFloat(nv1.getFloat() + nv2.getFloat());
            }
            case OP_DOUBLE: {
                return NodeValue.makeDouble(nv1.getDouble() + nv2.getDouble());
            }
        }
        throw new ARQInternalErrorException("Unrecognized numeric operation : (" + nv1 + " ," + nv2 + ")");
    }

    public static NodeValue subtract(NodeValue nv1, NodeValue nv2) {
        switch (XSDFuncOp.classifyNumeric("subtract", nv1, nv2)) {
            case OP_INTEGER: {
                return NodeValue.makeInteger(nv1.getInteger().subtract(nv2.getInteger()));
            }
            case OP_DECIMAL: {
                return NodeValue.makeDecimal(nv1.getDecimal().subtract(nv2.getDecimal()));
            }
            case OP_FLOAT: {
                return NodeValue.makeFloat(nv1.getFloat() - nv2.getFloat());
            }
            case OP_DOUBLE: {
                return NodeValue.makeDouble(nv1.getDouble() - nv2.getDouble());
            }
        }
        throw new ARQInternalErrorException("Unrecognized numeric operation : (" + nv1 + " ," + nv2 + ")");
    }

    public static NodeValue multiply(NodeValue nv1, NodeValue nv2) {
        switch (XSDFuncOp.classifyNumeric("multiply", nv1, nv2)) {
            case OP_INTEGER: {
                return NodeValue.makeInteger(nv1.getInteger().multiply(nv2.getInteger()));
            }
            case OP_DECIMAL: {
                return NodeValue.makeDecimal(nv1.getDecimal().multiply(nv2.getDecimal()));
            }
            case OP_FLOAT: {
                return NodeValue.makeFloat(nv1.getFloat() * nv2.getFloat());
            }
            case OP_DOUBLE: {
                return NodeValue.makeDouble(nv1.getDouble() * nv2.getDouble());
            }
        }
        throw new ARQInternalErrorException("Unrecognized numeric operation : (" + nv1 + " ," + nv2 + ")");
    }

    public static NodeValue divide(NodeValue nv1, NodeValue nv2) {
        switch (XSDFuncOp.classifyNumeric("divide", nv1, nv2)) {
            case OP_INTEGER: {
                if (nv2.getInteger().equals(BigInteger.ZERO)) {
                    throw new ExprEvalException("Divide by zero in divide");
                }
                BigDecimal d1 = new BigDecimal(nv1.getInteger());
                BigDecimal d2 = new BigDecimal(nv2.getInteger());
                return NodeValue.makeDecimal(XSDFuncOp.decimalDivide(d1, d2));
            }
            case OP_DECIMAL: {
                if (nv2.getDecimal().equals(BigDecimalZero)) {
                    throw new ExprEvalException("Divide by zero in decimal divide");
                }
                BigDecimal d1 = nv1.getDecimal();
                BigDecimal d2 = nv2.getDecimal();
                return NodeValue.makeDecimal(XSDFuncOp.decimalDivide(d1, d2));
            }
            case OP_FLOAT: {
                return NodeValue.makeFloat(nv1.getFloat() / nv2.getFloat());
            }
            case OP_DOUBLE: {
                return NodeValue.makeDouble(nv1.getDouble() / nv2.getDouble());
            }
        }
        throw new ARQInternalErrorException("Unrecognized numeric operation : (" + nv1 + " ," + nv2 + ")");
    }

    private static BigDecimal decimalDivide(BigDecimal d1, BigDecimal d2) {
        try {
            return d1.divide(d2, 24, 3);
        }
        catch (ArithmeticException ex) {
            ALog.warn(XSDFuncOp.class, "ArithmeticException in decimal divide - attempting to treat as doubles");
            return new BigDecimal(d1.doubleValue() / d2.doubleValue());
        }
    }

    public static NodeValue max(NodeValue nv1, NodeValue nv2) {
        int x = XSDFuncOp.compareNumeric(nv1, nv2);
        if (x == -1) {
            return nv2;
        }
        return nv1;
    }

    public static NodeValue min(NodeValue nv1, NodeValue nv2) {
        int x = XSDFuncOp.compareNumeric(nv1, nv2);
        if (x == 1) {
            return nv2;
        }
        return nv1;
    }

    public static NodeValue not(NodeValue nv) {
        boolean b = XSDFuncOp.booleanEffectiveValue(nv);
        return NodeValue.booleanReturn(!b);
    }

    public static NodeValue booleanEffectiveValueAsNodeValue(NodeValue nv) {
        if (nv.isBoolean()) {
            return nv;
        }
        return NodeValue.booleanReturn(XSDFuncOp.booleanEffectiveValue(nv));
    }

    public static boolean booleanEffectiveValue(NodeValue nv) {
        if (nv.isBoolean()) {
            return nv.getBoolean();
        }
        if (nv.isString()) {
            return nv.getString().length() > 0;
        }
        if (nv.isInteger()) {
            return !nv.getInteger().equals(NodeValue.IntegerZERO);
        }
        if (nv.isDecimal()) {
            return !nv.getDecimal().equals(NodeValue.DecimalZERO);
        }
        if (nv.isDouble()) {
            return nv.getDouble() != 0.0;
        }
        NodeValue.raise(new ExprEvalException("Not a boolean effective value (wrong type): " + nv));
        return false;
    }

    public static NodeValue unaryMinus(NodeValue nv) {
        switch (XSDFuncOp.classifyNumeric("unaryMinus", nv)) {
            case OP_INTEGER: {
                return NodeValue.makeInteger(nv.getInteger().negate());
            }
            case OP_DECIMAL: {
                return NodeValue.makeDecimal(nv.getDecimal().negate());
            }
            case OP_FLOAT: {
                return NodeValue.makeFloat(-nv.getFloat());
            }
            case OP_DOUBLE: {
                return NodeValue.makeDouble(-nv.getDouble());
            }
        }
        throw new ARQInternalErrorException("Unrecognized numeric operation : " + nv);
    }

    public static NodeValue unaryPlus(NodeValue nv) {
        NumericType opType = XSDFuncOp.classifyNumeric("unaryPlus", nv);
        return nv;
    }

    public static NodeValue abs(NodeValue nv) {
        switch (XSDFuncOp.classifyNumeric("abs", nv)) {
            case OP_INTEGER: {
                return NodeValue.makeInteger(nv.getInteger().abs());
            }
            case OP_DECIMAL: {
                return NodeValue.makeDecimal(nv.getDecimal().abs());
            }
            case OP_FLOAT: {
                return NodeValue.makeFloat(Math.abs(nv.getFloat()));
            }
            case OP_DOUBLE: {
                return NodeValue.makeDouble(Math.abs(nv.getDouble()));
            }
        }
        throw new ARQInternalErrorException("Unrecognized numeric operation : " + nv);
    }

    public static NodeValue ceiling(NodeValue v) {
        switch (XSDFuncOp.classifyNumeric("ceiling", v)) {
            case OP_INTEGER: {
                return v;
            }
            case OP_DECIMAL: {
                BigDecimal dec = v.getDecimal().setScale(0, 2);
                return NodeValue.makeDecimal(dec);
            }
            case OP_FLOAT: {
                return NodeValue.makeDouble(Math.ceil(v.getFloat()));
            }
            case OP_DOUBLE: {
                return NodeValue.makeDouble(Math.ceil(v.getDouble()));
            }
        }
        throw new ARQInternalErrorException("Unrecognized numeric operation : " + v);
    }

    public static NodeValue floor(NodeValue v) {
        switch (XSDFuncOp.classifyNumeric("floor", v)) {
            case OP_INTEGER: {
                return v;
            }
            case OP_DECIMAL: {
                BigDecimal dec = v.getDecimal().setScale(0, 3);
                return NodeValue.makeDecimal(dec);
            }
            case OP_FLOAT: {
                return NodeValue.makeDouble(Math.floor(v.getFloat()));
            }
            case OP_DOUBLE: {
                return NodeValue.makeDouble(Math.floor(v.getDouble()));
            }
        }
        throw new ARQInternalErrorException("Unrecognized numeric operation : " + v);
    }

    public static NodeValue round(NodeValue v) {
        switch (XSDFuncOp.classifyNumeric("round", v)) {
            case OP_INTEGER: {
                return v;
            }
            case OP_DECIMAL: {
                BigDecimal dec = v.getDecimal().setScale(0, 1);
                return NodeValue.makeDecimal(dec);
            }
            case OP_FLOAT: {
                return NodeValue.makeFloat(Math.round(v.getFloat()));
            }
            case OP_DOUBLE: {
                return NodeValue.makeDouble(Math.round(v.getDouble()));
            }
        }
        throw new ARQInternalErrorException("Unrecognized numeric operation : " + v);
    }

    public static NodeValue sqrt(NodeValue v) {
        switch (XSDFuncOp.classifyNumeric("sqrt", v)) {
            case OP_INTEGER: 
            case OP_DECIMAL: {
                double dec = v.getDecimal().doubleValue();
                return NodeValue.makeDecimal(Math.sqrt(dec));
            }
            case OP_FLOAT: {
                return NodeValue.makeDouble(Math.sqrt(v.getDouble()));
            }
            case OP_DOUBLE: {
                return NodeValue.makeDouble(Math.sqrt(v.getDouble()));
            }
        }
        throw new ARQInternalErrorException("Unrecognized numeric operation : " + v);
    }

    public static NodeValue stringLength(NodeValue str2) {
        return NodeValue.makeInteger(str2.getString().length());
    }

    public static NodeValue javaSubstring(NodeValue v1, NodeValue v2) {
        return XSDFuncOp.javaSubstring(v1, v2, null);
    }

    public static NodeValue javaSubstring(NodeValue nvString, NodeValue nvStart, NodeValue nvFinish) {
        try {
            String string = nvString.getString();
            int start = nvStart.getInteger().intValue();
            if (nvFinish == null) {
                return NodeValue.makeString(string.substring(start));
            }
            int finish = nvFinish.getInteger().intValue();
            return NodeValue.makeString(string.substring(start, finish));
        }
        catch (IndexOutOfBoundsException ex) {
            throw new ExprEvalException("IndexOutOfBounds", ex);
        }
    }

    public static NodeValue substring(NodeValue v1, NodeValue v2) {
        return XSDFuncOp.substring(v1, v2, null);
    }

    public static NodeValue substring(NodeValue nvString, NodeValue nvStart, NodeValue nvLength) {
        try {
            String string = nvString.getString();
            int start = XSDFuncOp.intValueStr(nvStart);
            if (start <= 0) {
                start = 1;
            }
            --start;
            if (nvLength == null) {
                return NodeValue.makeString(string.substring(start));
            }
            int length = XSDFuncOp.intValueStr(nvLength);
            int finish = start + length;
            if (finish > string.length()) {
                finish = string.length();
            }
            if (finish < 0) {
                finish = 0;
            }
            return NodeValue.makeString(string.substring(start, finish));
        }
        catch (IndexOutOfBoundsException ex) {
            throw new ExprEvalException("IndexOutOfBounds", ex);
        }
    }

    private static int intValueStr(NodeValue nv) {
        if (nv.isInteger()) {
            return nv.getInteger().intValue();
        }
        if (nv.isDecimal()) {
            return (int)Math.round(nv.getDecimal().doubleValue());
        }
        if (nv.isFloat()) {
            return Math.round(nv.getFloat());
        }
        if (nv.isDouble()) {
            return (int)Math.round(nv.getDouble());
        }
        throw new ExprEvalException("Not a number:" + nv);
    }

    public static NodeValue strContains(NodeValue string, NodeValue match) {
        XSDFuncOp.strCheck(string, match);
        boolean x = StringUtils.contains(string.getString(), match.getString());
        return NodeValue.booleanReturn(x);
    }

    public static NodeValue strStartsWith(NodeValue string, NodeValue match) {
        XSDFuncOp.strCheck(string, match);
        return NodeValue.booleanReturn(string.getString().startsWith(match.getString()));
    }

    public static NodeValue strEndsWith(NodeValue string, NodeValue match) {
        XSDFuncOp.strCheck(string, match);
        return NodeValue.booleanReturn(string.getString().endsWith(match.getString()));
    }

    public static NodeValue strLowerCase(NodeValue string) {
        XSDFuncOp.strCheck(string);
        return NodeValue.makeString(string.getString().toLowerCase());
    }

    public static NodeValue strUpperCase(NodeValue string) {
        XSDFuncOp.strCheck(string);
        return NodeValue.makeString(string.getString().toUpperCase());
    }

    private static void strCheck(NodeValue str2) {
        if (!str2.isString()) {
            throw new ExprEvalException("Not a string: " + str2);
        }
    }

    private static void strCheck(NodeValue str1, NodeValue str2) {
        if (!str1.isString()) {
            throw new ExprEvalException("Not a string (first arg): " + str1);
        }
        if (!str2.isString()) {
            throw new ExprEvalException("Not a string (second arg): " + str2);
        }
    }

    public static NumericType classifyNumeric(String fName, NodeValue nv1, NodeValue nv2) {
        if (!nv1.isNumber()) {
            throw new ExprEvalTypeException("Not a number (first arg to " + fName + "): " + nv1);
        }
        if (!nv2.isNumber()) {
            throw new ExprEvalTypeException("Not a number (second arg to " + fName + "): " + nv2);
        }
        if (nv1.isInteger()) {
            if (nv2.isInteger()) {
                return NumericType.OP_INTEGER;
            }
            if (nv2.isDecimal()) {
                return NumericType.OP_DECIMAL;
            }
            if (nv2.isFloat()) {
                return NumericType.OP_FLOAT;
            }
            if (nv2.isDouble()) {
                return NumericType.OP_DOUBLE;
            }
            throw new ARQInternalErrorException("Numeric op unrecognized (second arg to " + fName + "): " + nv2);
        }
        if (nv1.isDecimal()) {
            if (nv2.isDecimal()) {
                return NumericType.OP_DECIMAL;
            }
            if (nv2.isFloat()) {
                return NumericType.OP_FLOAT;
            }
            if (nv2.isDouble()) {
                return NumericType.OP_DOUBLE;
            }
            throw new ARQInternalErrorException("Numeric op unrecognized (second arg to " + fName + "): " + nv2);
        }
        if (nv1.isFloat()) {
            if (nv2.isFloat()) {
                return NumericType.OP_FLOAT;
            }
            if (nv2.isDouble()) {
                return NumericType.OP_DOUBLE;
            }
            throw new ARQInternalErrorException("Numeric op unrecognized (second arg to " + fName + "): " + nv2);
        }
        if (nv1.isDouble()) {
            if (nv2.isDouble()) {
                return NumericType.OP_DOUBLE;
            }
            throw new ARQInternalErrorException("Numeric op unrecognized (second arg to " + fName + "): " + nv2);
        }
        throw new ARQInternalErrorException("Numeric op unrecognized (first arg to " + fName + "): " + nv1);
    }

    public static NumericType classifyNumeric(String fName, NodeValue nv) {
        if (!nv.isNumber()) {
            throw new ExprEvalTypeException("Not a number: (" + fName + ") " + nv);
        }
        if (nv.isInteger()) {
            return NumericType.OP_INTEGER;
        }
        if (nv.isDecimal()) {
            return NumericType.OP_DECIMAL;
        }
        if (nv.isFloat()) {
            return NumericType.OP_FLOAT;
        }
        if (nv.isDouble()) {
            return NumericType.OP_DOUBLE;
        }
        throw new ARQInternalErrorException("Numeric op unrecognized (" + fName + "): " + nv);
    }

    private static int calcReturn(int x) {
        if (x < 0) {
            return -1;
        }
        if (x > 0) {
            return 1;
        }
        return 0;
    }

    public static int compareNumeric(NodeValue nv1, NodeValue nv2) {
        NumericType opType = XSDFuncOp.classifyNumeric("compareNumeric", nv1, nv2);
        switch (opType) {
            case OP_INTEGER: {
                return XSDFuncOp.calcReturn(nv1.getInteger().compareTo(nv2.getInteger()));
            }
            case OP_DECIMAL: {
                return XSDFuncOp.calcReturn(nv1.getDecimal().compareTo(nv2.getDecimal()));
            }
            case OP_FLOAT: {
                return XSDFuncOp.calcReturn(Float.compare(nv1.getFloat(), nv2.getFloat()));
            }
            case OP_DOUBLE: {
                return XSDFuncOp.calcReturn(Double.compare(nv1.getDouble(), nv2.getDouble()));
            }
        }
        throw new ARQInternalErrorException("Unrecognized numeric operation : (" + nv1 + " ," + nv2 + ")");
    }

    public static int compareString(NodeValue nv1, NodeValue nv2) {
        return XSDFuncOp.calcReturn(nv1.getString().compareTo(nv2.getString()));
    }

    public static int compareDateTime(NodeValue nv1, NodeValue nv2) {
        if (strictDateTimeFO) {
            return XSDFuncOp.compareDateTimeFO(nv1, nv2);
        }
        return XSDFuncOp.compareXSDDateTime(nv1.getDateTime(), nv2.getDateTime());
    }

    public static int compareDuration(NodeValue nv1, NodeValue nv2) {
        return XSDFuncOp.compareXSDDuration(nv1.getDuration(), nv2.getDuration());
    }

    public static int compareGYear(NodeValue nv1, NodeValue nv2) {
        return -99;
    }

    public static int compareGYearMonth(NodeValue nv1, NodeValue nv2) {
        return -99;
    }

    public static int compareGMonth(NodeValue nv1, NodeValue nv2) {
        return -99;
    }

    public static int compareGMonthDay(NodeValue nv1, NodeValue nv2) {
        return -99;
    }

    public static int compareGDay(NodeValue nv1, NodeValue nv2) {
        return -99;
    }

    private static int compareDateTimeFO(NodeValue nv1, NodeValue nv2) {
        XSDDateTime dt2;
        XSDDateTime dt1 = nv1.getDateTime();
        int x = XSDFuncOp.compareXSDDateTime(dt1, dt2 = nv2.getDateTime());
        if (x == 2) {
            NodeValue nv3 = XSDFuncOp.fixupDateTime(nv1);
            if (nv3 != null) {
                XSDDateTime dt3 = nv3.getDateTime();
                x = XSDFuncOp.compareXSDDateTime(dt3, dt2);
                if (x == 2) {
                    throw new ARQInternalErrorException("Still get indeterminate comparison");
                }
                return x;
            }
            nv3 = XSDFuncOp.fixupDateTime(nv2);
            if (nv3 != null) {
                XSDDateTime dt3 = nv3.getDateTime();
                x = XSDFuncOp.compareXSDDateTime(dt1, dt3);
                if (x == 2) {
                    throw new ARQInternalErrorException("Still get indeterminate comparison");
                }
                return x;
            }
            throw new ARQInternalErrorException("Failed to fixup dateTimes");
        }
        return x;
    }

    private static int compareDateFO(NodeValue nv1, NodeValue nv2) {
        XSDDateTime dt2;
        XSDDateTime dt1 = nv1.getDateTime();
        int x = XSDFuncOp.compareXSDDateTime(dt1, dt2 = nv2.getDateTime());
        if (x == 2) {
            NodeValue nv3 = XSDFuncOp.fixupDate(nv1);
            if (nv3 != null) {
                XSDDateTime dt3 = nv3.getDateTime();
                x = XSDFuncOp.compareXSDDateTime(dt3, dt2);
                if (x == 2) {
                    throw new ARQInternalErrorException("Still get indeterminate comparison");
                }
                return x;
            }
            nv3 = XSDFuncOp.fixupDate(nv2);
            if (nv3 != null) {
                XSDDateTime dt3 = nv3.getDateTime();
                x = XSDFuncOp.compareXSDDateTime(dt1, dt3);
                if (x == 2) {
                    throw new ARQInternalErrorException("Still get indeterminate comparison");
                }
                return x;
            }
            throw new ARQInternalErrorException("Failed to fixup dateTimes");
        }
        return x;
    }

    private static NodeValue fixupDateTime(NodeValue nv) {
        DateTimeStruct dts = DateTimeStruct.parseDateTime(nv.asNode().getLiteralLexicalForm());
        if (dts.timezone != null) {
            return null;
        }
        dts.timezone = defaultTimezone;
        nv = NodeValue.makeDateTime(dts.toString());
        if (!nv.isDateTime()) {
            throw new ARQInternalErrorException("Failed to reform an xsd:dateTime");
        }
        return nv;
    }

    private static NodeValue fixupDate(NodeValue nv) {
        DateTimeStruct dts = DateTimeStruct.parseDate(nv.asNode().getLiteralLexicalForm());
        if (dts.timezone != null) {
            return null;
        }
        dts.timezone = defaultTimezone;
        nv = NodeValue.makeDate(dts.toString());
        if (!nv.isDate()) {
            throw new ARQInternalErrorException("Failed to reform an xsd:date");
        }
        return nv;
    }

    private static int compareXSDDateTime(XSDDateTime dt1, XSDDateTime dt2) {
        int x = dt1.compare((AbstractDateTime)dt2);
        if (x == 0) {
            return 0;
        }
        if (x == -1) {
            return -1;
        }
        if (x == 1) {
            return 1;
        }
        if (x == 2) {
            return 2;
        }
        throw new ARQInternalErrorException("Unexpected return from XSDDateTime.compare: " + x);
    }

    private static int compareXSDDuration(XSDDuration duration1, XSDDuration duration2) {
        int x = duration1.compare((AbstractDateTime)duration2);
        if (x == 0) {
            return 0;
        }
        if (x == -1) {
            return -1;
        }
        if (x == 1) {
            return 1;
        }
        if (x == 2) {
            return 2;
        }
        throw new ARQInternalErrorException("Unexpected return from XSDDuration.compare: " + x);
    }

    public static int compareBoolean(NodeValue nv1, NodeValue nv2) {
        boolean b2;
        boolean b1 = nv1.getBoolean();
        if (b1 == (b2 = nv2.getBoolean())) {
            return 0;
        }
        if (!b1 && b2) {
            return -1;
        }
        if (b1 && !b2) {
            return 1;
        }
        throw new ARQInternalErrorException("Weird boolean comparison: " + nv1 + ", " + nv2);
    }

    public static boolean dateTimeCastCompatible(NodeValue nv, XSDDatatype xsd) {
        return nv.hasDateTime();
    }

    public static NodeValue dateTimeCast(NodeValue nv, String typeURI) {
        RDFDatatype t = Node.getType((String)typeURI);
        return XSDFuncOp.dateTimeCast(nv, t);
    }

    public static NodeValue dateTimeCast(NodeValue nv, RDFDatatype rdfDatatype) {
        if (!(rdfDatatype instanceof XSDDatatype)) {
            throw new ExprEvalTypeException("Can't cast to XSDDatatype: " + nv);
        }
        XSDDatatype xsd = (XSDDatatype)rdfDatatype;
        return XSDFuncOp.dateTimeCast(nv, xsd);
    }

    public static NodeValue dateTimeCast(NodeValue nv, XSDDatatype xsd) {
        if (!nv.hasDateTime()) {
            throw new ExprEvalTypeException("Not a date/time type: " + nv);
        }
        XSDDateTime xsdDT = nv.getDateTime();
        if (XSDDatatype.XSDdateTime.equals(xsd)) {
            if (nv.isDateTime()) {
                return nv;
            }
            if (!nv.isDate()) {
                throw new ExprEvalTypeException("Can't cast to XSD:dateTime: " + nv);
            }
            String x = String.format("%04d-%02d-%02dT00:00:00", xsdDT.getYears(), xsdDT.getMonths(), xsdDT.getDays());
            return NodeValue.makeNode(x, xsd);
        }
        if (XSDDatatype.XSDdate.equals(xsd)) {
            if (nv.isDate()) {
                return nv;
            }
            if (!nv.isDateTime()) {
                throw new ExprEvalTypeException("Can't cast to XSD:date: " + nv);
            }
            String x = String.format("%04d-%02d-%02d", xsdDT.getYears(), xsdDT.getMonths(), xsdDT.getDays());
            return NodeValue.makeNode(x, xsd);
        }
        if (XSDDatatype.XSDtime.equals(xsd)) {
            if (nv.isTime()) {
                return nv;
            }
            if (!nv.isDateTime()) {
                throw new ExprEvalTypeException("Can't cast to XSD:time: " + nv);
            }
            DecimalFormat nf = new DecimalFormat("00.####");
            nf.setDecimalSeparatorAlwaysShown(false);
            String x = nf.format(xsdDT.getSeconds());
            x = String.format("%02d:%02d:%s", xsdDT.getHours(), xsdDT.getMinutes(), x);
            return NodeValue.makeNode(x, xsd);
        }
        if (XSDDatatype.XSDgYear.equals(xsd)) {
            if (nv.isGYear()) {
                return nv;
            }
            if (!nv.isDateTime() && !nv.isDate()) {
                throw new ExprEvalTypeException("Can't cast to XSD:gYear: " + nv);
            }
            String x = String.format("%04d", xsdDT.getYears());
            return NodeValue.makeNode(x, xsd);
        }
        if (XSDDatatype.XSDgYearMonth.equals(xsd)) {
            if (nv.isGYearMonth()) {
                return nv;
            }
            if (!nv.isDateTime() && !nv.isDate()) {
                throw new ExprEvalTypeException("Can't cast to XSD:gYearMonth: " + nv);
            }
            String x = String.format("%04d-%02d", xsdDT.getYears(), xsdDT.getMonths());
            return NodeValue.makeNode(x, xsd);
        }
        if (XSDDatatype.XSDgMonth.equals(xsd)) {
            if (nv.isGMonth()) {
                return nv;
            }
            if (!nv.isDateTime() && !nv.isDate()) {
                throw new ExprEvalTypeException("Can't cast to XSD:gMonth: " + nv);
            }
            String x = String.format("--%02d", xsdDT.getMonths());
            return NodeValue.makeNode(x, xsd);
        }
        if (XSDDatatype.XSDgMonthDay.equals(xsd)) {
            if (nv.isGMonthDay()) {
                return nv;
            }
            if (!nv.isDateTime() && !nv.isDate()) {
                throw new ExprEvalTypeException("Can't cast to XSD:gMonthDay: " + nv);
            }
            String x = String.format("--%02d-%02d", xsdDT.getMonths(), xsdDT.getDays());
            return NodeValue.makeNode(x, xsd);
        }
        if (XSDDatatype.XSDgDay.equals(xsd)) {
            if (nv.isGDay()) {
                return nv;
            }
            if (!nv.isDateTime() && !nv.isDate()) {
                throw new ExprEvalTypeException("Can't cast to XSD:gDay: " + nv);
            }
            String x = String.format("---%02d", xsdDT.getDays());
            return NodeValue.makeNode(x, xsd);
        }
        throw new ExprEvalTypeException("Can't case to <" + xsd.getURI() + ">: " + nv);
    }
}

