/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.ExprFunction2;
import com.hp.hpl.jena.sparql.expr.NodeValue;

public class E_StrLang
extends ExprFunction2 {
    private static final String symbol = "strlang";

    public E_StrLang(Expr expr1, Expr expr2) {
        super(expr1, expr2, symbol);
    }

    public NodeValue eval(NodeValue v1, NodeValue v2) {
        if (!v1.isString()) {
            throw new ExprEvalException("Not a string (arg 1): " + v1);
        }
        if (!v2.isString()) {
            throw new ExprEvalException("Not a string (arg 2): " + v2);
        }
        String lex = v1.asString();
        String lang = v2.asString();
        Node n = Node.createLiteral((String)lex, (String)lang, null);
        return NodeValue.makeNode(n);
    }

    public Expr copy(Expr expr1, Expr expr2) {
        return new E_StrLang(expr1, expr2);
    }
}

