/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.core.ResultBinding;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetStream
implements ResultSet {
    private QueryIterator queryExecutionIter;
    private List<String> resultVars;
    private QuerySolution currentQuerySolution;
    private int rowNumber;
    private Model model;
    private boolean ordered = false;
    private boolean distinct = false;

    public ResultSetStream(List<String> resultVars, Model m, QueryIterator iter) {
        this.queryExecutionIter = iter;
        this.resultVars = resultVars;
        this.currentQuerySolution = null;
        this.rowNumber = 0;
        this.model = m;
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException(this.getClass().getName() + ".remove");
    }

    @Override
    public boolean hasNext() {
        if (this.queryExecutionIter == null) {
            return false;
        }
        boolean r = this.queryExecutionIter.hasNext();
        return r;
    }

    @Override
    public Binding nextBinding() {
        if (this.queryExecutionIter == null) {
            throw new NoSuchElementException(this.getClass() + ".next");
        }
        Binding binding = this.queryExecutionIter.nextBinding();
        if (binding != null) {
            ++this.rowNumber;
        }
        return binding;
    }

    @Override
    public QuerySolution nextSolution() {
        if (this.queryExecutionIter == null) {
            throw new NoSuchElementException(this.getClass() + ".next");
        }
        Binding binding = this.nextBinding();
        this.currentQuerySolution = new ResultBinding(this.model, binding);
        return this.currentQuerySolution;
    }

    @Override
    public QuerySolution next() {
        return this.nextSolution();
    }

    @Override
    public int getRowNumber() {
        return this.rowNumber;
    }

    @Override
    public List<String> getResultVars() {
        return this.resultVars;
    }

    public Model getModel() {
        return this.model;
    }

    @Override
    public Model getResourceModel() {
        return this.model;
    }
}

