/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.op;

import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVisitor;
import com.hp.hpl.jena.sparql.algebra.Transform;
import com.hp.hpl.jena.sparql.algebra.op.Op1;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.core.VarExprList;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.util.NodeIsomorphismMap;
import com.hp.hpl.jena.sparql.util.Utils;

public class OpAssign
extends Op1 {
    private VarExprList assignments;

    public static Op assign(Op op, Var var, Expr expr) {
        if (!(op instanceof OpAssign)) {
            return OpAssign.createAssign(op, var, expr);
        }
        OpAssign opAssign = (OpAssign)op;
        if (opAssign.assignments.contains(var)) {
            return OpAssign.createAssign(op, var, expr);
        }
        opAssign.assignments.add(var, expr);
        return opAssign;
    }

    public static Op assign(Op op, VarExprList exprs) {
        if (!(op instanceof OpAssign)) {
            return OpAssign.createAssign(op, exprs);
        }
        OpAssign opAssign = (OpAssign)op;
        for (Var var : exprs.getVars()) {
            if (!opAssign.assignments.contains(var)) continue;
            return OpAssign.createAssign(op, exprs);
        }
        opAssign.assignments.addAll(exprs);
        return opAssign;
    }

    private static Op createAssign(Op op, Var var, Expr expr) {
        VarExprList x = new VarExprList();
        x.add(var, expr);
        return new OpAssign(op, x);
    }

    private static Op createAssign(Op op, VarExprList exprs) {
        VarExprList x = new VarExprList();
        x.addAll(exprs);
        return new OpAssign(op, x);
    }

    private OpAssign(Op subOp) {
        super(subOp);
        this.assignments = new VarExprList();
    }

    private OpAssign(Op subOp, VarExprList exprs) {
        super(subOp);
        this.assignments = exprs;
    }

    public String getName() {
        return "assign";
    }

    private void add(Var var, Expr expr) {
        this.assignments.add(var, expr);
    }

    public VarExprList getVarExprList() {
        return this.assignments;
    }

    public int hashCode() {
        return this.assignments.hashCode() ^ this.getSubOp().hashCode();
    }

    public void visit(OpVisitor opVisitor) {
        opVisitor.visit(this);
    }

    public Op copy(Op subOp) {
        OpAssign op = new OpAssign(subOp, new VarExprList(this.getVarExprList()));
        return op;
    }

    public boolean equalTo(Op other, NodeIsomorphismMap labelMap) {
        if (!(other instanceof OpAssign)) {
            return false;
        }
        OpAssign assign2 = (OpAssign)other;
        if (!Utils.equal(this.assignments, assign2.assignments)) {
            return false;
        }
        return this.getSubOp().equalTo(assign2.getSubOp(), labelMap);
    }

    public Op apply(Transform transform, Op subOp) {
        return transform.transform(this, subOp);
    }
}

