/*
 * Decompiled with CFR 0.152.
 */
package arq.cmdline;

import arq.cmd.CmdException;
import arq.cmdline.ArgDecl;
import arq.cmdline.CmdArgModule;
import arq.cmdline.CmdGeneral;
import arq.cmdline.ModBase;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.NotFoundException;
import com.hp.hpl.jena.sparql.ARQException;
import com.hp.hpl.jena.sparql.core.assembler.AssemblerUtils;

public class ModAssembler
extends ModBase {
    protected final ArgDecl assemblerDescDecl = new ArgDecl(true, "desc", "dataset");
    private String assemblerFile = null;
    Object thingDescribed = null;

    public ModAssembler() {
        AssemblerUtils.init();
    }

    public void processArgs(CmdArgModule cmdLine) {
        if (cmdLine.contains(this.assemblerDescDecl)) {
            this.assemblerFile = cmdLine.getValue(this.assemblerDescDecl);
        }
    }

    public void registerWith(CmdGeneral cmdLine) {
        cmdLine.add(this.assemblerDescDecl, "--desc=", "Assembler description file");
    }

    public String getAssemblerFile() {
        return this.assemblerFile;
    }

    public Object create(Resource type) {
        Object thing = null;
        try {
            thing = AssemblerUtils.build(this.assemblerFile, type);
        }
        catch (ARQException ex) {
            throw ex;
        }
        catch (NotFoundException ex) {
            throw new CmdException("Not found: " + ex.getMessage());
        }
        catch (JenaException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CmdException("Error creating", ex);
        }
        return thing;
    }
}

