/*
 * Decompiled with CFR 0.152.
 */
package wei.mark.standout;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.util.Log;
import android.view.Display;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import wei.mark.standout.R;
import wei.mark.standout.Utils;
import wei.mark.standout.WindowCache;
import wei.mark.standout.constants.StandOutFlags;
import wei.mark.standout.ui.Window;

public abstract class StandOutWindow
extends Service {
    static final String TAG = "StandOutWindow";
    public static final int DEFAULT_ID = 0;
    public static final int ONGOING_NOTIFICATION_ID = -1;
    public static final int DISREGARD_ID = -2;
    public static final String ACTION_SHOW = "SHOW";
    public static final String ACTION_RESTORE = "RESTORE";
    public static final String ACTION_CLOSE = "CLOSE";
    public static final String ACTION_CLOSE_ALL = "CLOSE_ALL";
    public static final String ACTION_SEND_DATA = "SEND_DATA";
    public static final String ACTION_HIDE = "HIDE";
    static WindowCache sWindowCache = new WindowCache();
    static Window sFocusedWindow = null;
    WindowManager mWindowManager;
    private NotificationManager mNotificationManager;
    LayoutInflater mLayoutInflater;
    private boolean startedForeground;
    static Integer WINDOW_TYPE = null;

    public static void show(Context context, Class<? extends StandOutWindow> cls, int id2) {
        context.startService(StandOutWindow.getShowIntent(context, cls, id2));
    }

    public static void hide(Context context, Class<? extends StandOutWindow> cls, int id2) {
        context.startService(StandOutWindow.getShowIntent(context, cls, id2));
    }

    public static void close(Context context, Class<? extends StandOutWindow> cls, int id2) {
        context.startService(StandOutWindow.getCloseIntent(context, cls, id2));
    }

    public static void closeAll(Context context, Class<? extends StandOutWindow> cls) {
        context.startService(StandOutWindow.getCloseAllIntent(context, cls));
    }

    public static void sendData(Context context, Class<? extends StandOutWindow> toCls, int toId, int requestCode, Bundle data, Class<? extends StandOutWindow> fromCls, int fromId) {
        context.startService(StandOutWindow.getSendDataIntent(context, toCls, toId, requestCode, data, fromCls, fromId));
    }

    public static Intent getShowIntent(Context context, Class<? extends StandOutWindow> cls, int id2) {
        boolean cached = sWindowCache.isCached(id2, cls);
        String action = cached ? ACTION_RESTORE : ACTION_SHOW;
        Uri uri = cached ? Uri.parse((String)("standout://" + cls + '/' + id2)) : null;
        return new Intent(context, cls).putExtra("id", id2).setAction(action).setData(uri);
    }

    public static Intent getHideIntent(Context context, Class<? extends StandOutWindow> cls, int id2) {
        return new Intent(context, cls).putExtra("id", id2).setAction(ACTION_HIDE);
    }

    public static Intent getCloseIntent(Context context, Class<? extends StandOutWindow> cls, int id2) {
        return new Intent(context, cls).putExtra("id", id2).setAction(ACTION_CLOSE);
    }

    public static Intent getCloseAllIntent(Context context, Class<? extends StandOutWindow> cls) {
        return new Intent(context, cls).setAction(ACTION_CLOSE_ALL);
    }

    public static Intent getSendDataIntent(Context context, Class<? extends StandOutWindow> toCls, int toId, int requestCode, Bundle data, Class<? extends StandOutWindow> fromCls, int fromId) {
        return new Intent(context, toCls).putExtra("id", toId).putExtra("requestCode", requestCode).putExtra("wei.mark.standout.data", data).putExtra("wei.mark.standout.fromCls", fromCls).putExtra("fromId", fromId).setAction(ACTION_SEND_DATA);
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    public void onCreate() {
        super.onCreate();
        this.mWindowManager = (WindowManager)this.getSystemService("window");
        this.mNotificationManager = (NotificationManager)this.getSystemService("notification");
        this.mLayoutInflater = (LayoutInflater)this.getSystemService("layout_inflater");
        this.startedForeground = false;
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        super.onStartCommand(intent, flags, startId);
        if (intent != null) {
            String action = intent.getAction();
            int id2 = intent.getIntExtra("id", 0);
            if (id2 == -1) {
                Log.w((String)TAG, (String)"ID cannot equals StandOutWindow.ONGOING_NOTIFICATION_ID");
                return 2;
            }
            if (ACTION_SHOW.equals(action) || ACTION_RESTORE.equals(action)) {
                this.show(id2);
            } else if (ACTION_HIDE.equals(action)) {
                this.hide(id2);
            } else if (ACTION_CLOSE.equals(action)) {
                this.close(id2);
            } else if (ACTION_CLOSE_ALL.equals(action)) {
                this.closeAll();
            } else if (ACTION_SEND_DATA.equals(action)) {
                if (!this.isExistingId(id2) && id2 != -2) {
                    Log.w((String)TAG, (String)"Sending data to non-existant window. If this is not intended, make sure toId is either an existing window's id or DISREGARD_ID.");
                }
                Bundle data = intent.getBundleExtra("wei.mark.standout.data");
                int requestCode = intent.getIntExtra("requestCode", 0);
                Class fromCls = (Class)intent.getSerializableExtra("wei.mark.standout.fromCls");
                int fromId = intent.getIntExtra("fromId", 0);
                this.onReceiveData(id2, requestCode, data, fromCls, fromId);
            }
        } else {
            Log.w((String)TAG, (String)"Tried to onStartCommand() with a null intent.");
        }
        return 2;
    }

    public void onDestroy() {
        super.onDestroy();
        this.closeAll();
    }

    public abstract String getAppName();

    public abstract int getAppIcon();

    public abstract void createAndAttachView(int var1, FrameLayout var2);

    public abstract StandOutLayoutParams getParams(int var1, Window var2);

    public int getFlags(int id2) {
        return 0;
    }

    public String getTitle(int id2) {
        return this.getAppName();
    }

    public int getIcon(int id2) {
        return this.getAppIcon();
    }

    public String getPersistentNotificationTitle(int id2) {
        return this.getAppName() + " Running";
    }

    public String getPersistentNotificationMessage(int id2) {
        return "";
    }

    public Intent getPersistentNotificationIntent(int id2) {
        return null;
    }

    public int getHiddenIcon() {
        return this.getAppIcon();
    }

    public String getHiddenNotificationTitle(int id2) {
        return this.getAppName() + " Hidden";
    }

    public String getHiddenNotificationMessage(int id2) {
        return "";
    }

    public Intent getHiddenNotificationIntent(int id2) {
        return null;
    }

    public Notification getPersistentNotification(int id2) {
        int icon = this.getAppIcon();
        long when = System.currentTimeMillis();
        Context c = this.getApplicationContext();
        String contentTitle = this.getPersistentNotificationTitle(id2);
        String contentText = this.getPersistentNotificationMessage(id2);
        String tickerText = String.format("%s: %s", contentTitle, contentText);
        Intent notificationIntent = this.getPersistentNotificationIntent(id2);
        PendingIntent contentIntent = null;
        if (notificationIntent != null) {
            contentIntent = PendingIntent.getService((Context)this, (int)0, (Intent)notificationIntent, (int)0x8000000);
        }
        Notification.Builder builder = new Notification.Builder(c);
        builder.setSmallIcon(icon).setTicker((CharSequence)tickerText).setWhen(when).setContentTitle((CharSequence)contentTitle).setContentText((CharSequence)contentText).setContentIntent(contentIntent);
        return builder.build();
    }

    public Notification getHiddenNotification(int id2) {
        int icon = this.getHiddenIcon();
        long when = System.currentTimeMillis();
        Context c = this.getApplicationContext();
        String contentTitle = this.getHiddenNotificationTitle(id2);
        String contentText = this.getHiddenNotificationMessage(id2);
        String tickerText = String.format("%s: %s", contentTitle, contentText);
        Intent notificationIntent = this.getHiddenNotificationIntent(id2);
        PendingIntent contentIntent = null;
        if (notificationIntent != null) {
            contentIntent = PendingIntent.getService((Context)this, (int)0, (Intent)notificationIntent, (int)0x8000000);
        }
        Notification.Builder builder = new Notification.Builder(c);
        builder.setSmallIcon(icon).setTicker((CharSequence)tickerText).setWhen(when).setContentTitle((CharSequence)contentTitle).setContentText((CharSequence)contentText).setContentIntent(contentIntent);
        return builder.build();
    }

    public Animation getShowAnimation(int id2) {
        return AnimationUtils.loadAnimation((Context)this, (int)0x10A0000);
    }

    public Animation getHideAnimation(int id2) {
        return AnimationUtils.loadAnimation((Context)this, (int)0x10A0001);
    }

    public Animation getCloseAnimation(int id2) {
        return AnimationUtils.loadAnimation((Context)this, (int)0x10A0001);
    }

    public int getThemeStyle() {
        return 0;
    }

    public PopupWindow getDropDown(int id2) {
        List<DropDownListItem> dropDownListItems = this.getDropDownItems(id2);
        List<DropDownListItem> items = dropDownListItems != null ? dropDownListItems : new ArrayList<DropDownListItem>();
        if (items.size() == 0) {
            items.add(new DropDownListItem(17301560, "Quit " + this.getAppName(), new Runnable(){

                @Override
                public void run() {
                    StandOutWindow.this.closeAll();
                }
            }));
        }
        LinearLayout list = new LinearLayout((Context)this);
        list.setOrientation(1);
        final PopupWindow dropDown = new PopupWindow((View)list, -2, -2, true);
        for (final DropDownListItem item : items) {
            ViewGroup listItem = (ViewGroup)this.mLayoutInflater.inflate(R.layout.drop_down_list_item, null);
            list.addView((View)listItem);
            ImageView icon = (ImageView)listItem.findViewById(R.id.icon);
            icon.setImageResource(item.icon);
            TextView description = (TextView)listItem.findViewById(R.id.description);
            description.setText((CharSequence)item.description);
            listItem.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    item.action.run();
                    dropDown.dismiss();
                }
            });
        }
        Drawable background = this.getResources().getDrawable(17301531);
        dropDown.setBackgroundDrawable(background);
        return dropDown;
    }

    public List<DropDownListItem> getDropDownItems(int id2) {
        return null;
    }

    public boolean onTouchBody(int id2, Window window, View view, MotionEvent event) {
        return false;
    }

    public void onMove(int id2, Window window, View view, MotionEvent event) {
    }

    public void onResize(int id2, Window window, View view, MotionEvent event) {
    }

    public boolean onShow(int id2, Window window) {
        return false;
    }

    public boolean onHide(int id2, Window window) {
        return false;
    }

    public boolean onClose(int id2, Window window) {
        return false;
    }

    public boolean onCloseAll() {
        return false;
    }

    public void onReceiveData(int id2, int requestCode, Bundle data, Class<? extends StandOutWindow> fromCls, int fromId) {
    }

    public boolean onUpdate(int id2, Window window, StandOutLayoutParams params) {
        return false;
    }

    public boolean onBringToFront(int id2, Window window) {
        return false;
    }

    public boolean onFocusChange(int id2, Window window, boolean focus) {
        return false;
    }

    public boolean onKeyEvent(int id2, Window window, KeyEvent event) {
        return false;
    }

    public synchronized Window show(int id2) {
        Window cachedWindow = this.getWindow(id2);
        Window window = cachedWindow != null ? cachedWindow : new Window(this, id2);
        if (window.visibility == 1) {
            Log.w((String)TAG, (String)("Tried to show(" + id2 + ") a window that is already shown."));
        }
        if (this.onShow(id2, window)) {
            Log.d((String)TAG, (String)("Window " + id2 + " show cancelled by implementation."));
            return null;
        }
        window.visibility = 1;
        Animation animation = this.getShowAnimation(id2);
        StandOutLayoutParams params = window.getLayoutParams();
        try {
            this.mWindowManager.addView((View)window, (ViewGroup.LayoutParams)params);
            if (animation != null) {
                window.getChildAt(0).startAnimation(animation);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        sWindowCache.putCache(id2, ((Object)((Object)this)).getClass(), window);
        Notification notification = this.getPersistentNotification(id2);
        if (notification != null) {
            notification.flags |= 0x20;
            if (!this.startedForeground) {
                this.startForeground(((Object)((Object)this)).getClass().hashCode() + -1, notification);
                this.startedForeground = true;
            } else {
                this.mNotificationManager.notify(((Object)((Object)this)).getClass().hashCode() + -1, notification);
            }
        } else if (!this.startedForeground) {
            Log.w((String)TAG, (String)"Your StandOutWindow service mustprovide a persistent notification.The notification prevents Androidfrom killing your service in lowmemory situations.");
        }
        this.focus(id2);
        return window;
    }

    public final synchronized void hide(int id2) {
        final Window window = this.getWindow(id2);
        if (window == null) {
            Log.w((String)TAG, (String)("Tried to hide(" + id2 + ") a null window."));
            return;
        }
        if (window.visibility == 0) {
            throw new IllegalStateException("Tried to hide(" + id2 + ") a window that is not shown.");
        }
        if (this.onHide(id2, window)) {
            Log.w((String)TAG, (String)("Window " + id2 + " hide cancelled by implementation."));
            return;
        }
        if (Utils.isSet(window.flags, StandOutFlags.FLAG_WINDOW_HIDE_ENABLE)) {
            window.visibility = 2;
            Notification notification = this.getHiddenNotification(id2);
            Animation animation = this.getHideAnimation(id2);
            try {
                if (animation != null) {
                    animation.setAnimationListener(new Animation.AnimationListener(){

                        public void onAnimationStart(Animation animation) {
                        }

                        public void onAnimationRepeat(Animation animation) {
                        }

                        public void onAnimationEnd(Animation animation) {
                            StandOutWindow.this.mWindowManager.removeView((View)window);
                            window.visibility = 0;
                        }
                    });
                    window.getChildAt(0).startAnimation(animation);
                } else {
                    this.mWindowManager.removeView((View)window);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            notification.flags = notification.flags | 0x20 | 0x10;
            this.mNotificationManager.notify(((Object)((Object)this)).getClass().hashCode() + id2, notification);
        } else {
            this.close(id2);
        }
    }

    public final synchronized void close(final int id2) {
        final Window window = this.getWindow(id2);
        if (window == null) {
            Log.w((String)TAG, (String)("Tried to close(" + id2 + ") a null window."));
            return;
        }
        if (window.visibility == 2) {
            return;
        }
        if (this.onClose(id2, window)) {
            Log.w((String)TAG, (String)("Window " + id2 + " close cancelled by implementation."));
            return;
        }
        this.mNotificationManager.cancel(((Object)((Object)this)).getClass().hashCode() + id2);
        this.unfocus(window);
        window.visibility = 2;
        Animation animation = this.getCloseAnimation(id2);
        try {
            if (animation != null) {
                animation.setAnimationListener(new Animation.AnimationListener(){

                    public void onAnimationStart(Animation animation) {
                    }

                    public void onAnimationRepeat(Animation animation) {
                    }

                    public void onAnimationEnd(Animation animation) {
                        StandOutWindow.this.mWindowManager.removeView((View)window);
                        window.visibility = 0;
                        sWindowCache.removeCache(id2, ((Object)((Object)StandOutWindow.this)).getClass());
                        if (StandOutWindow.this.getExistingIds().size() == 0) {
                            StandOutWindow.this.startedForeground = false;
                            StandOutWindow.this.stopForeground(true);
                        }
                    }
                });
                window.getChildAt(0).startAnimation(animation);
            } else {
                this.mWindowManager.removeView((View)window);
                sWindowCache.removeCache(id2, ((Object)((Object)this)).getClass());
                if (sWindowCache.getCacheSize(((Object)((Object)this)).getClass()) == 0) {
                    this.startedForeground = false;
                    this.stopForeground(true);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public final synchronized void closeAll() {
        if (this.onCloseAll()) {
            Log.w((String)TAG, (String)"Windows close all cancelled by implementation.");
            return;
        }
        LinkedList<Integer> ids = new LinkedList<Integer>();
        for (int id2 : this.getExistingIds()) {
            ids.add(id2);
        }
        for (int id2 : ids) {
            this.close(id2);
        }
    }

    public final void sendData(int fromId, Class<? extends StandOutWindow> toCls, int toId, int requestCode, Bundle data) {
        StandOutWindow.sendData((Context)this, toCls, toId, requestCode, data, ((Object)((Object)this)).getClass(), fromId);
    }

    public final synchronized void bringToFront(int id2) {
        Window window = this.getWindow(id2);
        if (window == null) {
            Log.w((String)TAG, (String)("Tried to bringToFront(" + id2 + ") a null window."));
            return;
        }
        if (window.visibility == 0) {
            throw new IllegalStateException("Tried to bringToFront(" + id2 + ") a window that is not shown.");
        }
        if (window.visibility == 2) {
            return;
        }
        if (this.onBringToFront(id2, window)) {
            Log.w((String)TAG, (String)("Window " + id2 + " bring to front cancelled by implementation."));
            return;
        }
        StandOutLayoutParams params = window.getLayoutParams();
        try {
            this.mWindowManager.removeView((View)window);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            this.mWindowManager.addView((View)window, (ViewGroup.LayoutParams)params);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public synchronized boolean focus(int id2) {
        Window window = this.getWindow(id2);
        if (window == null) {
            return false;
        }
        if (!Utils.isSet(window.flags, StandOutFlags.FLAG_WINDOW_FOCUSABLE_DISABLE)) {
            if (sFocusedWindow != null) {
                this.unfocus(sFocusedWindow);
            }
            return window.onFocus(true);
        }
        return false;
    }

    public final synchronized boolean unfocus(int id2) {
        Window window = this.getWindow(id2);
        return this.unfocus(window);
    }

    public final int getUniqueId() {
        int unique = 0;
        for (int id2 : this.getExistingIds()) {
            unique = Math.max(unique, id2 + 1);
        }
        return unique;
    }

    public final boolean isExistingId(int id2) {
        return sWindowCache.isCached(id2, ((Object)((Object)this)).getClass());
    }

    public final Set<Integer> getExistingIds() {
        return sWindowCache.getCacheIds(((Object)((Object)this)).getClass());
    }

    public final Window getWindow(int id2) {
        return sWindowCache.getCache(id2, ((Object)((Object)this)).getClass());
    }

    public final Window getFocusedWindow() {
        return sFocusedWindow;
    }

    public final void setFocusedWindow(Window window) {
        sFocusedWindow = window;
    }

    public final void setTitle(int id2, String text) {
        View title;
        Window window = this.getWindow(id2);
        if (window != null && (title = window.findViewById(R.id.title)) instanceof TextView) {
            ((TextView)title).setText((CharSequence)text);
        }
    }

    public final void setIcon(int id2, int drawableRes) {
        View icon;
        Window window = this.getWindow(id2);
        if (window != null && (icon = window.findViewById(R.id.window_icon)) instanceof ImageView) {
            ((ImageView)icon).setImageResource(drawableRes);
        }
    }

    public boolean onTouchHandleMove(int id2, Window window, View view, MotionEvent event) {
        StandOutLayoutParams params = window.getLayoutParams();
        int totalDeltaX = window.touchInfo.lastX - window.touchInfo.firstX;
        int totalDeltaY = window.touchInfo.lastY - window.touchInfo.firstY;
        switch (event.getAction()) {
            case 0: {
                window.touchInfo.lastX = (int)event.getRawX();
                window.touchInfo.lastY = (int)event.getRawY();
                window.touchInfo.firstX = window.touchInfo.lastX;
                window.touchInfo.firstY = window.touchInfo.lastY;
                break;
            }
            case 2: {
                int deltaX = (int)event.getRawX() - window.touchInfo.lastX;
                int deltaY = (int)event.getRawY() - window.touchInfo.lastY;
                window.touchInfo.lastX = (int)event.getRawX();
                window.touchInfo.lastY = (int)event.getRawY();
                if (!window.touchInfo.moving && Math.abs(totalDeltaX) < params.threshold && Math.abs(totalDeltaY) < params.threshold) break;
                window.touchInfo.moving = true;
                if (!Utils.isSet(window.flags, StandOutFlags.FLAG_BODY_MOVE_ENABLE)) break;
                if (event.getPointerCount() == 1) {
                    params.x += deltaX;
                    params.y += deltaY;
                }
                window.edit().setPosition(params.x, params.y).commit();
                break;
            }
            case 1: {
                window.touchInfo.moving = false;
                if (event.getPointerCount() == 1) {
                    boolean tap;
                    boolean bl = tap = Math.abs(totalDeltaX) < params.threshold && Math.abs(totalDeltaY) < params.threshold;
                    if (!tap || !Utils.isSet(window.flags, StandOutFlags.FLAG_WINDOW_BRING_TO_FRONT_ON_TAP)) break;
                    this.bringToFront(id2);
                    break;
                }
                if (!Utils.isSet(window.flags, StandOutFlags.FLAG_WINDOW_BRING_TO_FRONT_ON_TOUCH)) break;
                this.bringToFront(id2);
            }
        }
        this.onMove(id2, window, view, event);
        return true;
    }

    public boolean onTouchHandleResize(int id2, Window window, View view, MotionEvent event) {
        StandOutLayoutParams params = window.getLayoutParams();
        switch (event.getAction()) {
            case 0: {
                window.touchInfo.lastX = (int)event.getRawX();
                window.touchInfo.lastY = (int)event.getRawY();
                window.touchInfo.firstX = window.touchInfo.lastX;
                window.touchInfo.firstY = window.touchInfo.lastY;
                break;
            }
            case 2: {
                int deltaX = (int)event.getRawX() - window.touchInfo.lastX;
                int deltaY = (int)event.getRawY() - window.touchInfo.lastY;
                params.width += deltaX;
                params.height += deltaY;
                if (params.width >= params.minWidth && params.width <= params.maxWidth) {
                    window.touchInfo.lastX = (int)event.getRawX();
                }
                if (params.height >= params.minHeight && params.height <= params.maxHeight) {
                    window.touchInfo.lastY = (int)event.getRawY();
                }
                if (params.width < 1 || params.height < 1) break;
                window.edit().setSize(params.width, params.height).commit();
                break;
            }
        }
        this.onResize(id2, window, view, event);
        return true;
    }

    public synchronized boolean unfocus(Window window) {
        if (window == null) {
            Log.w((String)TAG, (String)"Tried to unfocus a null window.");
            return false;
        }
        return window.onFocus(false);
    }

    public void updateViewLayout(int id2, StandOutLayoutParams params) {
        Window window = this.getWindow(id2);
        if (window == null) {
            Log.w((String)TAG, (String)("Tried to updateViewLayout(" + id2 + ") a null window."));
            return;
        }
        if (window.visibility == 0) {
            return;
        }
        if (window.visibility == 2) {
            return;
        }
        if (this.onUpdate(id2, window, params)) {
            Log.w((String)TAG, (String)("Window " + id2 + " update cancelled by implementation."));
            return;
        }
        try {
            window.setLayoutParams((ViewGroup.LayoutParams)params);
            this.mWindowManager.updateViewLayout((View)window, (ViewGroup.LayoutParams)params);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    int getWindowType() {
        if (WINDOW_TYPE == null) {
            try {
                ApplicationInfo applicationInfo = this.getApplicationInfo();
                if (applicationInfo != null) {
                    WINDOW_TYPE = applicationInfo.targetSdkVersion >= 26 ? 2038 : 2003;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                WINDOW_TYPE = 2003;
            }
        }
        return WINDOW_TYPE;
    }

    protected class DropDownListItem {
        public int icon;
        public String description;
        public Runnable action;

        public DropDownListItem(int icon, String description, Runnable action) {
            this.icon = icon;
            this.description = description;
            this.action = action;
        }

        public String toString() {
            return this.description;
        }
    }

    public class StandOutLayoutParams
    extends WindowManager.LayoutParams {
        public static final int LEFT = 0;
        public static final int TOP = 0;
        public static final int RIGHT = Integer.MAX_VALUE;
        public static final int BOTTOM = Integer.MAX_VALUE;
        public static final int CENTER = Integer.MIN_VALUE;
        public static final int AUTO_POSITION = -2147483647;
        public int threshold;
        public int minWidth;
        public int minHeight;
        public int maxWidth;
        public int maxHeight;

        public StandOutLayoutParams(int id2) {
            super(200, 200, StandOutWindow.this.getWindowType(), 262176, -3);
            int windowFlags = StandOutWindow.this.getFlags(id2);
            this.setFocusFlag(false);
            if (!Utils.isSet(windowFlags, StandOutFlags.FLAG_WINDOW_EDGE_LIMITS_ENABLE)) {
                this.flags |= 0x200;
            }
            this.x = this.getX(id2, this.width);
            this.y = this.getY(id2, this.height);
            this.gravity = 51;
            this.threshold = 10;
            this.minHeight = 0;
            this.minWidth = 0;
            this.maxHeight = Integer.MAX_VALUE;
            this.maxWidth = Integer.MAX_VALUE;
        }

        public StandOutLayoutParams(int id2, int w, int h) {
            this(id2);
            this.width = w;
            this.height = h;
        }

        public StandOutLayoutParams(int id2, int w, int h, int xpos, int ypos) {
            this(id2, w, h);
            if (xpos != -2147483647) {
                this.x = xpos;
            }
            if (ypos != -2147483647) {
                this.y = ypos;
            }
            Display display = this$0.mWindowManager.getDefaultDisplay();
            int width = display.getWidth();
            int height = display.getHeight();
            if (this.x == Integer.MAX_VALUE) {
                this.x = width - w;
            } else if (this.x == Integer.MIN_VALUE) {
                this.x = (width - w) / 2;
            }
            if (this.y == Integer.MAX_VALUE) {
                this.y = height - h;
            } else if (this.y == Integer.MIN_VALUE) {
                this.y = (height - h) / 2;
            }
        }

        public StandOutLayoutParams(int id2, int w, int h, int xpos, int ypos, int minWidth, int minHeight) {
            this(id2, w, h, xpos, ypos);
            this.minWidth = minWidth;
            this.minHeight = minHeight;
        }

        public StandOutLayoutParams(int id2, int w, int h, int xpos, int ypos, int minWidth, int minHeight, int threshold) {
            this(id2, w, h, xpos, ypos, minWidth, minHeight);
            this.threshold = threshold;
        }

        private int getX(int id2, int width) {
            Display display = StandOutWindow.this.mWindowManager.getDefaultDisplay();
            int displayWidth = display.getWidth();
            int types = sWindowCache.size();
            int initialX = 100 * types;
            int variableX = 100 * id2;
            int rawX = initialX + variableX;
            return rawX % (displayWidth - width);
        }

        private int getY(int id2, int height) {
            Display display = StandOutWindow.this.mWindowManager.getDefaultDisplay();
            int displayWidth = display.getWidth();
            int displayHeight = display.getHeight();
            int types = sWindowCache.size();
            int initialY = 100 * types;
            int variableY = this.x + 200 * (100 * id2) / (displayWidth - this.width);
            int rawY = initialY + variableY;
            return rawY % (displayHeight - height);
        }

        public void setFocusFlag(boolean focused) {
            this.flags = focused ? (this.flags ^= 8) : (this.flags |= 8);
        }
    }
}

