/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.road.schema.validation;

import com.hotels.jasvorno.schema.SchemaValidationException;
import com.hotels.jasvorno.schema.SchemaValidator;
import com.hotels.road.schema.SchemaTraverser;
import com.hotels.road.schema.gdpr.PiiVisitor;
import com.hotels.road.schema.validation.LogicalTypeValidatingVisitor;
import com.hotels.road.schema.validation.NonNullableUnionValidatingVisitor;
import org.apache.avro.Schema;

public final class DataHighwaySchemaValidator {
    static final String PARTITION_COLUMN_NAME = "acquisition_instant";

    private DataHighwaySchemaValidator() {
    }

    public static boolean isValid(Schema schema, UnionRule unionRule) {
        try {
            DataHighwaySchemaValidator.validate(schema, unionRule);
        }
        catch (SchemaValidationException e) {
            return false;
        }
        return true;
    }

    public static void validate(Schema schema, UnionRule unionRule) throws SchemaValidationException {
        DataHighwaySchemaValidator.validateIsRecord(schema);
        DataHighwaySchemaValidator.validateDoesNotContainReservedColumnName(schema);
        DataHighwaySchemaValidator.validateObfuscationAnnotations(schema);
        DataHighwaySchemaValidator.validateLogicalTypes(schema);
        SchemaValidator.validate((Schema)schema);
        if (UnionRule.DISALLOW_NON_NULLABLE_UNIONS == unionRule) {
            DataHighwaySchemaValidator.validateNonNullableUnions(schema);
        }
    }

    private static void validateIsRecord(Schema schema) throws SchemaValidationException {
        if (schema.getType() != Schema.Type.RECORD) {
            throw new SchemaValidationException(String.format("Unexpected schema root type '%s', expected '%s'", schema.getType(), Schema.Type.RECORD));
        }
    }

    private static void validateDoesNotContainReservedColumnName(Schema schema) throws SchemaValidationException {
        for (Schema.Field field : schema.getFields()) {
            if (PARTITION_COLUMN_NAME.equalsIgnoreCase(field.name())) {
                throw new SchemaValidationException(String.format("Field name '%s' is reserved", field.name()));
            }
            for (String alias : field.aliases()) {
                if (!PARTITION_COLUMN_NAME.equalsIgnoreCase(alias)) continue;
                throw new SchemaValidationException(String.format("Field name '%s' is reserved", alias));
            }
        }
    }

    private static void validateObfuscationAnnotations(Schema schema) throws SchemaValidationException {
        SchemaTraverser.traverse(schema, new PiiVisitor());
    }

    private static void validateLogicalTypes(Schema schema) throws SchemaValidationException {
        SchemaTraverser.traverse(schema, new LogicalTypeValidatingVisitor());
    }

    private static void validateNonNullableUnions(Schema schema) throws SchemaValidationException {
        SchemaTraverser.traverse(schema, new NonNullableUnionValidatingVisitor());
    }

    public static enum UnionRule {
        ALLOW_NON_NULLABLE_UNIONS,
        DISALLOW_NON_NULLABLE_UNIONS;

    }
}

