/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.road.schema.gdpr;

import com.hotels.road.schema.SchemaTraverser;
import com.hotels.road.schema.gdpr.InvalidPiiAnnotationException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.avro.Schema;

public class PiiVisitor<T>
implements SchemaTraverser.Visitor<T> {
    public static final String SENSITIVITY = "sensitivity";
    public static final String PII = "PII";

    @Override
    public void onVisit(Schema schema, Collection<String> breadcrumb) {
        if (PII.equalsIgnoreCase(schema.getProp(SENSITIVITY))) {
            throw new InvalidPiiAnnotationException(breadcrumb);
        }
    }

    @Override
    public void onVisit(Schema.Field field, Collection<String> breadcrumb) {
        if (PII.equalsIgnoreCase(field.getProp(SENSITIVITY))) {
            Schema schema = field.schema();
            if (!PiiVisitor.isStringOrBytes(schema) && !PiiVisitor.isNullableStringOrBytes(schema)) {
                throw new InvalidPiiAnnotationException(breadcrumb);
            }
            this.onPiiField(field, breadcrumb);
        }
    }

    @Override
    public T getResult() {
        return null;
    }

    protected void onPiiField(Schema.Field field, Collection<String> breadcrumb) {
    }

    private static boolean isStringOrBytes(Schema schema) {
        Schema.Type type = schema.getType();
        return type == Schema.Type.STRING || type == Schema.Type.BYTES;
    }

    private static boolean isNullableStringOrBytes(Schema schema) {
        List types;
        Schema.Type type = schema.getType();
        return type == Schema.Type.UNION && (types = schema.getTypes().stream().map(Schema::getType).collect(Collectors.toList())).size() == 2 && types.contains(Schema.Type.NULL) && (types.contains(Schema.Type.STRING) || types.contains(Schema.Type.BYTES));
    }
}

