/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.road.schema.gdpr;

import com.hotels.road.schema.SchemaTraverser;
import com.hotels.road.schema.gdpr.InvalidPiiAnnotationException;
import com.hotels.road.schema.gdpr.PiiVisitor;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.avro.Schema;

public final class PiiSchemaEvolutionValidator {
    public static void validate(Schema newSchema, Optional<Schema> currentSchema) {
        currentSchema.ifPresent(current -> {
            Fields fields = SchemaTraverser.traverse(current, new FieldsVisitor());
            SchemaTraverser.traverse(newSchema, new ValidatingVisitor(fields));
        });
    }

    private static String path(Collection<String> breadcrumb) {
        return breadcrumb.stream().collect(Collectors.joining("/", "/", ""));
    }

    private PiiSchemaEvolutionValidator() {
    }

    static class Fields {
        private final List<String> all = new ArrayList<String>();
        private final List<String> pii = new ArrayList<String>();

        Fields() {
        }
    }

    static class ValidatingVisitor
    extends PiiVisitor<Void> {
        private final Fields fields;

        @Override
        protected void onPiiField(Schema.Field field, Collection<String> breadcrumb) {
            String path = PiiSchemaEvolutionValidator.path(breadcrumb);
            if (this.fields.all.contains(path) && !this.fields.pii.contains(path)) {
                throw new InvalidPiiAnnotationException(path);
            }
        }

        @ConstructorProperties(value={"fields"})
        public ValidatingVisitor(Fields fields) {
            this.fields = fields;
        }
    }

    static class FieldsVisitor
    extends PiiVisitor<Fields> {
        private final Fields fields = new Fields();

        FieldsVisitor() {
        }

        @Override
        public void onVisit(Schema.Field field, Collection<String> breadcrumb) {
            super.onVisit(field, breadcrumb);
            this.fields.all.add(PiiSchemaEvolutionValidator.path(breadcrumb));
        }

        @Override
        protected void onPiiField(Schema.Field field, Collection<String> breadcrumb) {
            this.fields.pii.add(PiiSchemaEvolutionValidator.path(breadcrumb));
        }

        @Override
        public Fields getResult() {
            return this.fields;
        }
    }
}

