/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.road.schema.gdpr;

import com.hotels.road.schema.gdpr.PiiVisitor;
import java.util.Collection;
import org.apache.avro.LogicalType;
import org.apache.avro.Schema;

public class PiiLogicalTypeVisitor
extends PiiVisitor<Void> {
    private static final LogicalType string = new LogicalType("pii-string");
    private static final LogicalType bytes = new LogicalType("pii-bytes");

    @Override
    protected void onPiiField(Schema.Field field, Collection<String> breadcrumb) {
        Schema schema = field.schema();
        if (schema.getType() == Schema.Type.UNION) {
            for (Schema type : schema.getTypes()) {
                this.addLogicalType(type);
            }
        } else {
            this.addLogicalType(schema);
        }
    }

    private void addLogicalType(Schema schema) {
        if (schema.getType() == Schema.Type.STRING) {
            string.addToSchema(schema);
        } else if (schema.getType() == Schema.Type.BYTES) {
            bytes.addToSchema(schema);
        }
    }
}

