/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.road.schema.chronology;

import com.hotels.avro.compatibility.ChronologyCompatibilityCheckResult;
import com.hotels.avro.compatibility.Compatibility;
import com.hotels.road.schema.chronology.SchemaCompatibilityException;
import java.beans.ConstructorProperties;
import java.util.Map;
import org.apache.avro.Schema;

public enum SchemaCompatibility {
    CAN_READ_ALL(Compatibility.Mode.CAN_READ_ALL),
    CAN_READ_LATEST(Compatibility.Mode.CAN_READ_LATEST),
    CAN_BE_READ_BY_ALL(Compatibility.Mode.CAN_BE_READ_BY_ALL),
    CAN_BE_READ_BY_LATEST(Compatibility.Mode.CAN_BE_READ_BY_LATEST),
    MUTUAL_READ_ALL(Compatibility.Mode.MUTUAL_READ_WITH_ALL),
    MUTUAL_READ_LATEST(Compatibility.Mode.MUTUAL_READ_WITH_LATEST);

    private final Compatibility.Mode compatibilityMode;

    public void validate(Schema toValidate, Map<Integer, Schema> existing) throws SchemaCompatibilityException {
        ChronologyCompatibilityCheckResult compatibilityResult = this.compatibilityMode.check(toValidate, existing.values());
        if (!compatibilityResult.isCompatible()) {
            throw new SchemaCompatibilityException(compatibilityResult.asMessage());
        }
    }

    @ConstructorProperties(value={"compatibilityMode"})
    private SchemaCompatibility(Compatibility.Mode compatibilityMode) {
        this.compatibilityMode = compatibilityMode;
    }
}

