/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.road.schema;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Stack;
import org.apache.avro.Schema;

public final class SchemaTraverser {
    public static <T> T traverse(Schema schema, Visitor<T> visitor) {
        return SchemaTraverser.traverse(schema, visitor, new Stack<String>());
    }

    private static <T> T traverse(Schema schema, Visitor<T> visitor, Stack<String> breadcrumb) {
        visitor.onVisit(schema, (Collection<String>)ImmutableList.copyOf(breadcrumb));
        switch (schema.getType()) {
            case RECORD: {
                for (Schema.Field field : schema.getFields()) {
                    breadcrumb.push(field.name());
                    visitor.onVisit(field, (Collection<String>)ImmutableList.copyOf(breadcrumb));
                    SchemaTraverser.traverse(field.schema(), visitor, breadcrumb);
                    breadcrumb.pop();
                }
                break;
            }
            case ARRAY: {
                breadcrumb.push("*");
                SchemaTraverser.traverse(schema.getElementType(), visitor, breadcrumb);
                breadcrumb.pop();
                break;
            }
            case MAP: {
                breadcrumb.push("*");
                SchemaTraverser.traverse(schema.getValueType(), visitor, breadcrumb);
                breadcrumb.pop();
                break;
            }
            case UNION: {
                int i = 0;
                for (Schema type : schema.getTypes()) {
                    breadcrumb.push(Integer.toString(i++));
                    SchemaTraverser.traverse(type, visitor, breadcrumb);
                    breadcrumb.pop();
                }
                break;
            }
        }
        if (breadcrumb.isEmpty()) {
            return visitor.getResult();
        }
        return null;
    }

    private SchemaTraverser() {
    }

    public static interface Visitor<T> {
        public void onVisit(Schema var1, Collection<String> var2);

        public void onVisit(Schema.Field var1, Collection<String> var2);

        public T getResult();
    }
}

