/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.auth.server;

import com.hortonworks.registries.auth.client.AuthenticationException;
import com.hortonworks.registries.auth.server.AuthenticationHandler;
import com.hortonworks.registries.auth.server.AuthenticationToken;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PseudoAuthenticationHandler
implements AuthenticationHandler {
    public static final String TYPE = "simple";
    public static final String ANONYMOUS_ALLOWED = "simple.anonymous.allowed";
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private static final String PSEUDO_AUTH = "PseudoAuth";
    private boolean acceptAnonymous;
    private String type;

    public PseudoAuthenticationHandler() {
        this(TYPE);
    }

    public PseudoAuthenticationHandler(String type) {
        this.type = type;
    }

    @Override
    public void init(Properties config) throws ServletException {
        this.acceptAnonymous = Boolean.parseBoolean(config.getProperty(ANONYMOUS_ALLOWED, "false"));
    }

    protected boolean getAcceptAnonymous() {
        return this.acceptAnonymous;
    }

    @Override
    public void destroy() {
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public boolean managementOperation(AuthenticationToken token, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationException {
        return true;
    }

    private String getUserName(HttpServletRequest request) {
        if (request.getQueryString() != null) {
            String[] pairs;
            for (String pair : pairs = request.getQueryString().split("&")) {
                int idx = pair.indexOf("=");
                try {
                    String value;
                    String key = idx > 0 ? URLDecoder.decode(pair.substring(0, idx), "UTF-8") : pair;
                    String string = value = idx > 0 && pair.length() > idx + 1 ? URLDecoder.decode(pair.substring(idx + 1), "UTF-8") : null;
                    if (!"user.name".equals(key)) continue;
                    return value;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return null;
    }

    @Override
    public AuthenticationToken authenticate(HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationException {
        AuthenticationToken token;
        String userName = this.getUserName(request);
        if (userName == null) {
            if (this.getAcceptAnonymous()) {
                token = AuthenticationToken.ANONYMOUS;
            } else {
                response.setStatus(403);
                response.setHeader("WWW-Authenticate", PSEUDO_AUTH);
                token = null;
            }
        } else {
            token = new AuthenticationToken(userName, userName, this.getType());
        }
        return token;
    }

    @Override
    public boolean shouldAuthenticate(HttpServletRequest request) {
        return true;
    }
}

