/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.auth.server;

import com.hortonworks.registries.auth.client.AuthenticationException;
import com.hortonworks.registries.auth.util.AuthToken;

public class AuthenticationToken
extends AuthToken {
    public static final AuthenticationToken ANONYMOUS = new AuthenticationToken();

    private AuthenticationToken() {
    }

    private AuthenticationToken(AuthToken token) {
        super(token.getUserName(), token.getName(), token.getType());
        this.setExpires(token.getExpires());
    }

    public AuthenticationToken(String userName, String principal, String type) {
        super(userName, principal, type);
    }

    @Override
    public void setExpires(long expires) {
        if (this != ANONYMOUS) {
            super.setExpires(expires);
        }
    }

    @Override
    public boolean isExpired() {
        return super.isExpired();
    }

    public static AuthenticationToken parse(String tokenStr) throws AuthenticationException {
        return new AuthenticationToken(AuthToken.parse(tokenStr));
    }
}

